/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.klib;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataVersion;
import org.jetbrains.kotlin.library.KotlinLibraryVersioning;
import org.jetbrains.kotlin.library.KotlinLibraryVersioningKt;
import org.jetbrains.kotlin.library.metadata.KlibMetadataDeserializationUtilsKt;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001a\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u0010J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0010J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0002RO\u0010\u0003\u001aC\u0012\u0016\u0012\u0014 \u0007*\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00060\u0005\u00a2\u0006\u0002\b\u0006\u0012\"\u0012 \u0012\u0004\u0012\u00020\t \u0007*\u000f\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\b\u00060\b\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RO\u0010\n\u001aC\u0012\u0016\u0012\u0014 \u0007*\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00060\u0005\u00a2\u0006\u0002\b\u0006\u0012\"\u0012 \u0012\u0004\u0012\u00020\u000b \u0007*\u000f\u0012\u0004\u0012\u00020\u000b\u0018\u00010\b\u00a2\u0006\u0002\b\u00060\b\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RO\u0010\f\u001aC\u0012\u0016\u0012\u0014 \u0007*\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00060\u0005\u00a2\u0006\u0002\b\u0006\u0012\"\u0012 \u0012\u0004\u0012\u00020\r \u0007*\u000f\u0012\u0004\u0012\u00020\r\u0018\u00010\b\u00a2\u0006\u0002\b\u00060\b\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/klib/KlibLoadingMetadataCache;", "", "()V", "libraryMetadataVersionCache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/idea/klib/KlibLoadingMetadataCache$CacheKey;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/idea/klib/KlibLoadingMetadataCache$CacheValue;", "Lorg/jetbrains/kotlin/backend/common/serialization/metadata/KlibMetadataVersion;", "moduleHeaderCache", "Lorg/jetbrains/kotlin/library/metadata/KlibMetadataProtoBuf$Header;", "packageFragmentCache", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "computeLibraryMetadataVersion", "manifestFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "computeModuleHeader", "moduleHeaderFile", "computePackageFragment", "packageFragmentFile", "getCachedModuleHeader", "getCachedPackageFragment", "isMetadataCompatible", "", "libraryRoot", "CacheKey", "CacheValue", "Companion", "kotlin.core"})
public final class KlibLoadingMetadataCache {
    private final ConcurrentMap<CacheKey, CacheValue<ProtoBuf.PackageFragment>> packageFragmentCache;
    private final ConcurrentMap<CacheKey, CacheValue<KlibMetadataProtoBuf.Header>> moduleHeaderCache;
    private final ConcurrentMap<CacheKey, CacheValue<KlibMetadataVersion>> libraryMetadataVersionCache;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final ProtoBuf.PackageFragment getCachedPackageFragment(@NotNull VirtualFile packageFragmentFile) {
        Intrinsics.checkNotNullParameter((Object)packageFragmentFile, (String)"packageFragmentFile");
        boolean bl = Intrinsics.areEqual((Object)packageFragmentFile.getExtension(), (Object)"knm");
        if (!bl) {
            boolean bl2 = false;
            String string = "Not a package metadata file: " + packageFragmentFile;
            throw new IllegalStateException(string.toString());
        }
        return this.packageFragmentCache.computeIfAbsent(new CacheKey(packageFragmentFile), new Function(this, packageFragmentFile){
            final /* synthetic */ KlibLoadingMetadataCache this$0;
            final /* synthetic */ VirtualFile $packageFragmentFile;

            @NotNull
            public final CacheValue<ProtoBuf.PackageFragment> apply(@NotNull CacheKey it) {
                return new CacheValue<ProtoBuf.PackageFragment>(KlibLoadingMetadataCache.access$computePackageFragment(this.this$0, this.$packageFragmentFile));
            }
            {
                this.this$0 = klibLoadingMetadataCache;
                this.$packageFragmentFile = virtualFile2;
            }
        }).getValue();
    }

    @Nullable
    public final KlibMetadataProtoBuf.Header getCachedModuleHeader(@NotNull VirtualFile moduleHeaderFile) {
        Intrinsics.checkNotNullParameter((Object)moduleHeaderFile, (String)"moduleHeaderFile");
        boolean bl = Intrinsics.areEqual((Object)moduleHeaderFile.getName(), (Object)"module");
        if (!bl) {
            boolean bl2 = false;
            String string = "Not a module header file: " + moduleHeaderFile;
            throw new IllegalStateException(string.toString());
        }
        return this.moduleHeaderCache.computeIfAbsent(new CacheKey(moduleHeaderFile), new Function(this, moduleHeaderFile){
            final /* synthetic */ KlibLoadingMetadataCache this$0;
            final /* synthetic */ VirtualFile $moduleHeaderFile;

            @NotNull
            public final CacheValue<KlibMetadataProtoBuf.Header> apply(@NotNull CacheKey it) {
                return new CacheValue<KlibMetadataProtoBuf.Header>(KlibLoadingMetadataCache.access$computeModuleHeader(this.this$0, this.$moduleHeaderFile));
            }
            {
                this.this$0 = klibLoadingMetadataCache;
                this.$moduleHeaderFile = virtualFile2;
            }
        }).getValue();
    }

    private final boolean isMetadataCompatible(VirtualFile libraryRoot) {
        VirtualFile virtualFile2 = libraryRoot.findChild("manifest");
        if (virtualFile2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"libraryRoot.findChild(KL\u2026ILE_NAME) ?: return false");
        VirtualFile manifestFile = virtualFile2;
        KlibMetadataVersion klibMetadataVersion = this.libraryMetadataVersionCache.computeIfAbsent(new CacheKey(manifestFile), new Function(this, manifestFile){
            final /* synthetic */ KlibLoadingMetadataCache this$0;
            final /* synthetic */ VirtualFile $manifestFile;

            @NotNull
            public final CacheValue<KlibMetadataVersion> apply(@NotNull CacheKey it) {
                return new CacheValue<KlibMetadataVersion>(KlibLoadingMetadataCache.access$computeLibraryMetadataVersion(this.this$0, this.$manifestFile));
            }
            {
                this.this$0 = klibLoadingMetadataCache;
                this.$manifestFile = virtualFile2;
            }
        }).getValue();
        if (klibMetadataVersion == null) {
            return false;
        }
        KlibMetadataVersion metadataVersion2 = klibMetadataVersion;
        return metadataVersion2.isCompatible();
    }

    private final ProtoBuf.PackageFragment computePackageFragment(VirtualFile packageFragmentFile) {
        ProtoBuf.PackageFragment packageFragment2;
        VirtualFile virtualFile2 = packageFragmentFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"packageFragmentFile.parent");
        VirtualFile virtualFile3 = virtualFile2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"packageFragmentFile.parent.parent");
        VirtualFile virtualFile4 = virtualFile3.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"packageFragmentFile.parent.parent.parent");
        if (!this.isMetadataCompatible(virtualFile4)) {
            return null;
        }
        try {
            byte[] byArray = packageFragmentFile.contentsToByteArray(false);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"packageFragmentFile.contentsToByteArray(false)");
            packageFragment2 = KlibMetadataDeserializationUtilsKt.parsePackageFragment((byte[])byArray);
        }
        catch (IOException iOException) {
            packageFragment2 = null;
        }
        return packageFragment2;
    }

    private final KlibMetadataProtoBuf.Header computeModuleHeader(VirtualFile moduleHeaderFile) {
        KlibMetadataProtoBuf.Header header;
        VirtualFile virtualFile2 = moduleHeaderFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"moduleHeaderFile.parent");
        VirtualFile virtualFile3 = virtualFile2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"moduleHeaderFile.parent.parent");
        if (!this.isMetadataCompatible(virtualFile3)) {
            return null;
        }
        try {
            byte[] byArray = moduleHeaderFile.contentsToByteArray(false);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"moduleHeaderFile.contentsToByteArray(false)");
            header = KlibMetadataDeserializationUtilsKt.parseModuleHeader((byte[])byArray);
        }
        catch (IOException iOException) {
            header = null;
        }
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final KlibMetadataVersion computeLibraryMetadataVersion(VirtualFile manifestFile) {
        try {
            Object object = new Properties();
            Properties $this$apply = object;
            boolean bl = false;
            Closeable closeable = manifestFile.getInputStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                $this$apply.load(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            KotlinLibraryVersioning versioning = KotlinLibraryVersioningKt.readKonanLibraryVersioning((Properties)object);
            String string = versioning.getMetadataVersion();
            Object object2 = string;
            if (string == null) return null;
            object = object2;
            $this$apply = BinaryVersion.Companion;
            Object p1 = object;
            boolean bl3 = false;
            int[] nArray = $this$apply.parseVersionArray((String)p1);
            object2 = nArray;
            if (nArray == null) return null;
            Object p12 = object = object2;
            boolean bl4 = false;
            KlibMetadataVersion klibMetadataVersion = new KlibMetadataVersion((int[])p12);
            return klibMetadataVersion;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public KlibLoadingMetadataCache() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ContainerUtil.createConc\u2026toBuf.PackageFragment>>()");
        this.packageFragmentCache = concurrentMap;
        ConcurrentMap concurrentMap2 = ContainerUtil.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"ContainerUtil.createConc\u2026tadataProtoBuf.Header>>()");
        this.moduleHeaderCache = concurrentMap2;
        ConcurrentMap concurrentMap3 = ContainerUtil.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap3, (String)"ContainerUtil.createConc\u2026e<KlibMetadataVersion>>()");
        this.libraryMetadataVersionCache = concurrentMap3;
    }

    public static final /* synthetic */ ProtoBuf.PackageFragment access$computePackageFragment(KlibLoadingMetadataCache $this, VirtualFile packageFragmentFile) {
        return $this.computePackageFragment(packageFragmentFile);
    }

    public static final /* synthetic */ KlibMetadataProtoBuf.Header access$computeModuleHeader(KlibLoadingMetadataCache $this, VirtualFile moduleHeaderFile) {
        return $this.computeModuleHeader(moduleHeaderFile);
    }

    public static final /* synthetic */ KlibMetadataVersion access$computeLibraryMetadataVersion(KlibLoadingMetadataCache $this, VirtualFile manifestFile) {
        return $this.computeLibraryMetadataVersion(manifestFile);
    }

    @JvmStatic
    @NotNull
    public static final KlibLoadingMetadataCache getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\bH\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/klib/KlibLoadingMetadataCache$CacheKey;", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "url", "", "modificationStamp", "", "(Ljava/lang/String;J)V", "getModificationStamp", "()J", "getUrl", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.core"})
    private static final class CacheKey {
        @NotNull
        private final String url;
        private final long modificationStamp;

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public final long getModificationStamp() {
            return this.modificationStamp;
        }

        public CacheKey(@NotNull String url, long modificationStamp) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
            this.modificationStamp = modificationStamp;
        }

        public CacheKey(@NotNull VirtualFile virtualFile2) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            String string = virtualFile2.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"virtualFile.url");
            this(string, virtualFile2.getModificationStamp());
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        public final long component2() {
            return this.modificationStamp;
        }

        @NotNull
        public final CacheKey copy(@NotNull String url, long modificationStamp) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new CacheKey(url, modificationStamp);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, String string, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = cacheKey.url;
            }
            if ((n & 2) != 0) {
                l = cacheKey.modificationStamp;
            }
            return cacheKey.copy(string, l);
        }

        @NotNull
        public String toString() {
            return "CacheKey(url=" + this.url + ", modificationStamp=" + this.modificationStamp + ")";
        }

        public int hashCode() {
            String string = this.url;
            return (string != null ? string.hashCode() : 0) * 31 + Long.hashCode(this.modificationStamp);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CacheKey)) break block3;
                    CacheKey cacheKey = (CacheKey)object;
                    if (!Intrinsics.areEqual((Object)this.url, (Object)cacheKey.url) || this.modificationStamp != cacheKey.modificationStamp) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0004R\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/klib/KlibLoadingMetadataCache$CacheValue;", "T", "", "value", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "kotlin.core"})
    private static final class CacheValue<T> {
        @Nullable
        private final T value;

        @Nullable
        public final T getValue() {
            return this.value;
        }

        public CacheValue(@Nullable T value2) {
            this.value = value2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/klib/KlibLoadingMetadataCache$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/klib/KlibLoadingMetadataCache;", "kotlin.core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final KlibLoadingMetadataCache getInstance() {
            Object object = ApplicationManager.getApplication().getService(KlibLoadingMetadataCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026etadataCache::class.java)");
            return (KlibLoadingMetadataCache)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

