/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.macros;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/macros/KotlinBundledRefresher;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "kotlin.idea"})
public final class KotlinBundledRefresher
implements StartupActivity.DumbAware {
    private static final String INSTALLED_KOTLIN_VERSION = "installed.kotlin.plugin.version";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void runActivity(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        String installedKotlinVersion = propertiesComponent.getValue(INSTALLED_KOTLIN_VERSION);
        if (Intrinsics.areEqual((Object)KotlinIdePlugin.INSTANCE.getVersion(), (Object)installedKotlinVersion) ^ true) {
            Path path2 = KotlinPluginLayout.Companion.getInstance().getKotlinc().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"KotlinPluginLayout.instance.kotlinc.toPath()");
            Companion.requestKotlinDistRefresh(path2);
            propertiesComponent.setValue(INSTALLED_KOTLIN_VERSION, KotlinIdePlugin.INSTANCE.getVersion());
        }
    }

    public KotlinBundledRefresher() {
        boolean $i$f$isUnitTestMode = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"ExtensionNotApplicableException.create()");
            throw (Throwable)extensionNotApplicableException;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/macros/KotlinBundledRefresher$Companion;", "", "()V", "INSTALLED_KOTLIN_VERSION", "", "requestFullJarUpdate", "", "jarFilePath", "Ljava/nio/file/Path;", "requestKotlinDistRefresh", "kotlinBundledPath", "kotlin.idea"})
    public static final class Companion {
        private final void requestFullJarUpdate(Path jarFilePath) {
            VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(jarFilePath);
            if (virtualFile2 == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"LocalFileSystem.getInsta\u2026le(jarFilePath) ?: return");
            VirtualFile localVirtualFile = virtualFile2;
            VirtualFile virtualFile3 = JarFileSystem.getInstance().getJarRootForLocalFile(localVirtualFile);
            if (virtualFile3 == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"JarFileSystem.getInstanc\u2026calVirtualFile) ?: return");
            VirtualFile jarFile = virtualFile3;
            VfsUtilCore.visitChildrenRecursively((VirtualFile)jarFile, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[0]){}));
            VirtualFile virtualFile4 = jarFile;
            if (virtualFile4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.vfs.newvfs.NewVirtualFile");
            }
            ((NewVirtualFile)virtualFile4).markDirtyRecursively();
        }

        /*
         * WARNING - void declaration
         */
        public final void requestKotlinDistRefresh(@NotNull Path kotlinBundledPath) {
            void $this$filterTo$iv$iv;
            Path path2;
            Intrinsics.checkNotNullParameter((Object)kotlinBundledPath, (String)"kotlinBundledPath");
            Path it = path2 = kotlinBundledPath.resolve("lib");
            boolean $i$a$-also-KotlinBundledRefresher$Companion$requestKotlinDistRefresh$22 = false;
            Path path3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"it");
            Path path4 = path3;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            boolean bl = Files.exists(path4, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            if (!bl) {
                boolean $i$a$-require-KotlinBundledRefresher$Companion$requestKotlinDistRefresh$1$22 = false;
                String $i$a$-require-KotlinBundledRefresher$Companion$requestKotlinDistRefresh$1$22 = "kotlin-dist invalid dir layout";
                throw new IllegalArgumentException($i$a$-require-KotlinBundledRefresher$Companion$requestKotlinDistRefresh$1$22.toString());
            }
            Path path5 = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"kotlinBundledPath.resolv\u2026t invalid dir layout\" } }");
            Iterable $this$filter$iv = PathsKt.listDirectoryEntries$default((Path)path5, null, (int)1, null);
            boolean $i$f$filter = false;
            Iterable $i$a$-also-KotlinBundledRefresher$Companion$requestKotlinDistRefresh$22 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path it2 = (Path)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)PathsKt.getExtension((Path)it2), (Object)"jar")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it3 = (Path)element$iv;
                boolean bl3 = false;
                Companion.requestFullJarUpdate(it3);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

