/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.ui;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchEditorsState;", "Lcom/intellij/openapi/editor/ex/FocusChangeListener;", "sourceEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "previewEditor", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/editor/ex/EditorEx;)V", "focusedEditor", "Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchEditorsState$FocusedEditor;", "getFocusedEditor", "()Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchEditorsState$FocusedEditor;", "lastFocusedEditor", "Lcom/intellij/openapi/editor/Editor;", "previewEditorCaretLine", "", "getPreviewEditorCaretLine", "()Ljava/lang/Integer;", "sourceEditorCaretLine", "getSourceEditorCaretLine", "focusGained", "", "editor", "focusLost", "FocusedEditor", "kotlin.jvm"})
final class ScratchEditorsState
implements FocusChangeListener {
    private Editor lastFocusedEditor;
    private final EditorEx sourceEditor;
    private final EditorEx previewEditor;

    @Nullable
    public final Integer getSourceEditorCaretLine() {
        CaretModel caretModel = this.sourceEditor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"sourceEditor.caretModel");
        List list2 = caretModel.getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"sourceEditor.caretModel.allCarets");
        Caret caret = (Caret)CollectionsKt.singleOrNull((List)list2);
        return caret != null && (caret = caret.getLogicalPosition()) != null ? Integer.valueOf(caret.line) : null;
    }

    @Nullable
    public final Integer getPreviewEditorCaretLine() {
        CaretModel caretModel = this.previewEditor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"previewEditor.caretModel");
        List list2 = caretModel.getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"previewEditor.caretModel.allCarets");
        Caret caret = (Caret)CollectionsKt.singleOrNull((List)list2);
        return caret != null && (caret = caret.getLogicalPosition()) != null ? Integer.valueOf(caret.line) : null;
    }

    @NotNull
    public final FocusedEditor getFocusedEditor() {
        return this.lastFocusedEditor == this.sourceEditor ? FocusedEditor.SOURCE : FocusedEditor.PREVIEW;
    }

    public void focusLost(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
    }

    public void focusGained(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.lastFocusedEditor = editor2;
    }

    public ScratchEditorsState(@NotNull EditorEx sourceEditor, @NotNull EditorEx previewEditor) {
        Intrinsics.checkNotNullParameter((Object)sourceEditor, (String)"sourceEditor");
        Intrinsics.checkNotNullParameter((Object)previewEditor, (String)"previewEditor");
        this.sourceEditor = sourceEditor;
        this.previewEditor = previewEditor;
        this.lastFocusedEditor = (Editor)this.sourceEditor;
        this.sourceEditor.addFocusListener((FocusChangeListener)this);
        this.previewEditor.addFocusListener((FocusChangeListener)this);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchEditorsState$FocusedEditor;", "", "(Ljava/lang/String;I)V", "SOURCE", "PREVIEW", "kotlin.jvm"})
    public static final class FocusedEditor
    extends Enum<FocusedEditor> {
        public static final /* enum */ FocusedEditor SOURCE;
        public static final /* enum */ FocusedEditor PREVIEW;
        private static final /* synthetic */ FocusedEditor[] $VALUES;

        static {
            FocusedEditor[] focusedEditorArray = new FocusedEditor[2];
            FocusedEditor[] focusedEditorArray2 = focusedEditorArray;
            focusedEditorArray[0] = SOURCE = new FocusedEditor();
            focusedEditorArray[1] = PREVIEW = new FocusedEditor();
            $VALUES = focusedEditorArray;
        }

        public static FocusedEditor[] values() {
            return (FocusedEditor[])$VALUES.clone();
        }

        public static FocusedEditor valueOf(String string) {
            return Enum.valueOf(FocusedEditor.class, string);
        }
    }
}

