/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.idea.base.psi.KotlinStubUtils;
import org.jetbrains.kotlin.idea.stubindex.IndexUtilsKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinAnnotationsIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinClassShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinExactPackagesIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeClassByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeFqNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFilePartClassIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFunctionShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinInnerTypeAliasClassIdIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinMultiFileClassPartIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinPrimeSymbolNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinProbablyContractedFunctionShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinProbablyNothingFunctionShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinProbablyNothingPropertyShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinPropertyShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinScriptFqnIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinSubclassObjectNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinSuperClassIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelClassByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTypeAliasShortNameIndex;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub;
import org.jetbrains.kotlin.psi.stubs.KotlinImportDirectiveStub;
import org.jetbrains.kotlin.psi.stubs.KotlinModifierListStub;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinParameterStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.KotlinScriptStub;
import org.jetbrains.kotlin.psi.stubs.KotlinStubWithFqName;
import org.jetbrains.kotlin.psi.stubs.KotlinTypeAliasStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;

public class IdeStubIndexService
extends StubIndexService {
    public void indexFile(@NotNull KotlinFileStub stub, @NotNull IndexSink sink) {
        List partNames;
        FqName partFqName;
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(0);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(1);
        }
        FqName packageFqName = stub.getPackageFqName();
        sink.occurrence(KotlinExactPackagesIndex.INSTANCE.getKey(), (Object)packageFqName.asString());
        if (stub.isScript()) {
            return;
        }
        FqName facadeFqName = ((KotlinFileStubImpl)stub).getFacadeFqName();
        if (facadeFqName != null) {
            sink.occurrence(KotlinFileFacadeFqNameIndex.INSTANCE.getKey(), (Object)facadeFqName.asString());
            sink.occurrence(KotlinFileFacadeShortNameIndex.INSTANCE.getKey(), (Object)facadeFqName.shortName().asString());
            sink.occurrence(KotlinFileFacadeClassByPackageIndex.INSTANCE.getKey(), (Object)packageFqName.asString());
        }
        if ((partFqName = ((KotlinFileStubImpl)stub).getPartFqName()) != null) {
            sink.occurrence(KotlinFilePartClassIndex.INSTANCE.getKey(), (Object)partFqName.asString());
        }
        if ((partNames = ((KotlinFileStubImpl)stub).getFacadePartSimpleNames()) != null) {
            for (String partName : partNames) {
                if (partName == null) continue;
                FqName multiFileClassPartFqName = packageFqName.child(Name.identifier((String)partName));
                sink.occurrence(KotlinMultiFileClassPartIndex.INSTANCE.getKey(), (Object)multiFileClassPartFqName.asString());
            }
        }
    }

    public void indexClass(@NotNull KotlinClassStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(2);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(3);
        }
        IdeStubIndexService.processNames(sink, stub.getName(), stub.getFqName(), stub.isTopLevel());
        if (stub.isInterface()) {
            sink.occurrence(KotlinClassShortNameIndex.INSTANCE.getKey(), (Object)"DefaultImpls");
        }
        IdeStubIndexService.indexSuperNames((KotlinClassOrObjectStub<? extends KtClassOrObject>)stub, sink);
        IdeStubIndexService.indexPrime(stub, sink);
    }

    private static void indexPrime(KotlinStubWithFqName<?> stub, IndexSink sink) {
        String name2 = stub.getName();
        if (name2 == null) {
            return;
        }
        KotlinModifierListStub modifierList = IdeStubIndexService.getModifierListStub(stub);
        if (modifierList != null && modifierList.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            return;
        }
        if (modifierList != null && modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return;
        }
        StubElement parent2 = stub.getParentStub();
        boolean prime = false;
        if (parent2 instanceof KotlinFileStub) {
            prime = true;
        } else if (parent2 instanceof KotlinObjectStub) {
            StubElement grand = parent2.getParentStub();
            boolean primeGrand = grand instanceof KotlinClassStub && ((KotlinClassStub)grand).isTopLevel();
            boolean bl = prime = ((KotlinObjectStub)parent2).isTopLevel() || primeGrand && ((KotlinObjectStub)parent2).isCompanion();
        }
        if (prime) {
            sink.occurrence(KotlinPrimeSymbolNameIndex.INSTANCE.getKey(), (Object)name2);
        }
    }

    public void indexObject(@NotNull KotlinObjectStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(4);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(5);
        }
        String shortName = stub.getName();
        IdeStubIndexService.processNames(sink, shortName, stub.getFqName(), stub.isTopLevel());
        IdeStubIndexService.indexSuperNames((KotlinClassOrObjectStub<? extends KtClassOrObject>)stub, sink);
        IdeStubIndexService.indexPrime(stub, sink);
        if (shortName != null && !stub.isObjectLiteral() && !stub.getSuperNames().isEmpty()) {
            sink.occurrence(KotlinSubclassObjectNameIndex.INSTANCE.getKey(), (Object)shortName);
        }
    }

    private static void processNames(@NotNull IndexSink sink, String shortName, FqName fqName2, boolean level) {
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(6);
        }
        if (shortName != null) {
            sink.occurrence(KotlinClassShortNameIndex.INSTANCE.getKey(), (Object)shortName);
        }
        if (fqName2 != null) {
            sink.occurrence(KotlinFullClassNameIndex.INSTANCE.getKey(), (Object)fqName2.asString());
            if (level) {
                sink.occurrence(KotlinTopLevelClassByPackageIndex.INSTANCE.getKey(), (Object)fqName2.parent().asString());
            }
        }
    }

    private static void indexSuperNames(KotlinClassOrObjectStub<? extends KtClassOrObject> stub, IndexSink sink) {
        for (String superName : stub.getSuperNames()) {
            sink.occurrence(KotlinSuperClassIndex.INSTANCE.getKey(), (Object)superName);
        }
        if (!(stub instanceof KotlinClassStub)) {
            return;
        }
        KotlinModifierListStub modifierListStub = IdeStubIndexService.getModifierListStub(stub);
        if (modifierListStub == null) {
            return;
        }
        if (modifierListStub.hasModifier(KtTokens.ENUM_KEYWORD)) {
            sink.occurrence(KotlinSuperClassIndex.INSTANCE.getKey(), (Object)Enum.class.getSimpleName());
        }
        if (modifierListStub.hasModifier(KtTokens.ANNOTATION_KEYWORD)) {
            sink.occurrence(KotlinSuperClassIndex.INSTANCE.getKey(), (Object)Annotation.class.getSimpleName());
        }
    }

    @Nullable
    private static KotlinModifierListStub getModifierListStub(@NotNull KotlinStubWithFqName<?> stub) {
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(7);
        }
        return (KotlinModifierListStub)stub.findChildStubByType((IStubElementType)KtStubElementTypes.MODIFIER_LIST);
    }

    public void indexFunction(@NotNull KotlinFunctionStub stub, @NotNull IndexSink sink) {
        FqName fqName2;
        String name2;
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(8);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(9);
        }
        if ((name2 = stub.getName()) != null) {
            KtTypeReference typeReference2;
            sink.occurrence(KotlinFunctionShortNameIndex.INSTANCE.getKey(), (Object)name2);
            if (IndexUtilsKt.isDeclaredInObject(stub)) {
                IndexUtilsKt.indexExtensionInObject(stub, sink);
            }
            if ((typeReference2 = ((KtNamedFunction)stub.getPsi()).getTypeReference()) != null && KotlinPsiHeuristics.isProbablyNothing(typeReference2)) {
                sink.occurrence(KotlinProbablyNothingFunctionShortNameIndex.INSTANCE.getKey(), (Object)name2);
            }
            if (stub.mayHaveContract()) {
                sink.occurrence(KotlinProbablyContractedFunctionShortNameIndex.INSTANCE.getKey(), (Object)name2);
            }
            IdeStubIndexService.indexPrime(stub, sink);
        }
        if (stub.isTopLevel() && (fqName2 = stub.getFqName()) != null) {
            sink.occurrence(KotlinTopLevelFunctionFqnNameIndex.INSTANCE.getKey(), (Object)fqName2.asString());
            sink.occurrence(KotlinTopLevelFunctionByPackageIndex.INSTANCE.getKey(), (Object)fqName2.parent().asString());
            IndexUtilsKt.indexTopLevelExtension(stub, sink);
        }
        IndexUtilsKt.indexInternals(stub, sink);
    }

    public void indexTypeAlias(@NotNull KotlinTypeAliasStub stub, @NotNull IndexSink sink) {
        ClassId classId;
        String name2;
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(10);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(11);
        }
        if ((name2 = stub.getName()) != null) {
            sink.occurrence(KotlinTypeAliasShortNameIndex.INSTANCE.getKey(), (Object)name2);
            IdeStubIndexService.indexPrime(stub, sink);
        }
        IndexUtilsKt.indexTypeAliasExpansion(stub, sink);
        FqName fqName2 = stub.getFqName();
        if (fqName2 != null && stub.isTopLevel()) {
            sink.occurrence(KotlinTopLevelTypeAliasFqNameIndex.INSTANCE.getKey(), (Object)fqName2.asString());
            sink.occurrence(KotlinTopLevelTypeAliasByPackageIndex.INSTANCE.getKey(), (Object)fqName2.parent().asString());
        }
        if ((classId = stub.getClassId()) != null && !stub.isTopLevel()) {
            sink.occurrence(KotlinInnerTypeAliasClassIdIndex.INSTANCE.getKey(), (Object)classId.asString());
        }
    }

    public void indexProperty(@NotNull KotlinPropertyStub stub, @NotNull IndexSink sink) {
        FqName fqName2;
        String name2;
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(12);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(13);
        }
        if ((name2 = stub.getName()) != null) {
            KtTypeReference typeReference2;
            sink.occurrence(KotlinPropertyShortNameIndex.INSTANCE.getKey(), (Object)name2);
            if (IndexUtilsKt.isDeclaredInObject(stub)) {
                IndexUtilsKt.indexExtensionInObject(stub, sink);
            }
            if ((typeReference2 = ((KtProperty)stub.getPsi()).getTypeReference()) != null && KotlinPsiHeuristics.isProbablyNothing(typeReference2)) {
                sink.occurrence(KotlinProbablyNothingPropertyShortNameIndex.INSTANCE.getKey(), (Object)name2);
            }
            IdeStubIndexService.indexPrime(stub, sink);
        }
        if (stub.isTopLevel() && (fqName2 = stub.getFqName()) != null) {
            sink.occurrence(KotlinTopLevelPropertyFqnNameIndex.INSTANCE.getKey(), (Object)fqName2.asString());
            sink.occurrence(KotlinTopLevelPropertyByPackageIndex.INSTANCE.getKey(), (Object)fqName2.parent().asString());
            IndexUtilsKt.indexTopLevelExtension(stub, sink);
        }
        IndexUtilsKt.indexInternals(stub, sink);
    }

    public void indexParameter(@NotNull KotlinParameterStub stub, @NotNull IndexSink sink) {
        String name2;
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(14);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(15);
        }
        if ((name2 = stub.getName()) != null && stub.hasValOrVar()) {
            sink.occurrence(KotlinPropertyShortNameIndex.INSTANCE.getKey(), (Object)name2);
        }
    }

    public void indexAnnotation(@NotNull KotlinAnnotationEntryStub stub, @NotNull IndexSink sink) {
        String name2;
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(16);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(17);
        }
        if ((name2 = stub.getShortName()) == null) {
            return;
        }
        sink.occurrence(KotlinAnnotationsIndex.INSTANCE.getKey(), (Object)name2);
        KotlinFileStub fileStub = KotlinStubUtils.getContainingKotlinFileStub(stub);
        if (fileStub != null) {
            List aliasImportStubs = fileStub.findImportsByAlias(name2);
            for (KotlinImportDirectiveStub importStub : aliasImportStubs) {
                FqName importedFqName = importStub.getImportedFqName();
                if (importedFqName == null) continue;
                sink.occurrence(KotlinAnnotationsIndex.INSTANCE.getKey(), (Object)importedFqName.shortName().asString());
            }
        }
        IndexUtilsKt.indexJvmNameAnnotation(stub, sink);
    }

    public void indexScript(@NotNull KotlinScriptStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(18);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(19);
        }
        sink.occurrence(KotlinScriptFqnIndex.INSTANCE.getKey(), (Object)stub.getFqName().asString());
    }

    @NotNull
    public KotlinFileStub createFileStub(@NotNull KtFile file2) {
        if (file2 == null) {
            IdeStubIndexService.$$$reportNull$$$0(20);
        }
        String packageFqName = file2.getPackageFqNameByTree().asString();
        boolean isScript = file2.isScriptByTree();
        if (file2.hasTopLevelCallables()) {
            JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)file2);
            String facadeFqNameRef = fileClassInfo.getFacadeClassFqName().asString();
            String partSimpleName = fileClassInfo.getFileClassFqName().shortName().asString();
            return new KotlinFileStubImpl(file2, packageFqName, isScript, facadeFqNameRef, partSimpleName, null);
        }
        return new KotlinFileStubImpl(file2, packageFqName, isScript, null, null, null);
    }

    public void serializeFileStub(@NotNull KotlinFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(21);
        }
        if (dataStream == null) {
            IdeStubIndexService.$$$reportNull$$$0(22);
        }
        KotlinFileStubImpl fileStub = (KotlinFileStubImpl)stub;
        dataStream.writeName(fileStub.getPackageFqName().asString());
        dataStream.writeBoolean(fileStub.isScript());
        FqName facadeFqName = fileStub.getFacadeFqName();
        dataStream.writeName(facadeFqName != null ? facadeFqName.asString() : null);
        dataStream.writeName(fileStub.getPartSimpleName());
        List facadePartNames = fileStub.getFacadePartSimpleNames();
        if (facadePartNames == null) {
            dataStream.writeInt(0);
        } else {
            dataStream.writeInt(facadePartNames.size());
            for (String partName : facadePartNames) {
                dataStream.writeName(partName);
            }
        }
    }

    @NotNull
    public KotlinFileStub deserializeFileStub(@NotNull StubInputStream dataStream) throws IOException {
        String packageFqNameAsString;
        if (dataStream == null) {
            IdeStubIndexService.$$$reportNull$$$0(23);
        }
        if ((packageFqNameAsString = dataStream.readNameString()) == null) {
            throw new IllegalStateException("Can't read package fqname from stream");
        }
        boolean isScript = dataStream.readBoolean();
        String facadeString = dataStream.readNameString();
        String partSimpleName = dataStream.readNameString();
        int numPartNames = dataStream.readInt();
        ArrayList<String> facadePartNames = new ArrayList<String>();
        for (int i = 0; i < numPartNames; ++i) {
            String partNameRef = dataStream.readNameString();
            facadePartNames.add(partNameRef);
        }
        return new KotlinFileStubImpl(null, packageFqNameAsString, isScript, facadeString, partSimpleName, facadePartNames);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/stubindex/IdeStubIndexService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "indexFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "indexClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "indexObject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processNames";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getModifierListStub";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "indexFunction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "indexTypeAlias";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "indexProperty";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "indexParameter";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "indexAnnotation";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "indexScript";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileStub";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "serializeFileStub";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "deserializeFileStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

