/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.repositories.RepositoryResourceAccessor;
import org.gradle.api.internal.artifacts.repositories.resolver.DefaultExternalResourceAccessor;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceAccessor;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.resolve.caching.ImplicitInputRecord;
import org.gradle.internal.resolve.caching.ImplicitInputRecorder;
import org.gradle.internal.resolve.caching.ImplicitInputsProvidingService;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;

public class ExternalRepositoryResourceAccessor
implements RepositoryResourceAccessor,
ImplicitInputsProvidingService<String, Long, RepositoryResourceAccessor> {
    private static final String SERVICE_TYPE = RepositoryResourceAccessor.class.getName();
    private final URI rootUri;
    private final String rootUriAsString;
    private final ExternalResourceAccessor resourceResolver;

    public ExternalRepositoryResourceAccessor(URI rootUri, CacheAwareExternalResourceAccessor cacheAwareExternalResourceAccessor, FileStore<String> fileStore) {
        this.rootUri = rootUri;
        this.rootUriAsString = rootUri.toString();
        this.resourceResolver = new DefaultExternalResourceAccessor(fileStore, cacheAwareExternalResourceAccessor);
    }

    @Override
    public void withResource(String relativePath, Action<? super InputStream> action) {
        ExternalResourceName location = new ExternalResourceName(this.rootUri, relativePath);
        LocallyAvailableExternalResource resource = this.resourceResolver.resolveResource(location);
        if (resource != null) {
            resource.withContent(action);
        }
    }

    @Override
    public RepositoryResourceAccessor withImplicitInputRecorder(ImplicitInputRecorder registrar) {
        return (relativePath, action) -> {
            ExternalResourceName location = new ExternalResourceName(this.rootUri, relativePath);
            LocallyAvailableExternalResource resource = this.resourceResolver.resolveResource(location);
            registrar.register(SERVICE_TYPE, new ServiceCall(this.rootUriAsString + ";" + relativePath, ExternalRepositoryResourceAccessor.hashFor(resource)));
            if (resource != null) {
                resource.withContent(action);
            }
        };
    }

    @Nullable
    private static Long hashFor(@Nullable LocallyAvailableExternalResource resource) {
        return resource == null ? null : Long.valueOf(resource.getMetaData().getLastModified().getTime());
    }

    @Override
    public boolean isUpToDate(String resource, @Nullable Long oldValue) {
        String[] parts = resource.split(";");
        if (!this.rootUriAsString.equals(parts[0])) {
            return false;
        }
        ExternalResourceName externalResourceName = new ExternalResourceName(this.rootUri, parts[1]);
        LocallyAvailableExternalResource locallyAvailableExternalResource = this.resourceResolver.resolveResource(externalResourceName);
        return Objects.equal((Object)oldValue, (Object)ExternalRepositoryResourceAccessor.hashFor(locallyAvailableExternalResource));
    }

    private static class ServiceCall
    implements ImplicitInputRecord<String, Long> {
        private final String resource;
        private final Long hash;

        private ServiceCall(String resource, @Nullable Long resourceHash) {
            this.resource = resource;
            this.hash = resourceHash;
        }

        @Override
        public String getInput() {
            return this.resource;
        }

        @Override
        public Long getOutput() {
            return this.hash;
        }
    }
}

