/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import javax.inject.Inject;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import org.gradle.api.internal.catalog.DependencyBundleValueSource;
import org.gradle.api.internal.catalog.DependencyValueSource;
import org.gradle.api.internal.catalog.ExternalModuleDependencyFactory;
import org.gradle.api.internal.catalog.PluginDependencyValueSource;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.plugin.use.PluginDependency;

public abstract class AbstractExternalDependencyFactory
implements ExternalModuleDependencyFactory {
    protected final DefaultVersionCatalog config;
    protected final ProviderFactory providers;

    @Inject
    protected AbstractExternalDependencyFactory(DefaultVersionCatalog config, ProviderFactory providers) {
        this.config = config;
        this.providers = providers;
    }

    @Override
    public Provider<MinimalExternalModuleDependency> create(String alias) {
        return this.providers.of(DependencyValueSource.class, spec -> ((DependencyValueSource.Params)spec.getParameters()).getDependencyData().set(this.config.getDependencyData(alias)));
    }

    public static class PluginFactory {
        protected final ProviderFactory providers;
        protected final DefaultVersionCatalog config;

        public PluginFactory(ProviderFactory providers, DefaultVersionCatalog config) {
            this.providers = providers;
            this.config = config;
        }

        protected Provider<PluginDependency> createPlugin(String name) {
            return this.providers.of(PluginDependencyValueSource.class, spec -> spec.parameters(params -> {
                params.getConfig().set(this.config);
                params.getPluginName().set(name);
            }));
        }
    }

    public static class BundleFactory {
        protected final ProviderFactory providers;
        protected final DefaultVersionCatalog config;

        public BundleFactory(ProviderFactory providers, DefaultVersionCatalog config) {
            this.providers = providers;
            this.config = config;
        }

        protected Provider<ExternalModuleDependencyBundle> createBundle(String name) {
            return this.providers.of(DependencyBundleValueSource.class, spec -> spec.parameters(params -> {
                params.getConfig().set(this.config);
                params.getBundleName().set(name);
            }));
        }
    }

    public static class VersionFactory {
        protected final ProviderFactory providers;
        protected final DefaultVersionCatalog config;

        public VersionFactory(ProviderFactory providers, DefaultVersionCatalog config) {
            this.providers = providers;
            this.config = config;
        }

        protected Provider<String> getVersion(String name) {
            return this.providers.provider(() -> this.doGetVersion(name));
        }

        private String doGetVersion(String name) {
            ImmutableVersionConstraint version = this.findVersionConstraint(name);
            String requiredVersion = version.getRequiredVersion();
            if (!requiredVersion.isEmpty()) {
                return requiredVersion;
            }
            String strictVersion = version.getStrictVersion();
            if (!strictVersion.isEmpty()) {
                return strictVersion;
            }
            return version.getPreferredVersion();
        }

        protected ImmutableVersionConstraint findVersionConstraint(String name) {
            return this.config.getVersion(name).getVersion();
        }
    }

    public static abstract class SubDependencyFactory
    implements ExternalModuleDependencyFactory {
        protected final AbstractExternalDependencyFactory owner;

        protected SubDependencyFactory(AbstractExternalDependencyFactory owner) {
            this.owner = owner;
        }

        @Override
        public Provider<MinimalExternalModuleDependency> create(String alias) {
            return this.owner.create(alias);
        }
    }
}

