/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.catalog.AbstractProjectAccessorsSourceGenerator;

public class ProjectAccessorsSourceGenerator
extends AbstractProjectAccessorsSourceGenerator {
    public ProjectAccessorsSourceGenerator(Writer writer2) {
        super(writer2);
    }

    public static String generateSource(Writer writer2, ProjectDescriptor current, String packageName) {
        ProjectAccessorsSourceGenerator generator = new ProjectAccessorsSourceGenerator(writer2);
        try {
            String className = ProjectAccessorsSourceGenerator.toClassName(current.getPath(), ProjectAccessorsSourceGenerator.rootProjectName(current));
            generator.generate(packageName, className, current);
            return className;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void generate(String packageName, String className, ProjectDescriptor current) throws IOException {
        this.writeHeader(packageName);
        this.writeLn("@NonNullApi");
        this.writeLn("public class " + className + " extends DelegatingProjectDependency {");
        this.writeLn();
        this.writeLn("    @Inject");
        this.writeLn("    public " + className + "(TypeSafeProjectDependencyFactory factory, ProjectDependencyInternal delegate) {");
        this.writeLn("        super(factory, delegate);");
        this.writeLn("    }");
        this.writeLn();
        this.processChildren(current);
        this.writeLn("}");
    }
}

