/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.bundling;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.internal.file.copy.RenamingCopyAction;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.internal.Transformers;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public class War
extends Jar {
    public static final String WAR_EXTENSION = "war";
    private File webXml;
    private FileCollection classpath;
    private final DefaultCopySpec webInf;
    private final DirectoryProperty webAppDirectory;

    public War() {
        this.getArchiveExtension().set(WAR_EXTENSION);
        this.setMetadataCharset("UTF-8");
        this.webInf = (DefaultCopySpec)this.getRootSpec().addChildBeforeSpec(this.getMainSpec()).into("WEB-INF");
        this.webInf.into((Object)"classes", (? super CopySpec spec) -> spec.from(() -> {
            FileCollection classpath = this.getClasspath();
            return classpath != null ? classpath.filter(SerializableLambdas.spec(File::isDirectory)) : Collections.emptyList();
        }));
        this.webInf.into((Object)"lib", (? super CopySpec spec) -> spec.from(() -> {
            FileCollection classpath = this.getClasspath();
            return classpath != null ? classpath.filter(SerializableLambdas.spec(File::isFile)) : Collections.emptyList();
        }));
        CopySpecInternal renameSpec = this.webInf.addChild();
        renameSpec.into("");
        renameSpec.from(this::getWebXml);
        renameSpec.appendCachingSafeCopyAction(new RenamingCopyAction(Transformers.constant("web.xml")));
        this.webAppDirectory = this.getObjectFactory().directoryProperty();
    }

    @Override
    @Inject
    public ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Internal
    public CopySpec getWebInf() {
        return this.webInf.addChild();
    }

    public CopySpec webInf(Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.getWebInf());
    }

    public CopySpec webInf(Action<? super CopySpec> configureAction) {
        CopySpec webInf = this.getWebInf();
        configureAction.execute(webInf);
        return webInf;
    }

    @Nullable
    @Optional
    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.setClasspath((Object)classpath);
    }

    public void setClasspath(Object classpath) {
        this.classpath = this.getProject().files(classpath);
    }

    public void classpath(Object ... classpath) {
        FileCollection oldClasspath = this.getClasspath();
        this.classpath = this.getProject().files(oldClasspath != null ? oldClasspath : new ArrayList(), classpath);
    }

    @Nullable
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    public File getWebXml() {
        return this.webXml;
    }

    public void setWebXml(@Nullable File webXml) {
        this.webXml = webXml;
    }

    @Incubating
    @Internal
    public DirectoryProperty getWebAppDirectory() {
        return this.webAppDirectory;
    }
}

