/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultNamedDomainObjectSet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.internal.VisualStudioTargetBinary;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;

public class VisualStudioProjectRegistry
extends DefaultNamedDomainObjectSet<DefaultVisualStudioProject> {
    private final FileResolver fileResolver;
    private final IdeArtifactRegistry ideArtifactRegistry;
    private final ObjectFactory objectFactory;
    private final ProviderFactory providerFactory;

    public VisualStudioProjectRegistry(FileResolver fileResolver, Instantiator instantiator, IdeArtifactRegistry ideArtifactRegistry, CollectionCallbackActionDecorator collectionCallbackActionDecorator, ObjectFactory objectFactory, ProviderFactory providerFactory) {
        super(DefaultVisualStudioProject.class, instantiator, collectionCallbackActionDecorator);
        this.fileResolver = fileResolver;
        this.ideArtifactRegistry = ideArtifactRegistry;
        this.objectFactory = objectFactory;
        this.providerFactory = providerFactory;
    }

    public VisualStudioProjectConfiguration getProjectConfiguration(VisualStudioTargetBinary targetBinary) {
        String projectName = targetBinary.getVisualStudioProjectName();
        return ((DefaultVisualStudioProject)this.getByName(projectName)).getConfiguration(targetBinary);
    }

    public VisualStudioProjectConfiguration addProjectConfiguration(VisualStudioTargetBinary nativeBinary) {
        DefaultVisualStudioProject project = this.getOrCreateProject(nativeBinary.getVisualStudioProjectName(), nativeBinary.getComponentName());
        project.getSdkVersion().set(nativeBinary.getSdkVersion());
        project.getVisualStudioVersion().set(nativeBinary.getVisualStudioVersion());
        VisualStudioProjectConfiguration configuration2 = this.createVisualStudioProjectConfiguration(project, nativeBinary, nativeBinary.getVisualStudioConfigurationName());
        project.addConfiguration(nativeBinary, configuration2);
        return configuration2;
    }

    private VisualStudioProjectConfiguration createVisualStudioProjectConfiguration(VisualStudioProject project, VisualStudioTargetBinary nativeBinary, String configuration2) {
        return this.getInstantiator().newInstance(VisualStudioProjectConfiguration.class, project, configuration2, nativeBinary);
    }

    public DefaultVisualStudioProject createProject(String vsProjectName, String componentName) {
        assert (this.findByName(vsProjectName) == null);
        DefaultVisualStudioProject vsProject = this.getInstantiator().newInstance(DefaultVisualStudioProject.class, vsProjectName, componentName, this.fileResolver, this.objectFactory, this.providerFactory);
        this.add(vsProject);
        this.ideArtifactRegistry.registerIdeProject(vsProject.getPublishArtifact());
        return vsProject;
    }

    private DefaultVisualStudioProject getOrCreateProject(String vsProjectName, String componentName) {
        DefaultVisualStudioProject vsProject = (DefaultVisualStudioProject)this.findByName(vsProjectName);
        if (vsProject == null) {
            vsProject = this.createProject(vsProjectName, componentName);
        }
        return vsProject;
    }
}

