/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nonnull;
import org.gradle.StartParameter;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.impldep.com.google.common.base.Charsets;
import org.gradle.internal.impldep.com.google.common.base.StandardSystemProperty;
import org.gradle.internal.impldep.com.google.common.io.FileWriteMode;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.impldep.com.google.common.io.LineProcessor;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.internal.operations.trace.BuildOperationRecord;
import org.gradle.internal.operations.trace.BuildOperationTree;
import org.gradle.internal.operations.trace.CustomOperationTraceSerialization;
import org.gradle.internal.operations.trace.SerializedOperation;
import org.gradle.internal.operations.trace.SerializedOperationFinish;
import org.gradle.internal.operations.trace.SerializedOperationProgress;
import org.gradle.internal.operations.trace.SerializedOperationStart;
import org.gradle.util.internal.GFileUtils;

public class BuildOperationTrace
implements Stoppable {
    public static final String SYSPROP = "org.gradle.internal.operations.trace";
    private static final byte[] NEWLINE = "\n".getBytes();
    private final String basePath;
    private final OutputStream logOutputStream;
    private final BuildOperationListenerManager buildOperationListenerManager;
    private final BuildOperationListener listener = new BuildOperationListener(){

        @Override
        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            BuildOperationTrace.this.write(new SerializedOperationStart(buildOperation, startEvent));
        }

        @Override
        public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
            BuildOperationTrace.this.write(new SerializedOperationProgress(buildOperationId, progressEvent));
        }

        @Override
        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            BuildOperationTrace.this.write(new SerializedOperationFinish(buildOperation, finishEvent));
        }
    };

    public BuildOperationTrace(StartParameter startParameter, BuildOperationListenerManager buildOperationListenerManager) {
        this.buildOperationListenerManager = buildOperationListenerManager;
        Map<String, String> sysProps = startParameter.getSystemPropertiesArgs();
        String basePath = sysProps.get(SYSPROP);
        if (basePath == null) {
            basePath = System.getProperty(SYSPROP);
        }
        this.basePath = basePath;
        if (this.basePath == null || basePath.equals(Boolean.FALSE.toString())) {
            this.logOutputStream = null;
            return;
        }
        try {
            File logFile = BuildOperationTrace.logFile(basePath);
            GFileUtils.mkdirs(logFile.getParentFile());
            if (logFile.isFile()) {
                GFileUtils.forceDelete(logFile);
            }
            logFile.createNewFile();
            this.logOutputStream = new BufferedOutputStream(new FileOutputStream(logFile));
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        buildOperationListenerManager.addListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.buildOperationListenerManager.removeListener(this.listener);
        if (this.logOutputStream != null) {
            try {
                OutputStream outputStream = this.logOutputStream;
                synchronized (outputStream) {
                    this.logOutputStream.close();
                }
                List<BuildOperationRecord> roots = BuildOperationTrace.readLogToTreeRoots(BuildOperationTrace.logFile(this.basePath));
                this.writeDetailTree(roots);
                this.writeSummaryTree(roots);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(SerializedOperation operation) {
        Thread currentThread = Thread.currentThread();
        ClassLoader previousClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(JsonOutput.class.getClassLoader());
        try {
            String json = JsonOutput.toJson(operation.toMap());
            try {
                OutputStream outputStream = this.logOutputStream;
                synchronized (outputStream) {
                    this.logOutputStream.write(json.getBytes(StandardCharsets.UTF_8));
                    this.logOutputStream.write(NEWLINE);
                    this.logOutputStream.flush();
                }
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
        finally {
            currentThread.setContextClassLoader(previousClassLoader);
        }
    }

    private void writeDetailTree(List<BuildOperationRecord> roots) throws IOException {
        try {
            String rawJson = JsonOutput.toJson(BuildOperationTree.serialize(roots));
            String prettyJson = JsonOutput.prettyPrint((String)rawJson);
            Files.asCharSink((File)BuildOperationTrace.file(this.basePath, "-tree.json"), (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)prettyJson);
        }
        catch (OutOfMemoryError e) {
            System.err.println("Failed to write build operation trace JSON due to out of memory.");
        }
    }

    private void writeSummaryTree(final List<BuildOperationRecord> roots) throws IOException {
        Files.asCharSink((File)BuildOperationTrace.file(this.basePath, "-tree.txt"), (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).writeLines((Iterable)new Iterable<String>(){

            @Override
            @Nonnull
            public Iterator<String> iterator() {
                final ArrayDeque stack = new ArrayDeque(Collections.singleton(new ArrayDeque(roots)));
                final StringBuilder stringBuilder = new StringBuilder();
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        if (stack.isEmpty()) {
                            return false;
                        }
                        if (((Queue)stack.peek()).isEmpty()) {
                            stack.pop();
                            return this.hasNext();
                        }
                        return true;
                    }

                    @Override
                    public String next() {
                        Queue children = (Queue)stack.element();
                        BuildOperationRecord record = (BuildOperationRecord)children.remove();
                        stringBuilder.setLength(0);
                        int indents = stack.size() - 1;
                        for (int i = 0; i < indents; ++i) {
                            stringBuilder.append("  ");
                        }
                        if (!record.children.isEmpty()) {
                            stack.addFirst(new ArrayDeque<BuildOperationRecord>(record.children));
                        }
                        stringBuilder.append(record.displayName);
                        if (record.details != null) {
                            stringBuilder.append(" ");
                            stringBuilder.append(JsonOutput.toJson(record.details));
                        }
                        if (record.result != null) {
                            stringBuilder.append(" ");
                            stringBuilder.append(JsonOutput.toJson(record.result));
                        }
                        stringBuilder.append(" [");
                        stringBuilder.append(record.endTime - record.startTime);
                        stringBuilder.append("ms]");
                        stringBuilder.append(" (");
                        stringBuilder.append(record.id);
                        stringBuilder.append(")");
                        if (!record.progress.isEmpty()) {
                            for (BuildOperationRecord.Progress progress : record.progress) {
                                stringBuilder.append(StandardSystemProperty.LINE_SEPARATOR.value());
                                for (int i = 0; i < indents; ++i) {
                                    stringBuilder.append("  ");
                                }
                                stringBuilder.append("- ").append(progress.details).append(" [").append(progress.time - record.startTime).append("]");
                            }
                        }
                        return stringBuilder.toString();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    public static BuildOperationTree read(String basePath) {
        File logFile = BuildOperationTrace.logFile(basePath);
        List<BuildOperationRecord> roots = BuildOperationTrace.readLogToTreeRoots(logFile);
        return new BuildOperationTree(roots);
    }

    private static List<BuildOperationRecord> readLogToTreeRoots(final File logFile) {
        try {
            final JsonSlurper slurper = new JsonSlurper();
            final ArrayList<BuildOperationRecord> roots = new ArrayList<BuildOperationRecord>();
            final HashMap pendings = new HashMap();
            final HashMap childrens = new HashMap();
            Files.asCharSource((File)logFile, (Charset)Charsets.UTF_8).readLines((LineProcessor)new LineProcessor<Void>(){

                public boolean processLine(String line) {
                    Map map = (Map)Cast.uncheckedNonnullCast(slurper.parseText(line));
                    if (map.containsKey("startTime")) {
                        SerializedOperationStart serialized = new SerializedOperationStart(map);
                        pendings.put(serialized.id, new PendingOperation(serialized));
                        childrens.put(serialized.id, new LinkedList());
                    } else if (map.containsKey("time")) {
                        SerializedOperationProgress serialized = new SerializedOperationProgress(map);
                        PendingOperation pending = (PendingOperation)pendings.get(serialized.id);
                        assert (pending != null) : "did not find owner of progress event with ID " + serialized.id;
                        pending.progress.add(serialized);
                    } else {
                        SerializedOperationFinish finish = new SerializedOperationFinish(map);
                        PendingOperation pending = (PendingOperation)pendings.remove(finish.id);
                        assert (pending != null);
                        List children = (List)childrens.remove(finish.id);
                        assert (children != null);
                        SerializedOperationStart start = pending.start;
                        Map detailsMap = (Map)Cast.uncheckedCast(start.details);
                        Map resultMap = (Map)Cast.uncheckedCast(finish.result);
                        ArrayList<BuildOperationRecord.Progress> progresses = new ArrayList<BuildOperationRecord.Progress>();
                        for (SerializedOperationProgress progress : pending.progress) {
                            Map progressDetailsMap = (Map)Cast.uncheckedCast(progress.details);
                            progresses.add(new BuildOperationRecord.Progress(progress.time, progressDetailsMap, progress.detailsClassName));
                        }
                        BuildOperationRecord record = new BuildOperationRecord(start.id, start.parentId, start.displayName, start.startTime, finish.endTime, detailsMap == null ? null : Collections.unmodifiableMap(detailsMap), start.detailsClassName, resultMap == null ? null : Collections.unmodifiableMap(resultMap), finish.resultClassName, finish.failureMsg, progresses, (List<BuildOperationRecord>)BuildOperationRecord.ORDERING.immutableSortedCopy((Iterable)children));
                        if (start.parentId == null) {
                            roots.add(record);
                        } else {
                            List parentChildren = (List)childrens.get(start.parentId);
                            assert (parentChildren != null) : "parentChildren != null '" + line + "' from " + logFile;
                            parentChildren.add(record);
                        }
                    }
                    return true;
                }

                public Void getResult() {
                    return null;
                }
            });
            assert (pendings.isEmpty());
            return roots;
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private static File logFile(String basePath) {
        return BuildOperationTrace.file(basePath, "-log.txt");
    }

    private static File file(String base, String suffix) {
        return new File((base == null || base.trim().isEmpty() ? "operations" : base) + suffix).getAbsoluteFile();
    }

    public static Object toSerializableModel(Object object) {
        if (object instanceof CustomOperationTraceSerialization) {
            return ((CustomOperationTraceSerialization)object).getCustomOperationTraceSerializableModel();
        }
        return object;
    }

    static class PendingOperation {
        final SerializedOperationStart start;
        final List<SerializedOperationProgress> progress = new ArrayList<SerializedOperationProgress>();

        PendingOperation(SerializedOperationStart start) {
            this.start = start;
        }
    }
}

