/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal;

import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

public abstract class Names {
    public static Names of(String name) {
        if (name.equals("main")) {
            return new Main();
        }
        return new Other(name, name);
    }

    public static Names of(String name, String baseName) {
        return new Other(name, baseName);
    }

    public abstract Names append(String var1);

    public abstract String getName();

    public abstract String getBaseName();

    public abstract String getLowerBaseName();

    public abstract String withPrefix(String var1);

    public abstract String withSuffix(String var1);

    public abstract String getTaskName(String var1);

    public abstract String getCompileTaskName(String var1);

    public abstract String getDirName();

    private static class Other
    extends Names {
        private final String name;
        private final String baseName;
        private final String lowerBaseName;
        private final String capitalizedBaseName;
        private final String dirName;

        Other(String rawName, String name) {
            int i;
            this.name = rawName;
            StringBuilder baseName = new StringBuilder();
            StringBuilder lowerBaseName = new StringBuilder();
            StringBuilder capBaseName = new StringBuilder();
            StringBuilder dirName = new StringBuilder();
            int startLast = 0;
            for (i = 0; i < name.length(); ++i) {
                if (!Character.isUpperCase(name.charAt(i))) continue;
                if (i > startLast) {
                    this.append(name, startLast, i, baseName, lowerBaseName, capBaseName, dirName);
                }
                startLast = i;
            }
            if (i > startLast) {
                this.append(name, startLast, i, baseName, lowerBaseName, capBaseName, dirName);
            }
            this.baseName = baseName.toString();
            this.lowerBaseName = lowerBaseName.toString();
            this.capitalizedBaseName = capBaseName.toString();
            this.dirName = dirName.toString();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        @Override
        public String getLowerBaseName() {
            return this.lowerBaseName;
        }

        @Override
        public String withPrefix(String prefix) {
            return prefix + this.capitalizedBaseName;
        }

        @Override
        public String withSuffix(String suffix) {
            return this.baseName + StringUtils.capitalize((String)suffix);
        }

        @Override
        public String getTaskName(String action) {
            return action + this.capitalizedBaseName;
        }

        @Override
        public String getCompileTaskName(String language) {
            return "compile" + this.capitalizedBaseName + StringUtils.capitalize((String)language);
        }

        @Override
        public String getDirName() {
            return this.dirName;
        }

        @Override
        public Names append(String suffix) {
            return Names.of(this.name + StringUtils.capitalize((String)suffix));
        }

        private void append(String name, int start, int end, StringBuilder baseName, StringBuilder lowerBaseName, StringBuilder capBaseName, StringBuilder dirName) {
            dirName.append(Character.toLowerCase(name.charAt(start)));
            dirName.append(name.substring(start + 1, end));
            dirName.append('/');
            if (start != 0 || end != 4 || !name.startsWith("main")) {
                if (baseName.length() == 0) {
                    baseName.append(Character.toLowerCase(name.charAt(start)));
                    baseName.append(name.substring(start + 1, end));
                } else {
                    baseName.append(name.substring(start, end));
                    lowerBaseName.append('-');
                }
                lowerBaseName.append(Character.toLowerCase(name.charAt(start)));
                lowerBaseName.append(name.substring(start + 1, end));
                capBaseName.append(Character.toUpperCase(name.charAt(start)));
                capBaseName.append(name.substring(start + 1, end));
            }
        }
    }

    private static class Main
    extends Names {
        private Main() {
        }

        @Override
        public String getName() {
            return "main";
        }

        @Override
        public String getBaseName() {
            return "main";
        }

        @Override
        public String getLowerBaseName() {
            return "main";
        }

        @Override
        public String getCompileTaskName(String language) {
            return "compile" + StringUtils.capitalize((String)language);
        }

        @Override
        public String getTaskName(String action) {
            return action;
        }

        @Override
        public String getDirName() {
            return "main/";
        }

        @Override
        public String withPrefix(String prefix) {
            return prefix;
        }

        @Override
        public String withSuffix(String suffix) {
            return suffix;
        }

        @Override
        public Names append(String suffix) {
            return Names.of("main" + StringUtils.capitalize((String)suffix));
        }
    }
}

