/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.util.function.Supplier;
import org.gradle.api.execution.internal.TaskInputsListener;
import org.gradle.api.execution.internal.TaskInputsListeners;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.logging.LogLevel;
import org.gradle.deployment.internal.Deployment;
import org.gradle.deployment.internal.DeploymentInternal;
import org.gradle.deployment.internal.DeploymentRegistryInternal;
import org.gradle.execution.CancellableOperationManager;
import org.gradle.execution.DefaultCancellableOperationManager;
import org.gradle.execution.PassThruCancellableOperationManager;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.ContinuousExecutionGate;
import org.gradle.initialization.DefaultContinuousExecutionGate;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.filewatch.DefaultFileWatcherEventListener;
import org.gradle.internal.filewatch.FileSystemChangeWaiter;
import org.gradle.internal.filewatch.FileSystemChangeWaiterFactory;
import org.gradle.internal.filewatch.PendingChangesListener;
import org.gradle.internal.filewatch.SingleFirePendingChangesListener;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.session.BuildSessionActionExecutor;
import org.gradle.internal.session.BuildSessionContext;
import org.gradle.internal.time.Clock;
import org.gradle.util.internal.DisconnectableInputStream;

public class ContinuousBuildActionExecutor
implements BuildSessionActionExecutor {
    private final BuildSessionActionExecutor delegate;
    private final TaskInputsListeners inputsListeners;
    private final BuildRequestMetaData requestMetaData;
    private final OperatingSystem operatingSystem;
    private final BuildCancellationToken cancellationToken;
    private final DeploymentRegistryInternal deploymentRegistry;
    private final ListenerManager listenerManager;
    private final BuildStartedTime buildStartedTime;
    private final Clock clock;
    private final FileSystemChangeWaiterFactory changeWaiterFactory;
    private final ExecutorFactory executorFactory;
    private final StyledTextOutput logger;

    public ContinuousBuildActionExecutor(FileSystemChangeWaiterFactory changeWaiterFactory, TaskInputsListeners inputsListeners, StyledTextOutputFactory styledTextOutputFactory, ExecutorFactory executorFactory, BuildRequestMetaData requestMetaData, BuildCancellationToken cancellationToken, DeploymentRegistryInternal deploymentRegistry, ListenerManager listenerManager, BuildStartedTime buildStartedTime, Clock clock, BuildSessionActionExecutor delegate) {
        this.inputsListeners = inputsListeners;
        this.requestMetaData = requestMetaData;
        this.cancellationToken = cancellationToken;
        this.deploymentRegistry = deploymentRegistry;
        this.listenerManager = listenerManager;
        this.buildStartedTime = buildStartedTime;
        this.clock = clock;
        this.operatingSystem = OperatingSystem.current();
        this.executorFactory = executorFactory;
        this.changeWaiterFactory = changeWaiterFactory;
        this.logger = styledTextOutputFactory.create(ContinuousBuildActionExecutor.class, LogLevel.QUIET);
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildActionRunner.Result execute(BuildAction action, BuildSessionContext buildSession) {
        if (action.getStartParameter().isContinuous()) {
            DefaultContinuousExecutionGate alwaysOpenExecutionGate = new DefaultContinuousExecutionGate();
            CancellableOperationManager cancellableOperationManager = this.createCancellableOperationManager(this.requestMetaData, this.cancellationToken);
            return this.executeMultipleBuilds(action, this.requestMetaData, buildSession, this.cancellationToken, cancellableOperationManager, alwaysOpenExecutionGate);
        }
        try {
            BuildActionRunner.Result result2 = this.delegate.execute(action, buildSession);
            return result2;
        }
        finally {
            CancellableOperationManager cancellableOperationManager = this.createCancellableOperationManager(this.requestMetaData, this.cancellationToken);
            this.waitForDeployments(action, this.requestMetaData, buildSession, this.cancellationToken, cancellableOperationManager);
        }
    }

    private CancellableOperationManager createCancellableOperationManager(BuildRequestMetaData requestContext, BuildCancellationToken cancellationToken) {
        CancellableOperationManager cancellableOperationManager;
        if (requestContext.isInteractive()) {
            if (!(System.in instanceof DisconnectableInputStream)) {
                System.setIn(new DisconnectableInputStream(System.in));
            }
            DisconnectableInputStream inputStream = (DisconnectableInputStream)System.in;
            cancellableOperationManager = new DefaultCancellableOperationManager(this.executorFactory.create("Cancel signal monitor"), inputStream, cancellationToken);
        } else {
            cancellableOperationManager = new PassThruCancellableOperationManager(cancellationToken);
        }
        return cancellableOperationManager;
    }

    private void waitForDeployments(BuildAction action, BuildRequestMetaData requestContext, BuildSessionContext buildSession, BuildCancellationToken cancellationToken, CancellableOperationManager cancellableOperationManager) {
        if (!this.deploymentRegistry.getRunningDeployments().isEmpty()) {
            for (Deployment deployment : this.deploymentRegistry.getRunningDeployments()) {
                ((DeploymentInternal)deployment).outOfDate();
            }
            this.logger.println().println("Reloadable deployment detected. Entering continuous build.");
            this.resetBuildStartedTime();
            ContinuousExecutionGate deploymentRequestExecutionGate = this.deploymentRegistry.getExecutionGate();
            this.executeMultipleBuilds(action, requestContext, buildSession, cancellationToken, cancellableOperationManager, deploymentRequestExecutionGate);
        }
        cancellableOperationManager.closeInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BuildActionRunner.Result executeMultipleBuilds(BuildAction action, BuildRequestMetaData requestContext, BuildSessionContext buildSession, BuildCancellationToken cancellationToken, CancellableOperationManager cancellableOperationManager, ContinuousExecutionGate continuousExecutionGate) {
        BuildActionRunner.Result lastResult;
        while (true) {
            PendingChangesListener pendingChangesListener = this.listenerManager.getBroadcaster(PendingChangesListener.class);
            FileSystemChangeWaiter waiter = this.changeWaiterFactory.createChangeWaiter(new SingleFirePendingChangesListener(pendingChangesListener), cancellationToken, continuousExecutionGate);
            try {
                lastResult = this.executeBuildAndAccumulateInputs(action, waiter, buildSession);
                if (!waiter.isWatching()) {
                    this.logger.println().withStyle(StyledTextOutput.Style.Failure).println("Exiting continuous build as no executed tasks declared file system inputs.");
                    BuildActionRunner.Result result2 = lastResult;
                    return result2;
                }
                cancellableOperationManager.monitorInput(operationToken -> {
                    DefaultFileWatcherEventListener reporter = new DefaultFileWatcherEventListener();
                    waiter.wait(() -> this.logger.println().println("Waiting for changes to input files of tasks..." + this.determineExitHint(requestContext)), reporter);
                    if (!operationToken.isCancellationRequested()) {
                        reporter.reportChanges(this.logger);
                    }
                });
            }
            finally {
                waiter.stop();
            }
            if (cancellationToken.isCancellationRequested()) break;
            this.logger.println("Change detected, executing build...").println();
            this.resetBuildStartedTime();
        }
        this.logger.println("Build cancelled.");
        return lastResult;
    }

    private void resetBuildStartedTime() {
        this.buildStartedTime.reset(this.clock.getCurrentTime());
    }

    private String determineExitHint(BuildRequestMetaData requestContext) {
        if (requestContext.isInteractive()) {
            if (this.operatingSystem.isWindows()) {
                return " (ctrl-d then enter to exit)";
            }
            return " (ctrl-d to exit)";
        }
        return "";
    }

    private BuildActionRunner.Result executeBuildAndAccumulateInputs(BuildAction action, FileSystemChangeWaiter waiter, BuildSessionContext buildSession) {
        return this.withTaskInputsListener((task, fileSystemInputs) -> waiter.watch(FileSystemSubset.of(fileSystemInputs)), () -> this.delegate.execute(action, buildSession));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withTaskInputsListener(TaskInputsListener listener2, Supplier<T> supplier) {
        try {
            this.inputsListeners.addListener(listener2);
            T t = supplier.get();
            return t;
        }
        finally {
            this.inputsListeners.removeListener(listener2);
        }
    }
}

