/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.tracing;

import com.intellij.diagnostic.tracing.MethodTracerData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodTracer {
    @NotNull
    private final TracerId myId;
    private final String myClassName;
    private final String myMethodName;
    private final AtomicLong myInvocationCount;
    private final AtomicLong myNonRecursiveCount;
    private final AtomicLong myTotalTime;
    private final AtomicLong myMaxTime;
    private final AtomicLong myTimeOnEdt;
    private final AtomicLong myCountOnEdt;
    private final AtomicLong myMaxTimeOnEdt;
    private final AtomicInteger myMaxRecursionDepth;
    private final ThreadLocal<Long> currentCalculationStart;
    private final ThreadLocal<Integer> currentRecursionDepth;
    private static final MyConcurrentMap<TracerId, MethodTracer> tracersMap = new MyConcurrentMap();
    private static boolean enabled = true;
    private static final MethodTracer empty = new MethodTracer(TracerId.EMPTY, "", ""){

        @Override
        public void onMethodEnter() {
        }

        @Override
        public void onMethodExit() {
        }

        @Override
        public MethodTracerData getCurrentData() {
            throw new UnsupportedOperationException();
        }
    };
    private static final ThreadLocal<Boolean> isDispatchThread = ThreadLocal.withInitial(() -> SwingUtilities.isEventDispatchThread());

    private MethodTracer(@NotNull TracerId id, @NonNls String className, @NonNls String methodName) {
        if (id == null) {
            MethodTracer.$$$reportNull$$$0(0);
        }
        this.myInvocationCount = new AtomicLong(0L);
        this.myNonRecursiveCount = new AtomicLong(0L);
        this.myTotalTime = new AtomicLong(0L);
        this.myMaxTime = new AtomicLong(0L);
        this.myTimeOnEdt = new AtomicLong(0L);
        this.myCountOnEdt = new AtomicLong(0L);
        this.myMaxTimeOnEdt = new AtomicLong(0L);
        this.myMaxRecursionDepth = new AtomicInteger(0);
        this.currentCalculationStart = ThreadLocal.withInitial(() -> null);
        this.currentRecursionDepth = ThreadLocal.withInitial(() -> 0);
        this.myId = id;
        this.myClassName = className;
        this.myMethodName = methodName;
    }

    public void onMethodEnter() {
        this.myInvocationCount.incrementAndGet();
        Integer recursionOnStart = this.currentRecursionDepth.get();
        this.myMaxRecursionDepth.updateAndGet(old -> Math.max(old, recursionOnStart));
        if (recursionOnStart == 0) {
            this.currentCalculationStart.set(System.nanoTime());
            this.myNonRecursiveCount.incrementAndGet();
        }
        this.currentRecursionDepth.set(recursionOnStart + 1);
    }

    public void onMethodExit() {
        this.currentRecursionDepth.set(this.currentRecursionDepth.get() - 1);
        if (this.currentRecursionDepth.get() == 0) {
            long duration = System.nanoTime() - this.currentCalculationStart.get();
            this.currentCalculationStart.set(null);
            this.myTotalTime.addAndGet(duration);
            this.myMaxTime.updateAndGet(old -> Math.max(old, duration));
            if (isDispatchThread.get().booleanValue()) {
                this.myCountOnEdt.incrementAndGet();
                this.myTimeOnEdt.addAndGet(duration);
                this.myMaxTimeOnEdt.updateAndGet(old -> Math.max(old, duration));
            }
        }
    }

    public MethodTracerData getCurrentData() {
        return new MethodTracerData(this.myId, this.myClassName, this.myMethodName, this.myInvocationCount.get(), this.myNonRecursiveCount.get(), MethodTracer.toMillis(this.myTotalTime.get()), MethodTracer.toMillis(this.myMaxTime.get()), this.myCountOnEdt.get(), MethodTracer.toMillis(this.myTimeOnEdt.get()), MethodTracer.toMillis(this.myMaxTimeOnEdt.get()), this.myMaxRecursionDepth.get());
    }

    private static long toMillis(long time) {
        return TimeUnit.NANOSECONDS.toMillis(time);
    }

    public static MethodTracer getInstance(@NotNull String className, @NotNull String simpleClassName, @NotNull String methodName, @Nullable String methodNameSuffix, @NotNull String desc) {
        if (className == null) {
            MethodTracer.$$$reportNull$$$0(1);
        }
        if (simpleClassName == null) {
            MethodTracer.$$$reportNull$$$0(2);
        }
        if (methodName == null) {
            MethodTracer.$$$reportNull$$$0(3);
        }
        if (desc == null) {
            MethodTracer.$$$reportNull$$$0(4);
        }
        TracerId id = new TracerId(className, methodName, methodNameSuffix, desc);
        String presentableMethodName = methodName;
        if (methodNameSuffix != null) {
            presentableMethodName = methodName + "-" + methodNameSuffix;
        }
        return MethodTracer.isEnabled() ? tracersMap.putIfAbsent(id, new MethodTracer(id, simpleClassName, presentableMethodName)) : empty;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        MethodTracer.enabled = enabled;
    }

    public static void clearAll() {
        tracersMap.clear();
    }

    public static List<MethodTracerData> getAllData() {
        return tracersMap.map((k, v) -> v.getCurrentData());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleClassName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/tracing/MethodTracer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class TracerId {
        public static final TracerId EMPTY = new TracerId("", "", "", "");
        private final String myClassName;
        private final String myMethodName;
        private final String mySuffix;
        private final String myDescription;

        public TracerId(@NotNull @NonNls String className, @NotNull @NonNls String methodName, @Nullable @NonNls String suffix, @NotNull @NonNls String description) {
            if (className == null) {
                TracerId.$$$reportNull$$$0(0);
            }
            if (methodName == null) {
                TracerId.$$$reportNull$$$0(1);
            }
            if (description == null) {
                TracerId.$$$reportNull$$$0(2);
            }
            this.myClassName = className;
            this.myMethodName = methodName;
            this.mySuffix = suffix;
            this.myDescription = description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TracerId id = (TracerId)o;
            return this.myClassName.equals(id.myClassName) && this.myMethodName.equals(id.myMethodName) && Objects.equals(this.mySuffix, id.mySuffix) && this.myDescription.equals(id.myDescription);
        }

        public int hashCode() {
            return Objects.hash(this.myClassName, this.myMethodName, this.mySuffix, this.myDescription);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "className";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "methodName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "description";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diagnostic/tracing/MethodTracer$TracerId";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyConcurrentMap<K, V> {
        private final AtomicReference<Map<K, V>> myReference = new AtomicReference(Collections.emptyMap());

        private MyConcurrentMap() {
        }

        public V putIfAbsent(K key, V value) {
            HashMap<K, V> newMap;
            Map<K, V> prevMap;
            do {
                V existingValue;
                if ((existingValue = (prevMap = this.myReference.get()).get(key)) != null) {
                    return existingValue;
                }
                newMap = new HashMap<K, V>(prevMap);
                newMap.put(key, value);
            } while (!this.myReference.compareAndSet(prevMap, Collections.unmodifiableMap(newMap)));
            return value;
        }

        public void clear() {
            this.myReference.set(Collections.emptyMap());
        }

        public Collection<V> values() {
            return this.myReference.get().values();
        }

        public <T> List<T> map(BiFunction<? super K, ? super V, ? extends T> function) {
            Map<Object, Object> map = this.myReference.get();
            ArrayList result = new ArrayList(map.size());
            map.forEach((k, v) -> result.add(function.apply((Object)k, (Object)v)));
            return result;
        }
    }
}

