/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.TaskExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessWaitFor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseProcessHandler<T extends Process>
extends ProcessHandler
implements TaskExecutor {
    private static final Logger LOG = Logger.getInstance(BaseProcessHandler.class);
    protected final T myProcess;
    protected final String myCommandLine;
    protected final Charset myCharset;
    @NonNls
    protected final String myPresentableName;
    protected final ProcessWaitFor myWaitFor;

    public BaseProcessHandler(@NotNull T process, String commandLine, @Nullable Charset charset) {
        if (process == null) {
            BaseProcessHandler.$$$reportNull$$$0(0);
        }
        this.myProcess = process;
        this.myCommandLine = commandLine;
        this.myCharset = charset;
        if (StringUtil.isEmpty(commandLine)) {
            LOG.warn(new IllegalArgumentException("Must specify non-empty 'commandLine' parameter"));
        }
        this.myPresentableName = CommandLineUtil.extractPresentableName(StringUtil.notNullize(commandLine));
        this.myWaitFor = new ProcessWaitFor((Process)process, this, this.myPresentableName);
    }

    @NotNull
    public final T getProcess() {
        T t = this.myProcess;
        if (t == null) {
            BaseProcessHandler.$$$reportNull$$$0(1);
        }
        return t;
    }

    @NlsSafe
    public String getCommandLine() {
        return this.myCommandLine;
    }

    @Nullable
    public Charset getCharset() {
        return this.myCharset;
    }

    @Override
    @NotNull
    public OutputStream getProcessInput() {
        OutputStream outputStream = ((Process)this.myProcess).getOutputStream();
        if (outputStream == null) {
            BaseProcessHandler.$$$reportNull$$$0(2);
        }
        return outputStream;
    }

    protected void onOSProcessTerminated(int exitCode) {
        this.notifyProcessTerminated(exitCode);
    }

    protected void doDestroyProcess() {
        ((Process)this.getProcess()).destroy();
    }

    @Override
    protected void destroyProcessImpl() {
        try {
            this.closeStreams();
        }
        finally {
            this.doDestroyProcess();
        }
    }

    @Override
    protected void detachProcessImpl() {
        Runnable runnable = () -> {
            this.closeStreams();
            this.myWaitFor.detach();
            this.notifyProcessDetached();
        };
        this.executeTask(runnable);
    }

    @Override
    public boolean detachIsDefault() {
        return false;
    }

    protected void closeStreams() {
        try {
            ((Process)this.myProcess).getOutputStream().close();
        }
        catch (IOException e) {
            LOG.warn(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/BaseProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/BaseProcessHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcess";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessInput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

