/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ObjectTree;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class ObjectNode {
    private final Disposable myObject;
    @NotNull
    private List<ObjectNode> myChildren;
    private Throwable myTrace;
    private static final Disposable ROOT_DISPOSABLE = Disposer.newDisposable("ROOT_DISPOSABLE");

    private ObjectNode(@NotNull Disposable object, boolean parentIsRoot) {
        if (object == null) {
            ObjectNode.$$$reportNull$$$0(0);
        }
        this.myChildren = Collections.emptyList();
        this.myObject = object;
        this.myTrace = parentIsRoot && Disposer.isDebugMode() ? ThrowableInterner.intern(new Throwable()) : null;
    }

    private ObjectNode() {
        this.myChildren = Collections.emptyList();
        this.myObject = ROOT_DISPOSABLE;
    }

    void assertNoChildren(boolean throwError) {
        for (ObjectNode childNode : this.myChildren) {
            Disposable object = childNode.getObject();
            Throwable trace = childNode.getTrace();
            String message = "Memory leak detected: '" + object + "' of " + object.getClass() + " is registered in Disposer but wasn't disposed.\nRegister it with a proper parentDisposable or ensure that it's always disposed by direct Disposer.dispose call.\nSee https://jetbrains.org/intellij/sdk/docs/basics/disposers.html for more details.\nThe corresponding Disposer.register() stacktrace is shown as the cause:\n";
            RuntimeException exception = new RuntimeException(message, trace);
            if (throwError) {
                throw exception;
            }
            ObjectTree.getLogger().error(exception);
        }
    }

    private boolean isRootNode() {
        return this.myObject == ROOT_DISPOSABLE;
    }

    @NotNull
    static ObjectNode createRootNode() {
        return new ObjectNode();
    }

    private void addChildNode(@NotNull ObjectNode childNode) {
        List<ObjectNode> children2;
        if (childNode == null) {
            ObjectNode.$$$reportNull$$$0(1);
        }
        if ((children2 = this.myChildren) == Collections.emptyList()) {
            this.myChildren = new SmartList<ObjectNode>(childNode);
        } else {
            children2.add(childNode);
        }
    }

    void removeChildNode(@NotNull ObjectNode childNode) {
        if (childNode == null) {
            ObjectNode.$$$reportNull$$$0(2);
        }
        List<ObjectNode> children2 = this.myChildren;
        for (int i = children2.size() - 1; i >= 0; --i) {
            ObjectNode node = children2.get(i);
            if (!node.equals(childNode)) continue;
            children2.remove(i);
            break;
        }
    }

    @NotNull
    ObjectNode moveChildNodeToOtherParent(@NotNull Disposable child, @NotNull ObjectNode otherParentNode) {
        if (child == null) {
            ObjectNode.$$$reportNull$$$0(3);
        }
        if (otherParentNode == null) {
            ObjectNode.$$$reportNull$$$0(4);
        }
        List<ObjectNode> children2 = this.myChildren;
        ObjectNode childNode = null;
        for (int i = children2.size() - 1; i >= 0; --i) {
            ObjectNode node = children2.get(i);
            if (node.getObject() != child) continue;
            childNode = children2.remove(i);
            break;
        }
        if (childNode == null) {
            childNode = new ObjectNode(child, this.isRootNode());
        }
        otherParentNode.addChildNode(childNode);
        ObjectNode objectNode = childNode;
        if (objectNode == null) {
            ObjectNode.$$$reportNull$$$0(5);
        }
        return objectNode;
    }

    void removeChildNodesRecursively(@NotNull List<? super Disposable> disposables, @NotNull ObjectTree tree, @Nullable Throwable trace, @Nullable Predicate<? super Disposable> predicate) {
        if (disposables == null) {
            ObjectNode.$$$reportNull$$$0(6);
        }
        if (tree == null) {
            ObjectNode.$$$reportNull$$$0(7);
        }
        for (int i = this.myChildren.size() - 1; i >= 0; --i) {
            boolean alreadyDisposed;
            ObjectNode childNode = this.myChildren.get(i);
            Disposable object = childNode.getObject();
            if (predicate != null && !predicate.test(object)) continue;
            this.myChildren.remove(i);
            childNode.removeChildNodesRecursively(disposables, tree, trace, null);
            boolean bl = alreadyDisposed = tree.rememberDisposedTrace(object, trace) != null;
            if (alreadyDisposed) continue;
            disposables.add(object);
        }
    }

    @NotNull
    Disposable getObject() {
        Disposable disposable = this.myObject;
        if (disposable == null) {
            ObjectNode.$$$reportNull$$$0(8);
        }
        return disposable;
    }

    @NonNls
    public String toString() {
        return this.isRootNode() ? "ROOT" : "Node: " + this.myObject;
    }

    Throwable getTrace() {
        return this.myTrace;
    }

    void clearTrace() {
        this.myTrace = null;
    }

    @TestOnly
    void assertNoReferencesKept(@NotNull Disposable aDisposable) {
        if (aDisposable == null) {
            ObjectNode.$$$reportNull$$$0(9);
        }
        assert (this.getObject() != aDisposable);
        for (ObjectNode node : this.myChildren) {
            node.assertNoReferencesKept(aDisposable);
        }
    }

    ObjectNode findChildNode(@NotNull Disposable object) {
        if (object == null) {
            ObjectNode.$$$reportNull$$$0(10);
        }
        List<ObjectNode> children2 = this.myChildren;
        for (ObjectNode node : children2) {
            if (node.getObject() != object) continue;
            return node;
        }
        return null;
    }

    @NotNull
    ObjectNode findOrCreateChildNode(@NotNull Disposable object) {
        ObjectNode existing;
        if (object == null) {
            ObjectNode.$$$reportNull$$$0(11);
        }
        if ((existing = this.findChildNode(object)) != null) {
            ObjectNode objectNode = existing;
            if (objectNode == null) {
                ObjectNode.$$$reportNull$$$0(12);
            }
            return objectNode;
        }
        ObjectNode childNode = new ObjectNode(object, this.isRootNode());
        this.addChildNode(childNode);
        ObjectNode objectNode = childNode;
        if (objectNode == null) {
            ObjectNode.$$$reportNull$$$0(13);
        }
        return objectNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherParentNode";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/ObjectNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposables";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/ObjectNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "moveChildNodeToOtherParent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateChildNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addChildNode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeChildNode";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "moveChildNodeToOtherParent";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeChildNodesRecursively";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "assertNoReferencesKept";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findChildNode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateChildNode";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

