/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.CompositeMessageBus;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageQueue;
import com.intellij.util.messages.impl.RootBus;
import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u00122\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0012R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/util/messages/impl/RootBus;", "Lcom/intellij/util/messages/impl/CompositeMessageBus;", "owner", "Lcom/intellij/util/messages/MessageBusOwner;", "(Lcom/intellij/util/messages/MessageBusOwner;)V", "compactionFutureRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/CompletableFuture;", "compactionRequest", "Ljava/util/concurrent/atomic/AtomicInteger;", "emptyConnectionCounter", "queue", "Lcom/intellij/util/messages/impl/MessageQueue;", "getQueue$intellij_platform_core", "()Lcom/intellij/util/messages/impl/MessageQueue;", "queueThreadLocal", "Ljava/lang/ThreadLocal;", "dispose", "", "removeDisposedHandlers", "topic", "Lcom/intellij/util/messages/Topic;", "handler", "", "scheduleEmptyConnectionRemoving", "intellij.platform.core"})
@ApiStatus.Internal
@VisibleForTesting
public final class RootBus
extends CompositeMessageBus {
    private final AtomicReference<CompletableFuture<?>> compactionFutureRef;
    private final AtomicInteger compactionRequest;
    private final AtomicInteger emptyConnectionCounter;
    private final ThreadLocal<MessageQueue> queueThreadLocal;

    @NotNull
    public final MessageQueue getQueue$intellij_platform_core() {
        MessageQueue messageQueue = this.queueThreadLocal.get();
        Intrinsics.checkNotNullExpressionValue((Object)messageQueue, (String)"queueThreadLocal.get()");
        return messageQueue;
    }

    public final void scheduleEmptyConnectionRemoving() {
        int counter = this.emptyConnectionCounter.incrementAndGet();
        if (counter < 128 || !this.emptyConnectionCounter.compareAndSet(counter, 0)) {
            return;
        }
        if (this.compactionRequest.incrementAndGet() == 1) {
            this.compactionFutureRef.set(CompletableFuture.runAsync(new Runnable(this){
                final /* synthetic */ RootBus this$0;

                public final void run() {
                    int request = 0;
                    do {
                        request = RootBus.access$getCompactionRequest$p(this.this$0).get();
                        this.this$0.removeEmptyConnectionsRecursively();
                    } while (!RootBus.access$getCompactionRequest$p(this.this$0).compareAndSet(request, 0));
                }
                {
                    this.this$0 = rootBus;
                }
            }, AppExecutorUtil.getAppExecutorService()));
        }
    }

    @Override
    public void dispose() {
        CompletableFuture compactionFuture;
        CompletableFuture completableFuture = compactionFuture = (CompletableFuture)this.compactionFutureRef.getAndSet(null);
        if (completableFuture != null) {
            completableFuture.cancel(false);
        }
        this.compactionRequest.set(0);
        super.dispose();
    }

    public final void removeDisposedHandlers(@NotNull Topic<?> topic, @NotNull Object handler) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        ArrayDeque<Message> queue = this.getQueue$intellij_platform_core().queue;
        if (queue.isEmpty()) {
            return;
        }
        queue.removeIf(new Predicate(topic, handler){
            final /* synthetic */ Topic $topic;
            final /* synthetic */ Object $handler;

            /*
             * WARNING - void declaration
             */
            public final boolean test(Message message) {
                int n = 0;
                int n2 = message.handlers.length;
                while (n < n2) {
                    Object messageHandler;
                    void messageIndex;
                    if (message.handlers[messageIndex] == null) {
                        return false;
                    }
                    if (message.topic == this.$topic && messageHandler == this.$handler) {
                        message.handlers[messageIndex] = null;
                        return message.handlers.length == 1;
                    }
                    ++messageIndex;
                }
                return false;
            }
            {
                this.$topic = topic;
                this.$handler = object;
            }
        });
    }

    public RootBus(@NotNull MessageBusOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(owner);
        this.compactionFutureRef = new AtomicReference();
        this.compactionRequest = new AtomicInteger();
        this.emptyConnectionCounter = new AtomicInteger();
        ThreadLocal threadLocal = ThreadLocal.withInitial(queueThreadLocal.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"ThreadLocal.withInitial { MessageQueue() }");
        this.queueThreadLocal = threadLocal;
    }

    public static final /* synthetic */ AtomicInteger access$getCompactionRequest$p(RootBus $this) {
        return $this.compactionRequest;
    }
}

