/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.generator;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSObject;
import org.jetbrains.idea.devkit.dom.generator.FieldDesc;
import org.jetbrains.idea.devkit.dom.generator.NamespaceDesc;
import org.jetbrains.idea.devkit.dom.generator.TypeDesc;
import org.jetbrains.idea.devkit.dom.generator.Util;

public class ModelDesc {
    final Map<String, String> name2replaceMap = new HashMap<String, String>();
    final Map<QName, String> qname2FileMap = new HashMap<QName, String>();
    final Map<String, NamespaceDesc> nsdMap = new HashMap<String, NamespaceDesc>();
    final Map<String, TypeDesc> jtMap = new TreeMap<String, TypeDesc>();

    public String getNSDPrefix(TypeDesc td) {
        return this.getNSDPrefix(td.xsNamespace, td.name, td.type == TypeDesc.TypeEnum.ENUM);
    }

    public String getNSDPrefix(String namespace, String name, boolean isEnum) {
        QName qname;
        String files;
        int lastIdx = name.lastIndexOf(".");
        if (lastIdx > -1) {
            return name.substring(0, lastIdx + 1);
        }
        NamespaceDesc nsd = this.getNSD(namespace);
        if (isEnum && nsd.enumPkg != null) {
            return nsd.enumPkg + ".";
        }
        if (nsd.pkgNames != null && (files = this.qname2FileMap.get(qname = new QName(namespace, name))) != null) {
            for (int i = 0; i < nsd.pkgNames.length; i += 2) {
                String file = nsd.pkgNames[i];
                String pkg = nsd.pkgNames[i + 1];
                if (!files.contains(":" + file + ":")) continue;
                return pkg + ".";
            }
        }
        return nsd.pkgName != null && nsd.pkgName.length() > 0 ? nsd.pkgName + "." : "";
    }

    public NamespaceDesc getNSD(String namespace) {
        NamespaceDesc nsd = this.nsdMap.get(namespace);
        if (nsd == null) {
            nsd = this.nsdMap.get("");
        }
        return nsd;
    }

    public String toJavaTypeName(String tname, String ns) {
        int lastIndex = tname.lastIndexOf(46);
        String xmlName = lastIndex > -1 ? tname.substring(lastIndex + 1) : tname;
        NamespaceDesc nsd = this.getNSD(ns);
        if (ns == null || !ns.endsWith(".dtd")) {
            if (xmlName.endsWith("ElemType")) {
                xmlName = xmlName.substring(0, xmlName.length() - "ElemType".length());
            } else if (xmlName.endsWith("AttrType")) {
                xmlName = xmlName.substring(0, xmlName.length() - "AttrType".length());
            } else if (xmlName.endsWith("Type")) {
                xmlName = xmlName.substring(0, xmlName.length() - "Type".length());
            }
        }
        Object rc = Util.capitalize(Util.toJavaName(xmlName));
        if (nsd.prefix != null && nsd.prefix.length() > 0 && !((String)rc).startsWith(nsd.prefix)) {
            rc = nsd.prefix + (String)rc;
        }
        if (Util.RESERVED_NAMES_MAP.containsKey(rc)) {
            rc = Util.RESERVED_NAMES_MAP.get(rc);
        }
        if (this.name2replaceMap.containsKey(rc)) {
            rc = Util.expandProperties(this.name2replaceMap.get(rc), nsd.props);
        }
        return rc;
    }

    public String toJavaQualifiedTypeName(XSObject xs, Map<String, NamespaceDesc> nsdMap, boolean isEnum) {
        String typeName = this.toJavaTypeName(xs.getName(), xs.getNamespace());
        return this.getNSDPrefix(xs.getNamespace(), xs.getName(), isEnum) + typeName;
    }

    public String toJavaQualifiedTypeName(String namespace, String xmlname, boolean isEnum) {
        return this.getNSDPrefix(namespace, xmlname, isEnum) + this.toJavaTypeName(xmlname, namespace);
    }

    void dump(PrintWriter out) {
        out.println("-- nsdMap ---");
        for (Map.Entry<String, NamespaceDesc> entry : this.nsdMap.entrySet()) {
            out.println("namespace key: " + entry.getKey());
            this.dumpNamespace(entry.getValue(), out);
        }
        out.println("-- jtMap ---");
        for (Map.Entry<String, Object> entry : this.jtMap.entrySet()) {
            out.println("type key: " + entry.getKey());
            this.dumpTypeDesc((TypeDesc)entry.getValue(), out);
        }
    }

    private void dumpTypeDesc(TypeDesc td, PrintWriter out) {
        ArrayList<CallSite> superList;
        if (td.supers != null) {
            superList = new ArrayList<CallSite>();
            for (TypeDesc aSuper : td.supers) {
                superList.add((CallSite)((Object)(this.getNSDPrefix(aSuper) + aSuper.name)));
            }
        } else {
            superList = null;
        }
        out.println("  name      " + td.name);
        out.println("  type      " + td.type);
        out.println("  xsName    " + td.xsName);
        out.println("  xsNS      " + td.xsNamespace);
        out.println("  dups      " + td.duplicates);
        out.println("  supers    " + (Serializable)(superList != null ? superList : "null"));
        out.println("  doc       " + (Serializable)(td.documentation != null ? Integer.valueOf(td.documentation.length()) : "null"));
        for (Map.Entry entry : td.fdMap.entrySet()) {
            out.println("  field key: " + (String)entry.getKey());
            this.dumpFieldDesc(td, (FieldDesc)entry.getValue(), out);
        }
    }

    private void dumpFieldDesc(TypeDesc td, FieldDesc fd, PrintWriter out) {
        out.println("    name      " + fd.name);
        if (td.type == TypeDesc.TypeEnum.ENUM) {
            return;
        }
        out.println("    clType    " + fd.clType);
        out.println("    required  " + fd.required);
        out.println("    index     " + fd.idx + "/" + fd.realIndex);
        out.println("    choiceOpt " + fd.choiceOpt);
        out.println("    choice    " + (Serializable)(fd.choice != null ? Integer.valueOf(fd.choice.length) : "null"));
        out.println("    content   " + fd.contentQualifiedName);
        out.println("    dupIdx    " + fd.duplicateIndex);
        out.println("    elName    " + fd.elementName);
        out.println("    elType    " + fd.elementType);
        out.println("    def       " + fd.def);
        out.println("    doc       " + (Serializable)(fd.documentation != null ? Integer.valueOf(fd.documentation.length()) : "null"));
    }

    private void dumpNamespace(NamespaceDesc value, PrintWriter out) {
        if (value.skip) {
            return;
        }
        out.println("  name     " + value.name);
        out.println("  prefix   " + value.prefix);
        out.println("  pkgName  " + value.pkgName);
        out.println("  pkgNames " + (value.pkgNames != null ? Arrays.asList(value.pkgNames) : "null"));
        out.println("  enumPkg  " + value.enumPkg);
        out.println("  super    " + value.superClass);
    }
}

