/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.run.JUnitDevKitPatcher;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class DevKitApplicationPatcher
extends RunConfigurationExtension {
    public <T extends RunConfigurationBase<?>> void updateJavaParameters(@NotNull T configuration, @NotNull JavaParameters javaParameters, RunnerSettings runnerSettings) {
        if (configuration == null) {
            DevKitApplicationPatcher.$$$reportNull$$$0(0);
        }
        if (javaParameters == null) {
            DevKitApplicationPatcher.$$$reportNull$$$0(1);
        }
        ParametersList vmParametersList = javaParameters.getVMParametersList();
        Project project = configuration.getProject();
        if (PsiUtil.isIdeaProject(project) && !vmParametersList.getList().contains("--add-modules") && "com.intellij.idea.Main".equals(((ApplicationConfiguration)configuration).getMainClassName())) {
            String qualifiedName;
            Module module = ((JavaRunConfigurationModule)((ApplicationConfiguration)configuration).getConfigurationModule()).getModule();
            Sdk jdk = JavaParameters.getJdkToRunModule((Module)module, (boolean)true);
            if (jdk == null) {
                return;
            }
            if (!vmParametersList.hasProperty("java.system.class.loader") && JUnitDevKitPatcher.loaderValid(project, module, qualifiedName = "com.intellij.util.lang.PathClassLoader")) {
                vmParametersList.addProperty("java.system.class.loader", qualifiedName);
            }
            if (!vmParametersList.getList().contains("--add-opens")) {
                JUnitDevKitPatcher.appendAddOpensWhenNeeded(jdk, vmParametersList);
            }
        }
    }

    public boolean isApplicableFor(@NotNull RunConfigurationBase<?> configuration) {
        if (configuration == null) {
            DevKitApplicationPatcher.$$$reportNull$$$0(2);
        }
        return configuration instanceof ApplicationConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParameters";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/run/DevKitApplicationPatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateJavaParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

