/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.patterns.compiler.PatternCompilerFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dgm.DGMMemberContributor;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ClassUtil;
import org.jetbrains.plugins.groovy.lang.resolve.CategoryMemberContributorKt;
import org.jetbrains.plugins.groovy.lang.resolve.noncode.MixinMemberContributor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MultiProcessor;

public abstract class NonCodeMembersContributor {
    public static final ExtensionPointName<NonCodeMembersContributor> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.membersContributor");
    private static volatile Cache cache;

    public void processDynamicElements(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (qualifierType == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(1);
        }
        if (place == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(2);
        }
        if (state == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(3);
        }
        throw new RuntimeException("One of two 'processDynamicElements()' methods must be implemented");
    }

    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (qualifierType == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(5);
        }
        if (place == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(6);
        }
        if (state == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(7);
        }
        this.processDynamicElements(qualifierType, processor, place, state);
    }

    protected boolean unwrapMultiprocessor() {
        return true;
    }

    @Nullable
    protected String getParentClassName() {
        return null;
    }

    @NotNull
    protected Collection<String> getClassNames() {
        String className = this.getParentClassName();
        List<Object> list = className == null ? Collections.emptyList() : Collections.singletonList(className);
        if (list == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static void dropCache() {
        cache = null;
        PatternCompilerFactory.getFactory().dropCache();
    }

    private static void ensureInit() {
        if (cache != null) {
            return;
        }
        ArrayList<NonCodeMembersContributor> allTypeContributors = new ArrayList<NonCodeMembersContributor>();
        MultiMap contributorMap = new MultiMap();
        for (NonCodeMembersContributor contributor : (NonCodeMembersContributor[])EP_NAME.getExtensions()) {
            Collection<String> fqns = contributor.getClassNames();
            if (fqns.isEmpty()) {
                allTypeContributors.add(contributor);
                continue;
            }
            for (String fqn : fqns) {
                contributorMap.putValue((Object)fqn, (Object)contributor);
            }
        }
        cache = new Cache((MultiMap<String, NonCodeMembersContributor>)contributorMap, allTypeContributors.toArray(new NonCodeMembersContributor[0]));
    }

    @NotNull
    private static Iterable<NonCodeMembersContributor> getApplicableContributors(@Nullable PsiClass clazz) {
        ArrayList<NonCodeMembersContributor> result2 = new ArrayList<NonCodeMembersContributor>();
        if (clazz != null) {
            for (String superClassName : ClassUtil.getSuperClassesWithCache(clazz).keySet()) {
                result2.addAll(NonCodeMembersContributor.cache.classSpecifiedContributors.get((Object)superClassName));
            }
        }
        ContainerUtil.addAll(result2, (Object[])NonCodeMembersContributor.cache.allTypeContributors);
        ArrayList<NonCodeMembersContributor> arrayList = result2;
        if (arrayList == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static boolean runContributors(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (qualifierType == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(11);
        }
        if (place == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(12);
        }
        if (state == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(13);
        }
        NonCodeMembersContributor.ensureInit();
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)qualifierType);
        Iterable<? extends PsiScopeProcessor> unwrappedOriginals = MultiProcessor.allProcessors(processor);
        for (PsiScopeProcessor psiScopeProcessor : unwrappedOriginals) {
            if (!MixinMemberContributor.processClassMixins(qualifierType, psiScopeProcessor, place, state)) {
                return false;
            }
            if (!CategoryMemberContributorKt.processCategoriesInScope(qualifierType, psiScopeProcessor, place, state)) {
                return false;
            }
            if (DGMMemberContributor.processDgmMethods(qualifierType, psiScopeProcessor, place, state)) continue;
            return false;
        }
        List<MyDelegatingScopeProcessor> wrapped = Collections.singletonList(new MyDelegatingScopeProcessor(processor));
        List<MyDelegatingScopeProcessor> list = ContainerUtil.map(MultiProcessor.allProcessors(processor), MyDelegatingScopeProcessor::new);
        Iterable<NonCodeMembersContributor> contributors = NonCodeMembersContributor.getApplicableContributors(aClass);
        for (NonCodeMembersContributor contributor : contributors) {
            ProgressManager.checkCanceled();
            processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.CHANGE_LEVEL, null);
            List<MyDelegatingScopeProcessor> delegates = contributor.unwrapMultiprocessor() ? list : wrapped;
            for (MyDelegatingScopeProcessor delegatingProcessor : delegates) {
                ProgressManager.checkCanceled();
                contributor.processDynamicElements(qualifierType, aClass, delegatingProcessor, place, state);
                if (delegatingProcessor.wantMore) continue;
                return false;
            }
        }
        return true;
    }

    static {
        EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<NonCodeMembersContributor>(){

            public void extensionAdded(@NotNull NonCodeMembersContributor extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                NonCodeMembersContributor.dropCache();
            }

            public void extensionRemoved(@NotNull NonCodeMembersContributor extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                NonCodeMembersContributor.dropCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 1: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableContributors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processDynamicElements";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runContributors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Cache {
        public final MultiMap<String, NonCodeMembersContributor> classSpecifiedContributors;
        public final NonCodeMembersContributor[] allTypeContributors;

        private Cache(MultiMap<String, NonCodeMembersContributor> classSpecifiedContributors, NonCodeMembersContributor[] allTypeContributors) {
            this.classSpecifiedContributors = classSpecifiedContributors;
            this.allTypeContributors = allTypeContributors;
        }
    }

    private static class MyDelegatingScopeProcessor
    extends DelegatingScopeProcessor
    implements MultiProcessor {
        public boolean wantMore = true;

        MyDelegatingScopeProcessor(PsiScopeProcessor delegate) {
            super(delegate);
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                MyDelegatingScopeProcessor.$$$reportNull$$$0(0);
            }
            if (state == null) {
                MyDelegatingScopeProcessor.$$$reportNull$$$0(1);
            }
            if (!this.wantMore) {
                return false;
            }
            this.wantMore = super.execute(element, state);
            return this.wantMore;
        }

        @Override
        @NotNull
        public Iterable<? extends PsiScopeProcessor> getProcessors() {
            Iterable<? extends PsiScopeProcessor> iterable = MultiProcessor.allProcessors(this.getDelegate());
            if (iterable == null) {
                MyDelegatingScopeProcessor.$$$reportNull$$$0(2);
            }
            return iterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor$MyDelegatingScopeProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor$MyDelegatingScopeProcessor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcessors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

