/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleExtensionProperty;
import org.jetbrains.plugins.gradle.service.resolve.GradleExtensionType;
import org.jetbrains.plugins.gradle.service.resolve.GradleExtensionsContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectAwareType;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleProjectExtensionContributor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor;", "()V", "getParentClassName", "", "processDynamicElements", "", "qualifierType", "Lcom/intellij/psi/PsiType;", "aClass", "Lcom/intellij/psi/PsiClass;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "place", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "shouldAddConfiguration", "", "extension", "Lorg/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtension;", "context", "intellij.gradle.java"})
public final class GradleProjectExtensionContributor
extends NonCodeMembersContributor {
    @NotNull
    protected String getParentClassName() {
        return "org.gradle.api.Project";
    }

    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        Collection extensions;
        Collection collection;
        PsiFile containingFile;
        Intrinsics.checkNotNullParameter((Object)qualifierType, (String)"qualifierType");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(qualifierType instanceof GradleProjectAwareType)) {
            return;
        }
        boolean processMethods = ResolveUtilKt.shouldProcessMethods((PsiScopeProcessor)processor);
        boolean processProperties = ResolveUtilKt.shouldProcessProperties((PsiScopeProcessor)processor);
        if (!processMethods && !processProperties) {
            return;
        }
        PsiFile psiFile = containingFile = place.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"containingFile");
        GradleExtensionsSettings.GradleExtensionsData gradleExtensionsData = GradleExtensionsContributor.Companion.getExtensionsFor((PsiElement)psiFile);
        if (gradleExtensionsData == null) {
            return;
        }
        GradleExtensionsSettings.GradleExtensionsData extensionsData = gradleExtensionsData;
        String name = ResolveUtilKt.getName((PsiScopeProcessor)processor, (ResolveState)state);
        Map map = extensionsData.extensions;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"extensionsData.extensions");
        Map allExtensions = map;
        if (name == null) {
            collection = allExtensions.values();
        } else {
            GradleExtensionsSettings.GradleExtension gradleExtension = (GradleExtensionsSettings.GradleExtension)allExtensions.get(name);
            if (gradleExtension == null) {
                return;
            }
            collection = extensions = (Collection)CollectionsKt.listOf((Object)gradleExtension);
        }
        if (extensions.isEmpty()) {
            return;
        }
        PsiElementFactory factory = PsiElementFactory.getInstance((Project)containingFile.getProject());
        PsiManager manager = containingFile.getManager();
        for (GradleExtensionsSettings.GradleExtension extension : extensions) {
            GrLightMethodBuilder extensionMethod;
            GrLightMethodBuilder grLightMethodBuilder;
            PsiType delegateType;
            Intrinsics.checkNotNullExpressionValue((Object)factory.createTypeFromText(extension.rootTypeFqn, place), (String)"factory.createTypeFromTe\u2026nsion.rootTypeFqn, place)");
            if (!(delegateType instanceof PsiClassType)) continue;
            GradleExtensionType type = new GradleExtensionType((PsiClassType)delegateType);
            if (processProperties) {
                String string = extension.name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extension.name");
                GradleExtensionProperty extensionProperty = new GradleExtensionProperty(string, (PsiType)type, (PsiElement)containingFile);
                if (!processor.execute((PsiElement)extensionProperty, state)) {
                    return;
                }
            }
            if (!processMethods) continue;
            GrLightMethodBuilder $this$apply = grLightMethodBuilder = new GrLightMethodBuilder(manager, extension.name);
            boolean bl = false;
            $this$apply.setReturnType((PsiType)type);
            $this$apply.setContainingClass(aClass);
            GradleExtensionsSettings.GradleExtension gradleExtension = extension;
            Intrinsics.checkNotNullExpressionValue((Object)gradleExtension, (String)"extension");
            if (this.shouldAddConfiguration(gradleExtension, place)) {
                $this$apply.addAndGetParameter("configuration", (PsiType)TypesUtil.createType((String)"groovy.lang.Closure", (PsiElement)((PsiElement)containingFile))).putUserData(GrDelegatesToUtilKt.DELEGATES_TO_KEY, (Object)new DelegatesToInfo((PsiType)type, 1));
            }
            if (processor.execute((PsiElement)(extensionMethod = grLightMethodBuilder), state)) continue;
            return;
        }
    }

    private final boolean shouldAddConfiguration(GradleExtensionsSettings.GradleExtension extension, PsiElement context) {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass(extension.rootTypeFqn, context.getResolveScope());
        if (psiClass == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"JavaPsiFacade.getInstanc\u2026olveScope) ?: return true");
        PsiClass clazz = psiClass;
        return !InheritanceUtil.isInheritor((PsiClass)clazz, (String)"org.gradle.api.internal.catalog.AbstractExternalDependencyFactory");
    }
}

