/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import com.intellij.openapi.util.text.StringUtilRt;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.validation.DefaultModelValidator;
import org.apache.maven.model.validation.ModelValidator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ModelInterpolator2;

@Component(role=CustomModelValidator385.class, hint="ide")
public class CustomModelValidator385
implements ModelValidator {
    @Requirement(role=ModelInterpolator.class)
    private CustomMaven3ModelInterpolator2 myModelInterpolator;
    @Requirement(role=ModelValidator.class)
    private DefaultModelValidator myDefaultModelValidator;

    public CustomModelValidator385(CustomMaven3ModelInterpolator2 modelInterpolator, DefaultModelValidator defaultModelValidator) {
        this.myModelInterpolator = modelInterpolator;
        this.myDefaultModelValidator = defaultModelValidator;
    }

    public void validateRawModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        ProxyModelProblemCollector problemsProxy = new ProxyModelProblemCollector(problems);
        this.myDefaultModelValidator.validateRawModel(model, request, (ModelProblemCollector)problemsProxy);
        Parent parent = model.getParent();
        if (parent != null && !problemsProxy.hasFatalErrors() && (parent.getGroupId().contains("${") || parent.getArtifactId().contains("${") || parent.getVersion().contains("${"))) {
            this.myModelInterpolator.interpolateObject((Object)parent, model, model.getProjectDirectory(), request, problems);
            if (CustomModelValidator385.equals(parent.getGroupId(), model.getGroupId()) && CustomModelValidator385.equals(parent.getArtifactId(), model.getArtifactId())) {
                try {
                    this.myDefaultModelValidator.validateRawModel(model, request, (ModelProblemCollector)new AbortOnFirstErrorProblemsCollector(problems));
                }
                catch (AbortOnErrorException abortOnErrorException) {
                    // empty catch block
                }
            }
        }
    }

    public void validateEffectiveModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        this.myDefaultModelValidator.validateEffectiveModel(model, request, problems);
    }

    private static boolean equals(String a, String b) {
        return StringUtilRt.notNullize((String)a).equals(StringUtilRt.notNullize((String)b));
    }

    private static class AbortOnFirstErrorProblemsCollector
    extends ProxyModelProblemCollector {
        AbortOnFirstErrorProblemsCollector(ModelProblemCollector delegate) {
            super(delegate);
        }

        @Override
        public void add(ModelProblemCollectorRequest request) {
            super.add(request);
            throw new AbortOnErrorException();
        }
    }

    private static class AbortOnErrorException
    extends RuntimeException {
        private AbortOnErrorException() {
        }
    }

    private static class ProxyModelProblemCollector
    implements ModelProblemCollector {
        private final ModelProblemCollector myDelegate;
        private boolean myHasFatalErrors = false;

        ProxyModelProblemCollector(ModelProblemCollector delegate) {
            this.myDelegate = delegate;
        }

        public void add(ModelProblemCollectorRequest request) {
            this.myHasFatalErrors |= request.getSeverity() == ModelProblem.Severity.FATAL;
            this.myDelegate.add(request);
        }

        public boolean hasFatalErrors() {
            return this.myHasFatalErrors;
        }
    }
}

