/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.Duration;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WithThrowable;
import org.assertj.core.internal.Futures;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractFutureAssert<SELF extends AbstractFutureAssert<SELF, ACTUAL, RESULT>, ACTUAL extends Future<RESULT>, RESULT>
extends AbstractAssert<SELF, ACTUAL> {
    @VisibleForTesting
    Futures futures = Futures.instance();

    protected AbstractFutureAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isCancelled() {
        this.futures.assertIsCancelled(this.info, (Future)this.actual);
        return (SELF)((AbstractFutureAssert)this.myself);
    }

    public SELF isNotCancelled() {
        this.futures.assertIsNotCancelled(this.info, (Future)this.actual);
        return (SELF)((AbstractFutureAssert)this.myself);
    }

    public SELF isDone() {
        this.futures.assertIsDone(this.info, (Future)this.actual);
        return (SELF)((AbstractFutureAssert)this.myself);
    }

    public SELF isNotDone() {
        this.futures.assertIsNotDone(this.info, (Future)this.actual);
        return (SELF)((AbstractFutureAssert)this.myself);
    }

    public ObjectAssert<RESULT> succeedsWithin(Duration timeout) {
        return this.internalSucceedsWithin(timeout);
    }

    public ObjectAssert<RESULT> succeedsWithin(long timeout, TimeUnit unit) {
        return this.internalSucceedsWithin(timeout, unit);
    }

    public <ASSERT extends AbstractAssert<?, ?>> ASSERT succeedsWithin(Duration timeout, InstanceOfAssertFactory<RESULT, ASSERT> assertFactory) {
        return this.internalSucceedsWithin(timeout).asInstanceOf(assertFactory);
    }

    public <ASSERT extends AbstractAssert<?, ?>> ASSERT succeedsWithin(long timeout, TimeUnit unit, InstanceOfAssertFactory<RESULT, ASSERT> assertFactory) {
        return this.internalSucceedsWithin(timeout, unit).asInstanceOf(assertFactory);
    }

    public WithThrowable failsWithin(Duration timeout) {
        return this.internalFailsWithin(timeout);
    }

    public WithThrowable failsWithin(long timeout, TimeUnit unit) {
        return this.internalFailsWithin(timeout, unit);
    }

    private WithThrowable internalFailsWithin(Duration timeout) {
        Exception exception = this.futures.assertFailedWithin(this.info, (Future)this.actual, timeout);
        return new WithThrowable(exception);
    }

    private WithThrowable internalFailsWithin(long timeout, TimeUnit unit) {
        Exception exception = this.futures.assertFailedWithin(this.info, (Future)this.actual, timeout, unit);
        return new WithThrowable(exception);
    }

    private ObjectAssert<RESULT> internalSucceedsWithin(Duration timeout) {
        Object result2 = this.futures.assertSucceededWithin(this.info, (Future)this.actual, timeout);
        return AssertionsForClassTypes.assertThat(result2);
    }

    private ObjectAssert<RESULT> internalSucceedsWithin(long timeout, TimeUnit unit) {
        Object result2 = this.futures.assertSucceededWithin(this.info, (Future)this.actual, timeout, unit);
        return AssertionsForClassTypes.assertThat(result2);
    }
}

