/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.applet;

import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.Window;
import java.net.URL;
import java.util.Map;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.util.Maps;

public class BasicAppletStub
implements AppletStub {
    private final Window viewer;
    private final AppletContext context;
    private final Map<String, String> parameters = Maps.newHashMap();

    public BasicAppletStub(@Nonnull Window viewer, @Nonnull AppletContext context2, @Nonnull Map<String, String> parameters) {
        this(viewer, context2);
        this.parameters.putAll(Preconditions.checkNotNull(parameters));
    }

    public BasicAppletStub(@Nonnull Window viewer, @Nonnull AppletContext context2) {
        this.viewer = Preconditions.checkNotNull(viewer);
        this.context = Preconditions.checkNotNull(context2);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void appletResize(int width, int height) {
        this.viewer.setSize(width, height);
    }

    @Override
    @Nonnull
    public AppletContext getAppletContext() {
        return this.context;
    }

    @Override
    public URL getCodeBase() {
        return this.getDocumentBase();
    }

    @Override
    public URL getDocumentBase() {
        return this.getClass().getResource(".");
    }

    @Override
    @Nullable
    public String getParameter(@Nullable String name) {
        return this.parameters.get(name);
    }
}

