/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.timing;

import java.util.concurrent.TimeUnit;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.dependency.jsr305.Nonnull;

public final class Timeout {
    private static final int DEFAULT_DELAY = 30000;
    private final long duration;

    @Nonnull
    public static Timeout timeout() {
        return Timeout.timeout(30000L);
    }

    @Nonnull
    public static Timeout timeout(long duration2) {
        return new Timeout(duration2);
    }

    @Nonnull
    public static Timeout timeout(long duration2, @Nonnull TimeUnit timeUnit) {
        Preconditions.checkNotNull(timeUnit);
        return new Timeout(timeUnit.toMillis(duration2));
    }

    private Timeout(long duration2) {
        this.duration = duration2;
    }

    public long duration() {
        return this.duration;
    }

    public int hashCode() {
        return 31 + (int)(this.duration ^ this.duration >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Timeout other = (Timeout)obj;
        return this.duration == other.duration;
    }
}

