/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.context;

import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.computed.ContentsToken;
import org.jfree.layouting.layouter.context.QuotesPair;

public class ContentSpecification {
    private static final QuotesPair[] EMPTY_QUOTES = new QuotesPair[0];
    private static final ContentsToken[] EMPTY_CONTENT = new ContentsToken[0];
    private QuotesPair[] quotes = EMPTY_QUOTES;
    private ContentToken[] contents = EMPTY_CONTENT;
    private ContentToken[] strings = EMPTY_CONTENT;
    private ContentToken[] alternateText = EMPTY_CONTENT;
    private boolean allowContentProcessing = true;
    private boolean inhibitContent;
    private int quotingLevel;
    private String moveTarget;

    public boolean isInhibitContent() {
        return this.inhibitContent;
    }

    public void setInhibitContent(boolean bl) {
        this.inhibitContent = bl;
    }

    public QuotesPair[] getQuotes() {
        return (QuotesPair[])this.quotes.clone();
    }

    public ContentToken[] getStrings() {
        return (ContentToken[])this.strings.clone();
    }

    public void setStrings(ContentToken[] contentTokenArray) {
        this.strings = (ContentToken[])contentTokenArray.clone();
    }

    public ContentToken[] getAlternateText() {
        return (ContentToken[])this.alternateText.clone();
    }

    public void setAlternateText(ContentToken[] contentTokenArray) {
        this.alternateText = (ContentToken[])contentTokenArray.clone();
    }

    public String getOpenQuote(int n) {
        if (n < 0) {
            return "";
        }
        if (n >= this.quotes.length) {
            if (this.quotes.length == 0) {
                return "";
            }
            return this.quotes[this.quotes.length - 1].getOpenQuote();
        }
        return this.quotes[n].getOpenQuote();
    }

    public String getCloseQuote(int n) {
        if (n < 0) {
            return "";
        }
        if (n >= this.quotes.length) {
            if (this.quotes.length == 0) {
                return "";
            }
            return this.quotes[this.quotes.length - 1].getCloseQuote();
        }
        return this.quotes[n].getCloseQuote();
    }

    public void setQuotes(QuotesPair[] quotesPairArray) {
        if (this.quotes == null) {
            throw new NullPointerException();
        }
        this.quotes = (QuotesPair[])quotesPairArray.clone();
    }

    public ContentToken[] getContents() {
        return (ContentToken[])this.contents.clone();
    }

    public void setContents(ContentToken[] contentTokenArray) {
        this.contents = (ContentToken[])contentTokenArray.clone();
    }

    public boolean isAllowContentProcessing() {
        return this.allowContentProcessing;
    }

    public void setAllowContentProcessing(boolean bl) {
        this.allowContentProcessing = bl;
    }

    public int getQuotingLevel() {
        return this.quotingLevel;
    }

    public void setQuotingLevel(int n) {
        this.quotingLevel = n;
    }

    public String getMoveTarget() {
        return this.moveTarget;
    }

    public void setMoveTarget(String string) {
        this.moveTarget = string;
    }
}

