/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.awt;

import org.pentaho.reporting.libraries.fonts.awt.AWTFontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;

public class AWTFontFamily
implements FontFamily {
    private String fontName;
    private AWTFontRecord[] fonts;

    public AWTFontFamily(String fontName) {
        this.fontName = fontName;
        this.fonts = new AWTFontRecord[4];
    }

    @Override
    public String getFamilyName() {
        return this.fontName;
    }

    @Override
    public String[] getAllNames() {
        return new String[]{this.fontName};
    }

    @Override
    public FontRecord getFontRecord(boolean bold, boolean italics) {
        int index = 0;
        if (bold) {
            ++index;
        }
        if (italics) {
            index += 2;
        }
        if (this.fonts[index] != null) {
            return this.fonts[index];
        }
        this.fonts[index] = new AWTFontRecord(this, bold, italics);
        return this.fonts[index];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWTFontFamily that = (AWTFontFamily)o;
        return this.fontName.equals(that.fontName);
    }

    public int hashCode() {
        return this.fontName.hashCode();
    }
}

