/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig.keyinfo;

import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;

public class X509DataTest
extends TestCase {
    private KeyInfoFactory fac;

    public X509DataTest() {
        super("X509DataTest");
    }

    public X509DataTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.fac = KeyInfoFactory.getInstance("DOM", new XMLDSigRI());
    }

    public void tearDown() {
    }

    public void testgetTypes() {
        X509Data x509Data = this.fac.newX509Data(Collections.singletonList("cn=foo"));
        List<?> list = x509Data.getContent();
        X509DataTest.assertNotNull(list);
        if (!list.isEmpty()) {
            Object[] objectArray = list.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof String || objectArray[i] instanceof byte[] || objectArray[i] instanceof X509Certificate || objectArray[i] instanceof X509CRL || objectArray[i] instanceof XMLStructure) continue;
                X509DataTest.fail((String)"X509 element has the wrong type");
            }
        } else {
            list.add("any string");
            list.add(new byte[5]);
            try {
                list.add(new Object());
                X509DataTest.fail((String)"Added X509 element of wrong type");
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void testConstructor() {
        X509Data x509Data = this.fac.newX509Data(Collections.singletonList("cn=foo"));
        X509DataTest.assertNotNull((Object)x509Data);
    }

    public void testisFeatureSupported() {
        X509Data x509Data = this.fac.newX509Data(Collections.singletonList("cn=foo"));
        try {
            x509Data.isFeatureSupported(null);
            X509DataTest.fail((String)"Should raise a NPE for null feature");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        X509DataTest.assertTrue((!x509Data.isFeatureSupported("not supported") ? 1 : 0) != 0);
    }
}

