/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.preferencespanel;

import java.awt.Color;
import java.awt.GridLayout;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jd.gui.service.platform.PlatformService;
import org.jd.gui.spi.PreferencesPanel;

public class UITabsPreferencesProvider
extends JPanel
implements PreferencesPanel {
    protected static final String TAB_LAYOUT = "UITabsPreferencesProvider.singleLineTabs";
    protected JCheckBox singleLineTabsCheckBox = new JCheckBox("Tabs on a single line");

    public UITabsPreferencesProvider() {
        super(new GridLayout(0, 1));
        this.add(this.singleLineTabsCheckBox);
    }

    @Override
    public String getPreferencesGroupTitle() {
        return "User Interface";
    }

    @Override
    public String getPreferencesPanelTitle() {
        return "Tabs";
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void init(Color errorBackgroundColor) {
    }

    @Override
    public boolean isActivated() {
        return !PlatformService.getInstance().isMac();
    }

    @Override
    public void loadPreferences(Map<String, String> preferences) {
        this.singleLineTabsCheckBox.setSelected("true".equals(preferences.get(TAB_LAYOUT)));
    }

    @Override
    public void savePreferences(Map<String, String> preferences) {
        preferences.put(TAB_LAYOUT, Boolean.toString(this.singleLineTabsCheckBox.isSelected()));
    }

    @Override
    public boolean arePreferencesValid() {
        return true;
    }

    @Override
    public void addPreferencesChangeListener(PreferencesPanel.PreferencesPanelChangeListener listener) {
    }
}

