/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_bs_Cyrl extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_MonthNames = new String[] {
               "\u0458\u0430\u043d\u0443\u0430\u0440",
               "\u0444\u0435\u0431\u0440\u0443\u0430\u0440",
               "\u043c\u0430\u0440\u0442",
               "\u0430\u043f\u0440\u0438\u043b",
               "\u043c\u0430\u0458",
               "\u0458\u0443\u043d\u0438",
               "\u0458\u0443\u043b\u0438",
               "\u0430\u0443\u0433\u0443\u0441\u0442",
               "\u0441\u0435\u043f\u0442\u0435\u043c\u0431\u0430\u0440",
               "\u043e\u043a\u0442\u043e\u0431\u0430\u0440",
               "\u043d\u043e\u0432\u0435\u043c\u0431\u0430\u0440",
               "\u0434\u0435\u0446\u0435\u043c\u0431\u0430\u0440",
               "",
            };
        final String[] metaValue_MonthAbbreviations = new String[] {
               "\u0458\u0430\u043d",
               "\u0444\u0435\u0431",
               "\u043c\u0430\u0440",
               "\u0430\u043f\u0440",
               "\u043c\u0430\u0458",
               "\u0458\u0443\u043d",
               "\u0458\u0443\u043b",
               "\u0430\u0443\u0433",
               "\u0441\u0435\u043f",
               "\u043e\u043a\u0442",
               "\u043d\u043e\u0432",
               "\u0434\u0435\u0446",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "\u0458",
               "\u0444",
               "\u043c",
               "\u0430",
               "\u043c",
               "\u0458",
               "\u0458",
               "\u0430",
               "\u0441",
               "\u043e",
               "\u043d",
               "\u0434",
               "",
            };
        final String[] metaValue_DayNames = new String[] {
               "\u043d\u0435\u0434\u0458\u0435\u0459\u0430",
               "\u043f\u043e\u043d\u0435\u0434\u0458\u0435\u0459\u0430\u043a",
               "\u0443\u0442\u043e\u0440\u0430\u043a",
               "\u0441\u0440\u0438\u0458\u0435\u0434\u0430",
               "\u0447\u0435\u0442\u0432\u0440\u0442\u0430\u043a",
               "\u043f\u0435\u0442\u0430\u043a",
               "\u0441\u0443\u0431\u043e\u0442\u0430",
            };
        final String[] metaValue_DayAbbreviations = new String[] {
               "\u043d\u0435\u0434",
               "\u043f\u043e\u043d",
               "\u0443\u0442\u043e",
               "\u0441\u0440\u0438",
               "\u0447\u0435\u0442",
               "\u043f\u0435\u0442",
               "\u0441\u0443\u0431",
            };
        final String[] metaValue_DayNarrows = new String[] {
               "\u043d",
               "\u043f",
               "\u0443",
               "\u0441",
               "\u0447",
               "\u043f",
               "\u0441",
            };
        final String[] metaValue_QuarterNames = new String[] {
               "\u041f\u0440\u0432\u043e \u0442\u0440\u043e\u043c\u0435\u0441\u0435\u0447\u0458\u0435",
               "\u0414\u0440\u0443\u0433\u043e \u0442\u0440\u043e\u043c\u0435\u0441\u0435\u0447\u0458\u0435",
               "\u0422\u0440\u0435\u045b\u0435 \u0442\u0440\u043e\u043c\u0435\u0441\u0435\u0447\u0458\u0435",
               "\u0427\u0435\u0442\u0432\u0440\u0442\u043e \u0442\u0440\u043e\u043c\u0435\u0441\u0435\u0447\u0458\u0435",
            };
        final String[] metaValue_QuarterAbbreviations = new String[] {
               "\u041a1",
               "\u041a2",
               "\u041a3",
               "\u041a4",
            };
        final String[] metaValue_QuarterNarrows = new String[] {
               "1.",
               "2.",
               "3.",
               "4.",
            };
        final String[] metaValue_AmPmMarkers = new String[] {
               "\u043f\u0440\u0438\u0458\u0435 \u043f\u043e\u0434\u043d\u0435",
               "\u043f\u043e\u0441\u043b\u0438\u0458\u0435 \u043f\u043e\u0434\u043d\u0435",
               "\u043f\u043e\u043d\u043e\u045b",
               "\u043f\u043e\u0434\u043d\u0435",
               "\u0443\u0458\u0443\u0442\u0440\u0443",
               "",
               "\u0443 \u043f\u043e\u0434\u043d\u0435",
               "",
               "\u0443\u0432\u0435\u0447\u0435",
               "",
               "\u043d\u043e\u045b\u0443",
               "",
            };
        final String[] metaValue_narrow_AmPmMarkers = new String[] {
               "AM",
               "PM",
               "\u043f\u043e\u043d\u043e\u045b",
               "\u043f\u043e\u0434\u043d\u0435",
               "\u0443\u0458\u0443\u0442\u0440\u0443",
               "",
               "\u0443 \u043f\u043e\u0434\u043d\u0435",
               "",
               "\u0443\u0432\u0435\u0447\u0435",
               "",
               "\u043d\u043e\u045b\u0443",
               "",
            };
        final String[] metaValue_abbreviated_AmPmMarkers = new String[] {
               "\u043f\u0440\u0435 \u043f\u043e\u0434\u043d\u0435",
               "\u043f\u043e\u043f\u043e\u0434\u043d\u0435",
               "\u043f\u043e\u043d\u043e\u045b",
               "\u043f\u043e\u0434\u043d\u0435",
               "\u0443\u0458\u0443\u0442\u0440\u0443",
               "",
               "\u0443 \u043f\u043e\u0434\u043d\u0435",
               "",
               "\u0443\u0432\u0435\u0447\u0435",
               "",
               "\u043d\u043e\u045b\u0443",
               "",
            };
        final String[] metaValue_TimePatterns = new String[] {
               "HH:mm:ss zzzz",
               "HH:mm:ss z",
               "HH:mm:ss",
               "HH:mm",
            };
        final String[] metaValue_java_time_buddhist_long_Eras = new String[] {
               "BC",
               "\u0411\u0415",
            };
        final String[] metaValue_java_time_buddhist_DatePatterns = new String[] {
               "EEEE, dd. MMMM y. G",
               "dd. MMMM y. G",
               "dd.MM.y. G",
               "d.M.y. GGGGG",
            };
        final String[] metaValue_buddhist_DatePatterns = new String[] {
               "EEEE, dd. MMMM y. GGGG",
               "dd. MMMM y. GGGG",
               "dd.MM.y. GGGG",
               "d.M.y. G",
            };
        final String[] metaValue_java_time_japanese_long_Eras = new String[] {
               "\u043d\u043e\u0432\u0435 \u0435\u0440\u0435",
               "\u041c\u0435\u0438\u0452\u0438",
               "\u0422\u0430\u0438\u0448\u043e",
               "\u0428\u043e\u0432\u0430",
               "\u0425\u0430\u0438\u0441\u0435\u0438",
               "\u0420\u0435\u0438\u0432\u0430",
            };
        final String[] metaValue_java_time_japanese_Eras = new String[] {
               "\u043d. \u0435.",
               "\u041c\u0435\u0438\u0452\u0438",
               "\u0422\u0430\u0438\u0448\u043e",
               "\u0428\u043e\u0432\u0430",
               "\u0425\u0430\u0438\u0441\u0435\u0438",
               "\u0420\u0435\u0438\u0432\u0430",
            };
        final String[] metaValue_java_time_roc_long_Eras = new String[] {
               "\u041f\u0440\u0435 \u0420\u041a",
               "\u0420\u041a",
            };
        final String[] metaValue_java_time_islamic_long_Eras = new String[] {
               "",
               "\u0410\u0425",
            };
        final String metaValue_calendarname_gregorian = "\u0433\u0440\u0435\u0433\u043e\u0440\u0438\u0458\u0430\u043d\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440";
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "field.year", "\u0433\u043e\u0434\u0438\u043d\u0430" },
            { "japanese.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.narrow.Eras", metaValue_java_time_buddhist_long_Eras },
            { "AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.japanese.DatePatterns",
                new String[] {
                    "EEEE, MMMM d, y G",
                    "MMMM d, y G",
                    "MMM d, y G",
                    "M/d/yy G",
                }
            },
            { "standalone.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.QuarterNames", metaValue_QuarterNames },
            { "calendarname.islamic-civil", "\u0418\u0441\u043b\u0430\u043c\u0441\u043a\u0438 \u0446\u0438\u0432\u0438\u043b\u043d\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "islamic.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "japanese.TimePatterns", metaValue_TimePatterns },
            { "roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "narrow.Eras",
                new String[] {
                    "\u043f.\u043d.\u0435.",
                    "\u043d.\u0435.",
                }
            },
            { "abbreviated.AmPmMarkers", metaValue_abbreviated_AmPmMarkers },
            { "japanese.abbreviated.AmPmMarkers", metaValue_abbreviated_AmPmMarkers },
            { "calendarname.japanese", "\u0458\u0430\u043f\u0430\u043d\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "standalone.DayAbbreviations", metaValue_DayAbbreviations },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "java.time.islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "long.Eras",
                new String[] {
                    "\u043f\u0440\u0438\u0458\u0435 \u043d\u043e\u0432\u0435 \u0435\u0440\u0435",
                    "\u043d\u043e\u0432\u0435 \u0435\u0440\u0435",
                }
            },
            { "roc.QuarterNarrows", metaValue_QuarterNarrows },
            { "islamic.DayNames", metaValue_DayNames },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "DateTimePatterns",
                new String[] {
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                }
            },
            { "narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "latn.NumberElements",
                new String[] {
                    ",",
                    ".",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DatePatterns",
                new String[] {
                    "EEEE, MMMM d, y GGGG",
                    "MMMM d, y GGGG",
                    "MMM d, y GGGG",
                    "M/d/yy GGGG",
                }
            },
            { "buddhist.DayNames", metaValue_DayNames },
            { "field.minute", "\u043c\u0438\u043d\u0443\u0442" },
            { "japanese.long.Eras", metaValue_java_time_japanese_long_Eras },
            { "field.era", "\u0435\u0440\u0430" },
            { "buddhist.AmPmMarkers", metaValue_AmPmMarkers },
            { "field.dayperiod", "\u043f\u0440\u0438\u0458\u0435 \u043f\u043e\u0434\u043d\u0435/\u043f\u043e\u0441\u043b\u0438\u0458\u0435 \u043f\u043e\u0434\u043d\u0435" },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.MonthNames",
                new String[] {
                    "\u041c\u0443\u0440\u0430\u0445\u0430\u043c",
                    "\u0421\u0430\u0444\u0430\u0440",
                    "\u0420\u0430\u0431\u0438\u02bb I",
                    "\u0420\u0430\u0431\u0438\u02bb II",
                    "\u0408\u0443\u043c\u0430\u0434\u0430 I",
                    "\u0408\u0443\u043c\u0430\u0434\u0430 II",
                    "\u0420\u0430\u0452\u0430\u0431",
                    "\u0428\u0430\u02bb\u0431\u0430\u043d",
                    "\u0420\u0430\u043c\u0430\u0434\u0430\u043d",
                    "\u0428\u0430\u0432\u0430\u043b",
                    "\u0414\u0443\u02bb\u043b-\u041a\u0438\u02bb\u0434\u0430",
                    "\u0414\u0443\u02bb\u043b-\u0445\u0438\u0452\u0430",
                    "",
                }
            },
            { "japanese.QuarterNarrows", metaValue_QuarterNarrows },
            { "calendarname.roc", "\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440 \u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0435 \u041a\u0438\u043d\u0435" },
            { "islamic.DatePatterns",
                new String[] {
                    "EEEE, dd. MMMM y. GGGG",
                    "dd. MMMM y. GGGG",
                    "dd.MM.y. GGGG",
                    "dd.MM.y. GGGG",
                }
            },
            { "roc.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "field.month", "\u043c\u0458\u0435\u0441\u0435\u0446" },
            { "java.time.japanese.long.Eras", metaValue_java_time_japanese_long_Eras },
            { "roc.Eras", metaValue_java_time_roc_long_Eras },
            { "field.second", "\u0441\u0435\u043a\u0443\u043d\u0434" },
            { "DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNarrows", metaValue_DayNarrows },
            { "roc.DatePatterns", metaValue_buddhist_DatePatterns },
            { "calendarname.islamic", "\u0438\u0441\u043b\u0430\u043c\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "java.time.roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "java.time.roc.narrow.Eras", metaValue_java_time_roc_long_Eras },
            { "japanese.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.TimePatterns", metaValue_TimePatterns },
            { "standalone.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "timezone.regionFormat", "\u0412\u0440\u0435\u043c\u0435: {0}" },
            { "long.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0 few:0 other:0}",
                    "{one:00' '\u0445\u0438\u0459 few:00' '\u0445\u0438\u0459 other:00' '\u0445\u0438\u0459}",
                    "{one:000' '\u0445\u0438\u0459 few:000' '\u0445\u0438\u0459 other:000' '\u0445\u0438\u0459}",
                    "{one:0' '\u043c\u0438\u043b few:0' '\u043c\u0438\u043b other:0' '\u043c\u0438\u043b}",
                    "{one:00' '\u043c\u0438\u043b few:00' '\u043c\u0438\u043b other:00' '\u043c\u0438\u043b}",
                    "{one:000' '\u043c\u0438\u043b few:000' '\u043c\u0438\u043b other:000' '\u043c\u0438\u043b}",
                    "{one:0' '\u043c\u043b\u0440\u0434 few:0' '\u043c\u043b\u0440\u0434 other:0' '\u043c\u043b\u0440\u0434}",
                    "{one:00' '\u043c\u043b\u0440\u0434 few:00' '\u043c\u043b\u0440\u0434 other:00' '\u043c\u043b\u0440\u0434}",
                    "{one:000' '\u043c\u043b\u0440\u0434 few:000' '\u043c\u043b\u0440\u0434 other:000' '\u043c\u043b\u0440\u0434}",
                    "{one:0' '\u0431\u0438\u043b few:0' '\u0431\u0438\u043b other:0' '\u0431\u0438\u043b}",
                    "{one:00' '\u0431\u0438\u043b few:00' '\u0431\u0438\u043b other:00' '\u0431\u0438\u043b}",
                    "{one:000' '\u0431\u0438\u043b few:000' '\u0431\u0438\u043b other:000' '\u0431\u0438\u043b}",
                }
            },
            { "buddhist.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "standalone.QuarterNames", metaValue_QuarterNames },
            { "islamic.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.DayAbbreviations", metaValue_DayAbbreviations },
            { "standalone.DayNarrows", metaValue_DayNarrows },
            { "java.time.buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "islamic.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "TimePatterns", metaValue_TimePatterns },
            { "java.time.roc.Eras", metaValue_java_time_roc_long_Eras },
            { "field.zone", "\u0437\u043e\u043d\u0430" },
            { "japanese.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.narrow.Eras", metaValue_java_time_roc_long_Eras },
            { "buddhist.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_abbreviated_AmPmMarkers },
            { "Eras",
                new String[] {
                    "\u043f. \u043d. \u0435.",
                    "\u043d. \u0435.",
                }
            },
            { "roc.DayNames", metaValue_DayNames },
            { "islamic.QuarterNames", metaValue_QuarterNames },
            { "QuarterNarrows", metaValue_QuarterNarrows },
            { "islamic.abbreviated.AmPmMarkers", metaValue_abbreviated_AmPmMarkers },
            { "standalone.QuarterNarrows", metaValue_QuarterNarrows },
            { "java.time.islamic.DatePatterns",
                new String[] {
                    "EEEE, dd. MMMM y. G",
                    "dd. MMMM y. G",
                    "dd.MM.y. G",
                    "dd.MM.y. G",
                }
            },
            { "field.weekday", "\u0434\u0430\u043d \u0443 \u0441\u0435\u0434\u043c\u0438\u0446\u0438" },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "islamic.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "java.time.islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "japanese.QuarterNames", metaValue_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "java.time.buddhist.Eras", metaValue_java_time_buddhist_long_Eras },
            { "japanese.DayNames", metaValue_DayNames },
            { "japanese.DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNames", metaValue_DayNames },
            { "buddhist.DatePatterns", metaValue_buddhist_DatePatterns },
            { "java.time.japanese.Eras", metaValue_java_time_japanese_Eras },
            { "roc.MonthNames", metaValue_MonthNames },
            { "buddhist.Eras", metaValue_java_time_buddhist_long_Eras },
            { "field.week", "\u0441\u0435\u0434\u043c\u0438\u0446\u0430" },
            { "buddhist.QuarterNames", metaValue_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.DayNarrows", metaValue_DayNarrows },
            { "roc.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.roc.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "short.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0 few:0 other:0}",
                    "{one:00\u00a0\u0445\u0438\u0459 few:00\u00a0\u0445\u0438\u0459 other:00\u00a0\u0445\u0438\u0459}",
                    "{one:000\u00a0\u0445\u0438\u0459 few:000\u00a0\u0445\u0438\u0459 other:000\u00a0\u0445\u0438\u0459}",
                    "{one:0\u00a0\u043c\u0438\u043b few:0\u00a0\u043c\u0438\u043b other:0\u00a0\u043c\u0438\u043b}",
                    "{one:00\u00a0\u043c\u0438\u043b few:00\u00a0\u043c\u0438\u043b other:00\u00a0\u043c\u0438\u043b}",
                    "{one:000\u00a0\u043c\u0438\u043b few:000\u00a0\u043c\u0438\u043b other:000\u00a0\u043c\u0438\u043b}",
                    "{one:0\u00a0\u043c\u043b\u0440\u0434 few:0\u00a0\u043c\u043b\u0440\u0434 other:0\u00a0\u043c\u043b\u0440\u0434}",
                    "{one:00\u00a0\u043c\u043b\u0440\u0434 few:00\u00a0\u043c\u043b\u0440\u0434 other:00\u00a0\u043c\u043b\u0440\u0434}",
                    "{one:000\u00a0\u043c\u043b\u0440\u0434 few:000\u00a0\u043c\u043b\u0440\u0434 other:000\u00a0\u043c\u043b\u0440\u0434}",
                    "{one:0\u00a0\u0431\u0438\u043b few:0\u00a0\u0431\u0438\u043b other:0\u00a0\u0431\u0438\u043b}",
                    "{one:00\u00a0\u0431\u0438\u043b few:00\u00a0\u0431\u0438\u043b other:00\u00a0\u0431\u0438\u043b}",
                    "{one:000\u00a0\u0431\u0438\u043b few:000\u00a0\u0431\u0438\u043b other:000\u00a0\u0431\u0438\u043b}",
                }
            },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "java.time.buddhist.narrow.Eras", metaValue_java_time_buddhist_long_Eras },
            { "DatePatterns",
                new String[] {
                    "EEEE, dd. MMMM y.",
                    "dd. MMMM y.",
                    "dd.MM.y.",
                    "d.M.yy.",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.TimePatterns", metaValue_TimePatterns },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.DayNames", metaValue_DayNames },
            { "field.hour", "\u0441\u0430\u0442" },
            { "islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "calendarname.buddhist", "\u0431\u0443\u0434\u0438\u0441\u0442\u0438\u0447\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "latn.NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "#,##0.00\u00a0\u00a4",
                    "#,##0%",
                    "",
                }
            },
            { "java.time.islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "QuarterNames", metaValue_QuarterNames },
            { "roc.TimePatterns", metaValue_TimePatterns },
            { "QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "japanese.Eras", metaValue_java_time_japanese_Eras },
            { "roc.abbreviated.AmPmMarkers", metaValue_abbreviated_AmPmMarkers },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
        };
        return data;
    }
}
