/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.ConferenceConfig;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.JicofoServices;
import org.jitsi.jicofo.conference.ConferenceMetrics;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.jibri.JibriRecorder;
import org.jitsi.jicofo.jibri.JibriSession;
import org.jitsi.jicofo.jibri.JibriSipGateway;
import org.jitsi.jicofo.jibri.JibriStats;
import org.jitsi.jicofo.metrics.JicofoMetricsContainer;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.metrics.LongGaugeMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.queue.QueueStatistics;
import org.jitsi.utils.stats.BucketStats;
import org.jitsi.utils.stats.ConferenceSizeBuckets;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.jxmpp.jid.EntityBareJid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0002JKB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0017H\u0016J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u000eH\u0016J8\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\r2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020,0+2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u00020(H\u0007J4\u00100\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\r2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020,0+2\u0006\u00101\u001a\u00020.2\u0006\u0010/\u001a\u00020(H\u0002J\u0010\u00102\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0002J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0010\u00106\u001a\u0004\u0018\u00010,2\u0006\u00107\u001a\u00020\rJ\u0012\u00108\u001a\u0004\u0018\u00010\u000e2\u0006\u00109\u001a\u00020\rH\u0016J\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u000e\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020(J\u0006\u0010>\u001a\u00020\u001fJ\u001e\u0010?\u001a\u00020#2\u0006\u00107\u001a\u00020\r2\u0006\u0010@\u001a\u00020,2\u0006\u0010A\u001a\u00020BJ\u0010\u0010C\u001a\u00020#2\u0006\u0010D\u001a\u00020(H\u0016J\u0010\u0010E\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0017H\u0016J\u0006\u0010F\u001a\u00020#J\u0006\u0010G\u001a\u00020#J\u000e\u0010H\u001a\u00020#2\u0006\u00107\u001a\u00020\rJ\b\u0010I\u001a\u00020#H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u00060\u001dR\u00020\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006L"}, d2={"Lorg/jitsi/jicofo/FocusManager;", "Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl$ConferenceListener;", "Lorg/jitsi/jicofo/ConferenceStore;", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Listener;", "jicofoServices", "Lorg/jitsi/jicofo/JicofoServices;", "clock", "Ljava/time/Clock;", "(Lorg/jitsi/jicofo/JicofoServices;Ljava/time/Clock;)V", "conferenceCount", "Lorg/jitsi/metrics/LongGaugeMetric;", "conferences", "", "Lorg/jxmpp/jid/EntityBareJid;", "Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;", "conferencesCache", "", "Lorg/jitsi/jicofo/conference/JitsiMeetConference;", "conferencesSyncRoot", "", "expireThread", "Lorg/jitsi/jicofo/FocusManager$FocusExpireThread;", "listeners", "Lorg/jitsi/jicofo/ConferenceStore$Listener;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "pinnedConferences", "Lorg/jitsi/jicofo/FocusManager$PinnedConference;", "stats", "Lorg/json/simple/JSONObject;", "getStats", "()Lorg/json/simple/JSONObject;", "addListener", "", "listener", "conferenceEnded", "conference", "conferenceRequest", "", "room", "properties", "", "", "loggingLevel", "Ljava/util/logging/Level;", "includeInStatistics", "createConference", "logLevel", "expirePins", "curTime", "Ljava/time/Instant;", "getAllConferences", "getBridgeVersionForConference", "roomName", "getConference", "jid", "getConferences", "getDebugState", "Lorg/jitsi/utils/OrderedJsonObject;", "full", "getPinnedConferencesJson", "pinConference", "jvbVersion", "duration", "Ljava/time/Duration;", "registrationChanged", "registered", "removeListener", "start", "stop", "unpinConference", "updateMetrics", "FocusExpireThread", "PinnedConference", "jicofo"})
public final class FocusManager
implements JitsiMeetConferenceImpl.ConferenceListener,
ConferenceStore,
XmppProvider.Listener {
    @NotNull
    private final JicofoServices jicofoServices;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @NotNull
    private final FocusExpireThread expireThread;
    @NotNull
    private final Map<EntityBareJid, JitsiMeetConferenceImpl> conferences;
    @NotNull
    private final LongGaugeMetric conferenceCount;
    @NotNull
    private final List<JitsiMeetConference> conferencesCache;
    @NotNull
    private final Object conferencesSyncRoot;
    @NotNull
    private final List<ConferenceStore.Listener> listeners;
    @NotNull
    private final Map<EntityBareJid, PinnedConference> pinnedConferences;

    public FocusManager(@NotNull JicofoServices jicofoServices, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(jicofoServices, "jicofoServices");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.jicofoServices = jicofoServices;
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        this.expireThread = new FocusExpireThread();
        this.conferences = new ConcurrentHashMap();
        this.conferenceCount = MetricsContainer.registerLongGauge$default(JicofoMetricsContainer.Companion.getInstance(), "conferences", "Running count of conferences (excluding internal conferences created for health checks).", 0L, 4, null);
        this.conferencesCache = new CopyOnWriteArrayList();
        this.conferencesSyncRoot = new Object();
        this.listeners = new ArrayList();
        this.pinnedConferences = new HashMap();
    }

    public /* synthetic */ FocusManager(JicofoServices jicofoServices, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(jicofoServices, clock);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final void start() {
        this.expireThread.start();
    }

    public final void stop() {
        this.expireThread.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final boolean conferenceRequest(@NotNull EntityBareJid room, @NotNull Map<String, String> properties2, @NotNull Level loggingLevel, boolean includeInStatistics) throws Exception {
        Intrinsics.checkNotNullParameter(room, "room");
        Intrinsics.checkNotNullParameter(properties2, "properties");
        Intrinsics.checkNotNullParameter(loggingLevel, "loggingLevel");
        JitsiMeetConferenceImpl conference = null;
        boolean isConferenceCreator = false;
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            boolean bl = false;
            JitsiMeetConferenceImpl existingConference = this.conferences.get(room);
            JitsiMeetConferenceImpl jitsiMeetConferenceImpl = existingConference;
            if (jitsiMeetConferenceImpl == null) {
                jitsiMeetConferenceImpl = this.createConference(room, properties2, loggingLevel, includeInStatistics);
            }
            conference = jitsiMeetConferenceImpl;
            isConferenceCreator = existingConference == null;
            Unit unit = Unit.INSTANCE;
        }
        try {
            if (isConferenceCreator) {
                conference.start();
            }
        }
        catch (Exception e) {
            this.logger.warn("Exception while trying to start the conference", e);
            throw e;
        }
        return conference.isStarted();
    }

    public static /* synthetic */ boolean conferenceRequest$default(FocusManager focusManager, EntityBareJid entityBareJid, Map map, Level level, boolean bl, int n, Object object) throws Exception {
        if ((n & 4) != 0) {
            Level level2 = Level.ALL;
            Intrinsics.checkNotNullExpressionValue(level2, "ALL");
            level = level2;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return focusManager.conferenceRequest(entityBareJid, map, level, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JitsiMeetConferenceImpl createConference(EntityBareJid room, Map<String, String> properties2, Level logLevel, boolean includeInStatistics) {
        JitsiMeetConferenceImpl conference = null;
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            boolean bl = false;
            String jvbVersion = this.getBridgeVersionForConference(room);
            conference = new JitsiMeetConferenceImpl(room, this, properties2, logLevel, jvbVersion, includeInStatistics, this.jicofoServices);
            this.conferences.put(room, conference);
            boolean bl2 = this.conferencesCache.add(conference);
        }
        if (includeInStatistics) {
            this.conferenceCount.inc();
            ConferenceMetrics.conferencesCreated.inc();
        }
        return conference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void conferenceEnded(@NotNull JitsiMeetConferenceImpl conference) {
        Intrinsics.checkNotNullParameter(conference, "conference");
        EntityBareJid entityBareJid = conference.getRoomName();
        Intrinsics.checkNotNullExpressionValue(entityBareJid, "conference.roomName");
        EntityBareJid roomName = entityBareJid;
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            boolean bl = false;
            this.conferences.remove(roomName);
            this.conferencesCache.remove(conference);
            if (conference.includeInStatistics()) {
                this.conferenceCount.dec();
            }
            ArrayList listeners = null;
            List<ConferenceStore.Listener> list = this.listeners;
            synchronized (list) {
                boolean bl2 = false;
                listeners = new ArrayList(this.listeners);
                Unit unit = Unit.INSTANCE;
            }
            for (ConferenceStore.Listener listener : (Iterable)listeners) {
                listener.conferenceEnded(roomName);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public JitsiMeetConferenceImpl getConference(@NotNull EntityBareJid jid) {
        Intrinsics.checkNotNullParameter(jid, "jid");
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            boolean bl = false;
            JitsiMeetConferenceImpl jitsiMeetConferenceImpl = this.conferences.get(jid);
            return jitsiMeetConferenceImpl;
        }
    }

    @Override
    @NotNull
    public List<JitsiMeetConference> getAllConferences() {
        return this.getConferences();
    }

    @NotNull
    public final List<JitsiMeetConference> getConferences() {
        return this.conferencesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(@NotNull ConferenceStore.Listener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        List<ConferenceStore.Listener> list = this.listeners;
        synchronized (list) {
            boolean bl = false;
            boolean bl2 = this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(@NotNull ConferenceStore.Listener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        List<ConferenceStore.Listener> list = this.listeners;
        synchronized (list) {
            boolean bl = false;
            boolean bl2 = this.listeners.remove(listener);
        }
    }

    private final void updateMetrics() {
        int n;
        int n2;
        int count$iv;
        int n3;
        Iterable $this$count$iv;
        Object it;
        int numParticipants = 0;
        int largestConferenceSize = 0;
        ConferenceSizeBuckets conferenceSizes = new ConferenceSizeBuckets();
        int endpointPairs = 0;
        Set jibriSessions = new HashSet();
        for (JitsiMeetConference conference : this.getConferences()) {
            if (!conference.includeInStatistics()) continue;
            int confSize = conference.getParticipantCount();
            if (confSize == 0) {
                confSize = 1;
            }
            numParticipants += confSize;
            endpointPairs += confSize * confSize;
            largestConferenceSize = RangesKt.coerceAtLeast(largestConferenceSize, confSize);
            conferenceSizes.addValue(confSize);
            if (conference.getJibriRecorder() != null) {
                boolean bl = false;
                jibriSessions.addAll((Collection)((JibriRecorder)it).getJibriSessions());
            }
            if (conference.getJibriSipGateway() == null) continue;
            boolean bl = false;
            jibriSessions.addAll((Collection)((JibriSipGateway)it).getJibriSessions());
        }
        ConferenceMetrics.largestConference.set(largestConferenceSize);
        ConferenceMetrics.currentParticipants.set(numParticipants);
        ConferenceMetrics.conferenceSizes = conferenceSizes;
        ConferenceMetrics.participantPairs.set(endpointPairs);
        Iterable iterable = jibriSessions;
        LongGaugeMetric longGaugeMetric = JibriStats.liveStreamingActive;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n3 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (JibriSession)element$iv;
                boolean bl = false;
                if (!(((JibriSession)it).getJibriType() == JibriSession.Type.LIVE_STREAMING && ((JibriSession)it).isActive()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n3 = count$iv;
        }
        int n4 = n3;
        longGaugeMetric.set(n4);
        $this$count$iv = jibriSessions;
        longGaugeMetric = JibriStats.recordingActive;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (JibriSession)element$iv;
                boolean bl = false;
                if (!(((JibriSession)it).getJibriType() == JibriSession.Type.RECORDING && ((JibriSession)it).isActive()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        n4 = n2;
        longGaugeMetric.set(n4);
        $this$count$iv = jibriSessions;
        longGaugeMetric = JibriStats.sipActive;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (JibriSession)element$iv;
                boolean bl = false;
                if (!(((JibriSession)it).getJibriType() == JibriSession.Type.SIP_CALL && ((JibriSession)it).isActive()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        n4 = n;
        longGaugeMetric.set(n4);
    }

    @NotNull
    public final JSONObject getStats() {
        JSONObject jSONObject;
        this.updateMetrics();
        JSONObject stats = new JSONObject();
        ((Map)stats).put("total_participants", ConferenceMetrics.participants.get());
        ((Map)stats).put("total_participants_no_multi_stream", ConferenceMetrics.participantsNoMultiStream.get());
        ((Map)stats).put("total_participants_no_source_name", ConferenceMetrics.participantsNoSourceName.get());
        ((Map)stats).put("total_conferences_created", ConferenceMetrics.conferencesCreated.get());
        ((Map)stats).put("conferences", this.conferenceCount.get());
        JSONObject bridgeFailures = new JSONObject();
        ((Map)bridgeFailures).put("participants_moved", ConferenceMetrics.participantsMoved.get());
        ((Map)stats).put("bridge_failures", bridgeFailures);
        JSONObject participantNotifications = new JSONObject();
        ((Map)participantNotifications).put("ice_failed", ConferenceMetrics.participantsIceFailed.get());
        ((Map)participantNotifications).put("request_restart", ConferenceMetrics.participantsRequestedRestart.get());
        ((Map)stats).put("participant_notifications", participantNotifications);
        ((Map)stats).put("largest_conference", ConferenceMetrics.largestConference.get());
        ((Map)stats).put("participants", ConferenceMetrics.currentParticipants.get());
        ((Map)stats).put("conference_sizes", BucketStats.toJson$default(ConferenceMetrics.conferenceSizes, null, 1, null));
        ((Map)stats).put("endpoint_pairs", ConferenceMetrics.participantPairs.get());
        Map map = stats;
        String string = "jibri";
        JSONObject $this$_get_stats__u24lambda_u2d12 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$_get_stats__u24lambda_u2d12.put("total_sip_call_failures", JibriStats.sipFailures.get());
        $this$_get_stats__u24lambda_u2d12.put("total_live_streaming_failures", JibriStats.liveStreamingFailures.get());
        $this$_get_stats__u24lambda_u2d12.put("total_recording_failures", JibriStats.recordingFailures.get());
        $this$_get_stats__u24lambda_u2d12.put("live_streaming_active", JibriStats.liveStreamingActive.get());
        $this$_get_stats__u24lambda_u2d12.put("recording_active", JibriStats.recordingActive.get());
        $this$_get_stats__u24lambda_u2d12.put("sip_call_active", JibriStats.sipActive.get());
        map.put(string, jSONObject);
        ((Map)stats).put("queues", QueueStatistics.Companion.getStatistics());
        return stats;
    }

    @NotNull
    public final OrderedJsonObject getDebugState(boolean full) {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$getDebugState_u24lambda_u2d13 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        for (JitsiMeetConference conference : this.getConferences()) {
            if (full) {
                OrderedJsonObject orderedJsonObject2;
                Map map = $this$getDebugState_u24lambda_u2d13;
                String string = conference.getRoomName().toString();
                Intrinsics.checkNotNullExpressionValue(conference.getDebugState(), "conference.debugState");
                map.put(string, orderedJsonObject2);
                continue;
            }
            ((Map)$this$getDebugState_u24lambda_u2d13).put(conference.getRoomName().toString(), conference.getParticipantCount());
        }
        return orderedJsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pinConference(@NotNull EntityBareJid roomName, @NotNull String jvbVersion, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter(roomName, "roomName");
        Intrinsics.checkNotNullParameter(jvbVersion, "jvbVersion");
        Intrinsics.checkNotNullParameter(duration, "duration");
        PinnedConference pc = new PinnedConference(jvbVersion, duration);
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            boolean bl = false;
            PinnedConference prev = this.pinnedConferences.remove(roomName);
            if (prev != null) {
                this.logger.info("Modifying pin for " + roomName);
            }
            PinnedConference pinnedConference = this.pinnedConferences.put(roomName, pc);
        }
        this.logger.info("Pinning " + roomName + " to version \"" + jvbVersion + "\" for " + duration.toMinutes() + " minute(s).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unpinConference(@NotNull EntityBareJid roomName) {
        Intrinsics.checkNotNullParameter(roomName, "roomName");
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            boolean bl = false;
            PinnedConference prev = this.pinnedConferences.remove(roomName);
            this.logger.info(prev != null ? "Removing pin for " + roomName : "Unpin failed: " + roomName);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void expirePins(Instant curTime) {
        if (this.pinnedConferences.values().removeIf(arg_0 -> FocusManager.expirePins$lambda-16(curTime, arg_0))) {
            this.logger.info("Some pins have expired.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getBridgeVersionForConference(@NotNull EntityBareJid roomName) {
        Intrinsics.checkNotNullParameter(roomName, "roomName");
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            boolean bl = false;
            Instant instant = this.clock.instant();
            Intrinsics.checkNotNullExpressionValue(instant, "clock.instant()");
            this.expirePins(instant);
            PinnedConference pinnedConference = this.pinnedConferences.get(roomName);
            String string = pinnedConference != null ? pinnedConference.getJvbVersion() : null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final JSONObject getPinnedConferencesJson() {
        JSONObject jSONObject;
        JSONObject $this$getPinnedConferencesJson_u24lambda_u2d21 = jSONObject = new JSONObject();
        boolean bl = false;
        JSONArray pins = new JSONArray();
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            boolean bl2 = false;
            Instant instant = this.clock.instant();
            Intrinsics.checkNotNullExpressionValue(instant, "clock.instant()");
            this.expirePins(instant);
            Map<EntityBareJid, PinnedConference> $this$forEach$iv = this.pinnedConferences;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<EntityBareJid, PinnedConference>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void $this$getPinnedConferencesJson_u24lambda_u2d21_u24lambda_u2d20_u24lambda_u2d19_u24lambda_u2d18;
                JSONObject jSONObject2;
                Map.Entry<EntityBareJid, PinnedConference> element$iv;
                Map.Entry<EntityBareJid, PinnedConference> entry = element$iv = iterator2.next();
                boolean bl3 = false;
                EntityBareJid conferenceId = entry.getKey();
                PinnedConference pinnedConference = entry.getValue();
                JSONObject jSONObject3 = jSONObject2 = new JSONObject();
                JSONArray jSONArray = pins;
                boolean bl4 = false;
                ((Map)$this$getPinnedConferencesJson_u24lambda_u2d21_u24lambda_u2d20_u24lambda_u2d19_u24lambda_u2d18).put("conference-id", conferenceId.toString());
                ((Map)$this$getPinnedConferencesJson_u24lambda_u2d21_u24lambda_u2d20_u24lambda_u2d19_u24lambda_u2d18).put("jvb-version", pinnedConference.getJvbVersion());
                ((Map)$this$getPinnedConferencesJson_u24lambda_u2d21_u24lambda_u2d20_u24lambda_u2d19_u24lambda_u2d18).put("expires-at", pinnedConference.getExpiresAt().atZone(ZoneId.systemDefault()).toString());
                jSONArray.add(jSONObject2);
            }
            Unit unit = Unit.INSTANCE;
        }
        ((Map)$this$getPinnedConferencesJson_u24lambda_u2d21).put("pins", pins);
        return jSONObject;
    }

    @Override
    public void registrationChanged(boolean registered) {
        Iterable $this$forEach$iv = this.conferencesCache;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JitsiMeetConference it = (JitsiMeetConference)element$iv;
            boolean bl = false;
            it.registrationChanged(registered);
        }
    }

    @Override
    public void componentsChanged(@NotNull Set<XmppProvider.Component> components) {
        XmppProvider.Listener.DefaultImpls.componentsChanged(this, components);
    }

    @JvmOverloads
    public final boolean conferenceRequest(@NotNull EntityBareJid room, @NotNull Map<String, String> properties2, @NotNull Level loggingLevel) throws Exception {
        Intrinsics.checkNotNullParameter(room, "room");
        Intrinsics.checkNotNullParameter(properties2, "properties");
        Intrinsics.checkNotNullParameter(loggingLevel, "loggingLevel");
        return FocusManager.conferenceRequest$default(this, room, properties2, loggingLevel, false, 8, null);
    }

    @JvmOverloads
    public final boolean conferenceRequest(@NotNull EntityBareJid room, @NotNull Map<String, String> properties2) throws Exception {
        Intrinsics.checkNotNullParameter(room, "room");
        Intrinsics.checkNotNullParameter(properties2, "properties");
        return FocusManager.conferenceRequest$default(this, room, properties2, null, false, 12, null);
    }

    private static final boolean expirePins$lambda-16(Instant $curTime, PinnedConference it) {
        Intrinsics.checkNotNullParameter($curTime, "$curTime");
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getExpiresAt().isBefore($curTime);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/jicofo/FocusManager$FocusExpireThread;", "", "(Lorg/jitsi/jicofo/FocusManager;)V", "enabled", "", "sleepLock", "Ljava/lang/Object;", "timeout", "Ljava/time/Duration;", "timeoutThread", "Ljava/lang/Thread;", "expireLoop", "", "start", "stop", "jicofo"})
    private final class FocusExpireThread {
        @NotNull
        private final Duration timeout = ConferenceConfig.config.getConferenceStartTimeout();
        @Nullable
        private Thread timeoutThread;
        @NotNull
        private final Object sleepLock = new Object();
        private boolean enabled;

        public final void start() {
            if (!(this.timeoutThread == null)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            Thread timeoutThread = new Thread(() -> FocusExpireThread.start$lambda-0(this), "FocusExpireThread");
            this.enabled = true;
            this.timeoutThread = timeoutThread;
            timeoutThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void stop() {
            Thread thread2;
            Thread thread3 = this.timeoutThread;
            if (thread3 == null) {
                return;
            }
            Thread timeoutThread = thread3;
            this.enabled = false;
            Object object = this.sleepLock;
            synchronized (object) {
                boolean bl = false;
                this.sleepLock.notifyAll();
                Unit unit = Unit.INSTANCE;
            }
            FocusExpireThread focusExpireThread = this;
            try {
                FocusExpireThread focusExpireThread2 = focusExpireThread;
                if (Thread.currentThread() != timeoutThread) {
                    timeoutThread.join();
                }
                thread2 = null;
            }
            catch (InterruptedException interruptedException) {
                void e;
                FocusExpireThread focusExpireThread3 = focusExpireThread;
                throw new RuntimeException((Throwable)e);
            }
            focusExpireThread2.timeoutThread = thread2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void expireLoop() {
            while (this.enabled) {
                Object $i$a$-synchronized-FocusManager$FocusExpireThread$expireLoop$22;
                Object object;
                try {
                    Object object2;
                    object = object2 = this.sleepLock;
                    synchronized (object) {
                        boolean $i$a$-synchronized-FocusManager$FocusExpireThread$expireLoop$22 = false;
                        this.sleepLock.wait(5000L);
                        $i$a$-synchronized-FocusManager$FocusExpireThread$expireLoop$22 = Unit.INSTANCE;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.enabled) break;
                try {
                    void $this$forEach$iv;
                    void $this$filterNotTo$iv$iv;
                    ArrayList $i$a$-synchronized-FocusManager$FocusExpireThread$expireLoop$conferenceCopy$22;
                    object = FocusManager.this.conferencesSyncRoot;
                    $i$a$-synchronized-FocusManager$FocusExpireThread$expireLoop$22 = FocusManager.this;
                    Object object3 = object;
                    synchronized (object3) {
                        boolean $i$a$-synchronized-FocusManager$FocusExpireThread$expireLoop$conferenceCopy$22 = false;
                        $i$a$-synchronized-FocusManager$FocusExpireThread$expireLoop$conferenceCopy$22 = new ArrayList(((FocusManager)$i$a$-synchronized-FocusManager$FocusExpireThread$expireLoop$22).conferences.values());
                    }
                    ArrayList conferenceCopy = $i$a$-synchronized-FocusManager$FocusExpireThread$expireLoop$conferenceCopy$22;
                    Iterable $this$filterNot$iv = conferenceCopy;
                    boolean $i$f$filterNot = false;
                    object3 = $this$filterNot$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterNotTo = false;
                    for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                        JitsiMeetConferenceImpl it = (JitsiMeetConferenceImpl)element$iv$iv;
                        boolean bl = false;
                        if (it.hasHadAtLeastOneParticipant()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterNot$iv = (List)destination$iv$iv;
                    FocusManager focusManager = FocusManager.this;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        JitsiMeetConferenceImpl it = (JitsiMeetConferenceImpl)element$iv;
                        boolean bl = false;
                        if (Duration.between(it.getCreationTime(), Instant.now()).compareTo(this.timeout) <= 0) continue;
                        if (it.includeInStatistics()) {
                            focusManager.getLogger().info("Expiring " + it);
                        }
                        it.stop();
                    }
                }
                catch (Exception ex) {
                    FocusManager.this.getLogger().warn("Error while checking for timed out conference", ex);
                }
            }
        }

        private static final void start$lambda-0(FocusExpireThread this$0) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            this$0.expireLoop();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jitsi/jicofo/FocusManager$PinnedConference;", "", "jvbVersion", "", "duration", "Ljava/time/Duration;", "(Lorg/jitsi/jicofo/FocusManager;Ljava/lang/String;Ljava/time/Duration;)V", "expiresAt", "Ljava/time/Instant;", "getExpiresAt", "()Ljava/time/Instant;", "getJvbVersion", "()Ljava/lang/String;", "jicofo"})
    private final class PinnedConference {
        @NotNull
        private final String jvbVersion;
        @NotNull
        private final Instant expiresAt;

        public PinnedConference(@NotNull String jvbVersion, Duration duration) {
            Intrinsics.checkNotNullParameter(jvbVersion, "jvbVersion");
            Intrinsics.checkNotNullParameter(duration, "duration");
            this.jvbVersion = jvbVersion;
            Instant instant = FocusManager.this.clock.instant().plus(duration).truncatedTo(ChronoUnit.SECONDS);
            Intrinsics.checkNotNullExpressionValue(instant, "clock.instant().plus(dur\u2026tedTo(ChronoUnit.SECONDS)");
            this.expiresAt = instant;
        }

        @NotNull
        public final String getJvbVersion() {
            return this.jvbVersion;
        }

        @NotNull
        public final Instant getExpiresAt() {
            return this.expiresAt;
        }
    }
}

