/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.codec.vp8;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.rtp.codec.VideoCodecParser;
import org.jitsi.nlj.rtp.codec.vp8.Vp8Packet;
import org.jitsi.nlj.util.StateChangeLogger;
import org.jitsi.rtp.extensions.ByteArrayBufferKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/nlj/rtp/codec/vp8/Vp8Parser;", "Lorg/jitsi/nlj/rtp/codec/VideoCodecParser;", "sources", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "([Lorg/jitsi/nlj/MediaSourceDesc;Lorg/jitsi/utils/logging2/Logger;)V", "extendedPictureIdState", "Lorg/jitsi/nlj/util/StateChangeLogger;", "logger", "pictureIdState", "tidWithoutTl0PicIdxState", "parse", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "jitsi-media-transform"})
public final class Vp8Parser
extends VideoCodecParser {
    @NotNull
    private final Logger logger;
    @NotNull
    private final StateChangeLogger pictureIdState;
    @NotNull
    private final StateChangeLogger extendedPictureIdState;
    @NotNull
    private final StateChangeLogger tidWithoutTl0PicIdxState;

    public Vp8Parser(@NotNull MediaSourceDesc[] sources, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(sources, "sources");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super(sources);
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.pictureIdState = new StateChangeLogger("missing picture id", this.logger);
        this.extendedPictureIdState = new StateChangeLogger("missing extended picture ID", this.logger);
        this.tidWithoutTl0PicIdxState = new StateChangeLogger("TID with missing TL0PICIDX", this.logger);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void parse(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Vp8Packet vp8Packet = (Vp8Packet)packetInfo.packetAs();
        if (vp8Packet.getHeight() > -1) {
            RtpEncodingDesc rtpEncodingDesc = this.findRtpEncodingDesc(vp8Packet);
            if (rtpEncodingDesc != null) {
                void $this$mapTo$iv$iv;
                RtpEncodingDesc enc = rtpEncodingDesc;
                boolean bl = false;
                RtpLayerDesc[] $this$map$iv = enc.getLayers$jitsi_media_transform();
                boolean $i$f$map = false;
                RtpLayerDesc[] rtpLayerDescArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void layer;
                    void item$iv$iv;
                    void var13_13 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(RtpLayerDesc.copy$default((RtpLayerDesc)layer, 0, 0, 0, vp8Packet.getHeight(), 0.0, null, null, 119, null));
                }
                List newLayers = (List)destination$iv$iv;
                Collection $this$toTypedArray$iv = newLayers;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                RtpLayerDesc[] rtpLayerDescArray2 = thisCollection$iv.toArray(new RtpLayerDesc[0]);
                if (rtpLayerDescArray2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                enc.setLayers$jitsi_media_transform(rtpLayerDescArray2);
            }
        }
        this.pictureIdState.setState(vp8Packet.getHasPictureId(), vp8Packet, new Function0<String>(vp8Packet){
            final /* synthetic */ Vp8Packet $vp8Packet;
            {
                this.$vp8Packet = $vp8Packet;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Packet Data: " + ByteArrayBufferKt.toHex(this.$vp8Packet, 80);
            }
        });
        this.extendedPictureIdState.setState(vp8Packet.getHasExtendedPictureId(), vp8Packet, new Function0<String>(vp8Packet){
            final /* synthetic */ Vp8Packet $vp8Packet;
            {
                this.$vp8Packet = $vp8Packet;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Packet Data: " + ByteArrayBufferKt.toHex(this.$vp8Packet, 80);
            }
        });
        this.tidWithoutTl0PicIdxState.setState(vp8Packet.getHasTL0PICIDX() || !vp8Packet.getHasTemporalLayerIndex(), vp8Packet, new Function0<String>(vp8Packet){
            final /* synthetic */ Vp8Packet $vp8Packet;
            {
                this.$vp8Packet = $vp8Packet;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Packet Data: " + ByteArrayBufferKt.toHex(this.$vp8Packet, 80);
            }
        });
    }
}

