/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.NodeStatsProducer;
import org.jitsi.nlj.util.ArrayCache;
import org.jitsi.nlj.util.RtpPacketCache;
import org.jitsi.rtp.rtp.RtpPacket;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B%\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\"\u0010\u0017\u001a\u000e\u0018\u00010\u0018R\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0007J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001e2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u0007J\b\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0004J\u0006\u0010$\u001a\u00020\u0015J\u001e\u0010%\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u000bRN\u0010\t\u001aB\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r \f* \u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r\u0018\u00010\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jitsi/nlj/util/PacketCache;", "Lorg/jitsi/nlj/transform/NodeStatsProducer;", "packetPredicate", "Lkotlin/Function1;", "Lorg/jitsi/rtp/rtp/RtpPacket;", "", "size", "", "(Lkotlin/jvm/functions/Function1;I)V", "packetCaches", "", "", "kotlin.jvm.PlatformType", "Lorg/jitsi/nlj/util/RtpPacketCache;", "", "getPacketPredicate", "()Lkotlin/jvm/functions/Function1;", "getSize", "()I", "stopped", "expireCaches", "", "now", "get", "Lorg/jitsi/nlj/util/ArrayCache$Container;", "Lorg/jitsi/nlj/util/ArrayCache;", "ssrc", "seqNum", "getCache", "getMany", "", "numBytes", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "insert", "packet", "stop", "updateTimestamp", "timeAdded", "Companion", "jitsi-media-transform"})
public final class PacketCache
implements NodeStatsProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<RtpPacket, Boolean> packetPredicate;
    private final int size;
    private final Map<Long, RtpPacketCache> packetCaches;
    private boolean stopped;
    private static final int MAX_CACHE_LIFETIME_MILLIS = 15000;

    public PacketCache(@NotNull Function1<? super RtpPacket, Boolean> packetPredicate, int size) {
        Intrinsics.checkNotNullParameter(packetPredicate, "packetPredicate");
        this.packetPredicate = packetPredicate;
        this.size = size;
        this.packetCaches = Collections.synchronizedMap(new LinkedHashMap(16, 0.75f, true));
    }

    public /* synthetic */ PacketCache(Function1 function1, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n2 & 2) != 0) {
            n = 500;
        }
        this(function1, n);
    }

    @NotNull
    public final Function1<RtpPacket, Boolean> getPacketPredicate() {
        return this.packetPredicate;
    }

    public final int getSize() {
        return this.size;
    }

    private final RtpPacketCache getCache(long ssrc2) {
        RtpPacketCache rtpPacketCache;
        RtpPacketCache it = rtpPacketCache = this.packetCaches.computeIfAbsent(ssrc2, arg_0 -> PacketCache.getCache$lambda-0(this, arg_0));
        boolean bl = false;
        it.setLastAccess();
        it = rtpPacketCache;
        boolean bl2 = false;
        this.expireCaches(it.getLastAccessMillis());
        RtpPacketCache rtpPacketCache2 = rtpPacketCache;
        Intrinsics.checkNotNullExpressionValue(rtpPacketCache2, "packetCaches.computeIfAb\u2026es(it.lastAccessMillis) }");
        return rtpPacketCache2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void expireCaches(long now) {
        Map<Long, RtpPacketCache> map = this.packetCaches;
        Intrinsics.checkNotNullExpressionValue(map, "packetCaches");
        Map<Long, RtpPacketCache> map2 = map;
        synchronized (map2) {
            RtpPacketCache cache2;
            boolean bl = false;
            Map<Long, RtpPacketCache> map3 = this.packetCaches;
            Intrinsics.checkNotNullExpressionValue(map3, "packetCaches");
            Iterator<Map.Entry<Long, RtpPacketCache>> i = map3.entrySet().iterator();
            while (i.hasNext() && now - (cache2 = i.next().getValue()).getLastAccessMillis() >= (long)MAX_CACHE_LIFETIME_MILLIS) {
                cache2.flush();
                i.remove();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean insert(@NotNull RtpPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        return !this.stopped && this.packetPredicate.invoke(packet) != false && this.getCache(packet.getSsrc()).insert(packet);
    }

    @Nullable
    public final ArrayCache.Container get(long ssrc2, int seqNum2) {
        return this.getCache(ssrc2).get(seqNum2);
    }

    @NotNull
    public final Set<RtpPacket> getMany(long ssrc2, int numBytes) {
        return this.getCache(ssrc2).getMany(numBytes);
    }

    public final void updateTimestamp(long ssrc2, int seqNum2, long timeAdded) {
        this.getCache(ssrc2).updateTimestamp(seqNum2, timeAdded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        this.stopped = true;
        Map<Long, RtpPacketCache> map = this.packetCaches;
        Intrinsics.checkNotNullExpressionValue(map, "packetCaches");
        Map<Long, RtpPacketCache> map2 = map;
        synchronized (map2) {
            boolean bl = false;
            Map<Long, RtpPacketCache> map3 = this.packetCaches;
            Intrinsics.checkNotNullExpressionValue(map3, "packetCaches");
            Map<Long, RtpPacketCache> $this$forEach$iv = map3;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Long, RtpPacketCache>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<Long, RtpPacketCache> element$iv;
                Map.Entry<Long, RtpPacketCache> entry = element$iv = iterator2.next();
                boolean bl2 = false;
                RtpPacketCache cache2 = entry.getValue();
                cache2.flush();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d8 = nodeStatsBlock = new NodeStatsBlock("PacketCache");
        boolean bl = false;
        Map<Long, RtpPacketCache> map = this.packetCaches;
        Intrinsics.checkNotNullExpressionValue(map, "packetCaches");
        Map<Long, RtpPacketCache> map2 = map;
        synchronized (map2) {
            boolean bl2 = false;
            Iterable $this$forEach$iv = this.packetCaches.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtpPacketCache it = (RtpPacketCache)element$iv;
                boolean bl3 = false;
                $this$getNodeStats_u24lambda_u2d8.aggregate(it.getNodeStats());
            }
            Unit unit = Unit.INSTANCE;
        }
        return nodeStatsBlock;
    }

    private static final RtpPacketCache getCache$lambda-0(PacketCache this$0, Long it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return new RtpPacketCache(this$0.size, false, 2, null);
    }

    public PacketCache() {
        this(null, 0, 3, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/nlj/util/PacketCache$Companion;", "", "()V", "MAX_CACHE_LIFETIME_MILLIS", "", "getMAX_CACHE_LIFETIME_MILLIS", "()I", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMAX_CACHE_LIFETIME_MILLIS() {
            return MAX_CACHE_LIFETIME_MILLIS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

