/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.TransportLayerRtcpFbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.LastChunk;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.PacketReport;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.ReceivedPacketReport;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.UnreceivedPacketReport;
import org.jitsi.rtp.rtp.RtpSequenceNumber;
import org.jitsi.rtp.rtp.RtpSequenceNumberKt;
import org.jitsi.rtp.util.FieldParsersKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010(\n\u0002\b\u0003\b\u0007\u0018\u0000 42\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u000245B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u00100\u001a\u00020\u000eJ\b\u00101\u001a\u00020\u0000H\u0016J\u000f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000303H\u0096\u0002R\u0014\u0010\n\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u001c0\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\fR$\u0010\"\u001a\u00020!2\u0006\u0010\r\u001a\u00020!8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R$\u0010'\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010\u0011\"\u0004\b)\u0010\u0013R$\u0010*\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00078B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010\f\"\u0004\b,\u0010-R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001e\u00a8\u00066"}, d2={"Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/RtcpFbTccPacket;", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/TransportLayerRtcpFbPacket;", "", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/PacketReport;", "buffer", "", "offset", "", "length", "([BII)V", "base_seq_no_", "getBase_seq_no_", "()I", "value", "", "base_time_ticks_", "getBase_time_ticks_", "()J", "setBase_time_ticks_", "(J)V", "data", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/RtcpFbTccPacket$TccMemberData;", "getData", "()Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/RtcpFbTccPacket$TccMemberData;", "data$delegate", "Lkotlin/Lazy;", "encoded_chunks_", "", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/Chunk;", "getEncoded_chunks_", "()Ljava/util/List;", "feedbackSeqNum", "getFeedbackSeqNum", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/LastChunk;", "last_chunk_", "getLast_chunk_", "()Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/LastChunk;", "setLast_chunk_", "(Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/LastChunk;)V", "last_timestamp_us_", "getLast_timestamp_us_", "setLast_timestamp_us_", "num_seq_no_", "getNum_seq_no_", "setNum_seq_no_", "(I)V", "packets_", "getPackets_", "GetBaseTimeUs", "clone", "iterator", "", "Companion", "TccMemberData", "rtp"})
@SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"}, justification="This class is a port and use the original names.")
public final class RtcpFbTccPacket
extends TransportLayerRtcpFbPacket
implements Iterable<PacketReport>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy data$delegate;
    private final int feedbackSeqNum;
    public static final int FMT = 15;
    public static final int kDeltaScaleFactor = 250;
    public static final int kMaxReportedPackets = 65535;
    public static final int kChunkSizeBytes = 2;
    public static final int kMaxSizeBytes = 1200;
    public static final int kTransportFeedbackHeaderSizeBytes = 20;
    public static final int kBaseScaleFactor = 64000;
    public static final long kTimeWrapPeriodUs = 0xFA00000000L;
    public static final int BASE_SEQ_NUM_OFFSET = 12;
    public static final int PACKET_STATUS_COUNT_OFFSET = 14;
    public static final int REFERENCE_TIME_OFFSET = 16;
    public static final int FB_PACKET_COUNT_OFFSET = 19;
    public static final int PACKET_CHUNKS_OFFSET = 20;

    public RtcpFbTccPacket(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        super(buffer, offset, length);
        this.data$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)new Function0<TccMemberData>(buffer, offset, length){
            final /* synthetic */ byte[] $buffer;
            final /* synthetic */ int $offset;
            final /* synthetic */ int $length;
            {
                this.$buffer = $buffer;
                this.$offset = $offset;
                this.$length = $length;
                super(0);
            }

            @NotNull
            public final TccMemberData invoke() {
                int delta_size;
                int base_seq_no_ = RtpSequenceNumberKt.toRtpSequenceNumber(RtcpFbTccPacket.Companion.getBaseSeqNum(this.$buffer, this.$offset));
                int status_count = RtcpFbTccPacket.Companion.getPacketStatusCount(this.$buffer, this.$offset);
                List encoded_chunks_ = new ArrayList<E>();
                LastChunk last_chunk_ = new LastChunk();
                int num_seq_no_ = 0;
                long last_timestamp_us_ = 0L;
                List packets_ = new ArrayList<E>();
                long base_time_ticks_ = RtcpFbTccPacket.Companion.getReferenceTimeTicks(this.$buffer, this.$offset);
                List delta_sizes = new ArrayList<E>();
                int index = this.$offset + 20;
                int end_index = this.$offset + this.$length;
                while (delta_sizes.size() < status_count) {
                    if (index + 2 > end_index) {
                        throw new Exception("Buffer overflow while parsing packet.");
                    }
                    int chunk = FieldParsersKt.getShortAsInt(this.$buffer, index);
                    index += 2;
                    encoded_chunks_.add(chunk);
                    last_chunk_.Decode(chunk, status_count - delta_sizes.size());
                    last_chunk_.AppendTo(delta_sizes);
                }
                CollectionsKt.dropLast(encoded_chunks_, 1);
                num_seq_no_ = status_count;
                int seq_no = base_seq_no_;
                int recv_delta_size = 0;
                Iterator<E> iterator2 = delta_sizes.iterator();
                while (iterator2.hasNext()) {
                    delta_size = ((Number)iterator2.next()).intValue();
                    recv_delta_size += delta_size;
                }
                if (end_index >= index + recv_delta_size) {
                    iterator2 = delta_sizes.iterator();
                    while (iterator2.hasNext()) {
                        delta_size = ((Number)iterator2.next()).intValue();
                        if (index + delta_size > end_index) {
                            throw new Exception("Buffer overflow while parsing packet.");
                        }
                        switch (delta_size) {
                            case 0: {
                                packets_.add(new UnreceivedPacketReport(seq_no));
                                break;
                            }
                            case 1: {
                                byte by = this.$buffer[index];
                                packets_.add(new ReceivedPacketReport(seq_no, UnsignedKt.toPositiveShort(by)));
                                last_timestamp_us_ += (long)(by * 250);
                                index += delta_size;
                                break;
                            }
                            case 2: {
                                byte by = FieldParsersKt.getShortAsInt(this.$buffer, index);
                                packets_.add(new ReceivedPacketReport(seq_no, by));
                                last_timestamp_us_ += (long)(by * 250);
                                index += delta_size;
                                break;
                            }
                            case 3: {
                                throw new Exception("Warning: invalid delta size for seq_no " + RtpSequenceNumber.toString-impl(seq_no));
                            }
                        }
                        seq_no = RtpSequenceNumber.plus-MMyMW7M(seq_no, 1);
                    }
                } else {
                    iterator2 = delta_sizes.iterator();
                    while (iterator2.hasNext()) {
                        delta_size = ((Number)iterator2.next()).intValue();
                        if (delta_size == 0) {
                            packets_.add(new UnreceivedPacketReport(seq_no));
                        } else {
                            packets_.add(new ReceivedPacketReport(seq_no, 0));
                        }
                        seq_no = RtpSequenceNumber.plus-MMyMW7M(seq_no, 1);
                    }
                }
                return new TccMemberData(base_seq_no_, base_time_ticks_, encoded_chunks_, last_chunk_, num_seq_no_, last_timestamp_us_, packets_);
            }
        });
        this.feedbackSeqNum = Companion.getFeedbackPacketCount(buffer, offset);
    }

    private final TccMemberData getData() {
        Lazy lazy = this.data$delegate;
        return (TccMemberData)lazy.getValue();
    }

    private final List<Integer> getEncoded_chunks_() {
        return this.getData().getEncoded_chunks_();
    }

    private final LastChunk getLast_chunk_() {
        return this.getData().getLast_chunk_();
    }

    private final void setLast_chunk_(LastChunk value2) {
        this.getData().setLast_chunk_(value2);
    }

    private final int getBase_seq_no_() {
        return this.getData().getBase_seq_no_();
    }

    private final int getNum_seq_no_() {
        return this.getData().getNum_seq_no_();
    }

    private final void setNum_seq_no_(int value2) {
        this.getData().setNum_seq_no_(value2);
    }

    private final List<PacketReport> getPackets_() {
        return this.getData().getPackets_();
    }

    private final long getLast_timestamp_us_() {
        return this.getData().getLast_timestamp_us_();
    }

    private final void setLast_timestamp_us_(long value2) {
        this.getData().setLast_timestamp_us_(value2);
    }

    private final long getBase_time_ticks_() {
        return this.getData().getBase_time_ticks_();
    }

    private final void setBase_time_ticks_(long value2) {
        this.getData().setBase_time_ticks_(value2);
    }

    public final int getFeedbackSeqNum() {
        return this.feedbackSeqNum;
    }

    public final long GetBaseTimeUs() {
        return this.getBase_time_ticks_() * (long)64000;
    }

    @Override
    @NotNull
    public Iterator<PacketReport> iterator() {
        return this.getPackets_().iterator();
    }

    @Override
    @NotNull
    public RtcpFbTccPacket clone() {
        return new RtcpFbTccPacket(this.cloneBuffer(0), 0, this.length);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010$\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\b0\u0007H\u00c6\u0003J\t\u0010%\u001a\u00020\nH\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u00c6\u0003J_\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0012\b\u0002\u0010\u0006\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u00052\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u00c6\u0001J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001J\t\u0010.\u001a\u00020/H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0006\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0013\"\u0004\b\u001d\u0010\u0015R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0011\"\u0004\b\u001f\u0010 R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017\u00a8\u00060"}, d2={"Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/RtcpFbTccPacket$TccMemberData;", "", "base_seq_no_", "", "base_time_ticks_", "", "encoded_chunks_", "", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/Chunk;", "last_chunk_", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/LastChunk;", "num_seq_no_", "last_timestamp_us_", "packets_", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/PacketReport;", "(IJLjava/util/List;Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/LastChunk;IJLjava/util/List;)V", "getBase_seq_no_", "()I", "getBase_time_ticks_", "()J", "setBase_time_ticks_", "(J)V", "getEncoded_chunks_", "()Ljava/util/List;", "getLast_chunk_", "()Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/LastChunk;", "setLast_chunk_", "(Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/LastChunk;)V", "getLast_timestamp_us_", "setLast_timestamp_us_", "getNum_seq_no_", "setNum_seq_no_", "(I)V", "getPackets_", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "", "rtp"})
    private static final class TccMemberData {
        private final int base_seq_no_;
        private long base_time_ticks_;
        @NotNull
        private final List<Integer> encoded_chunks_;
        @NotNull
        private LastChunk last_chunk_;
        private int num_seq_no_;
        private long last_timestamp_us_;
        @NotNull
        private final List<PacketReport> packets_;

        public TccMemberData(int base_seq_no_, long base_time_ticks_, @NotNull List<Integer> encoded_chunks_, @NotNull LastChunk last_chunk_, int num_seq_no_, long last_timestamp_us_, @NotNull List<PacketReport> packets_) {
            Intrinsics.checkNotNullParameter(encoded_chunks_, "encoded_chunks_");
            Intrinsics.checkNotNullParameter(last_chunk_, "last_chunk_");
            Intrinsics.checkNotNullParameter(packets_, "packets_");
            this.base_seq_no_ = base_seq_no_;
            this.base_time_ticks_ = base_time_ticks_;
            this.encoded_chunks_ = encoded_chunks_;
            this.last_chunk_ = last_chunk_;
            this.num_seq_no_ = num_seq_no_;
            this.last_timestamp_us_ = last_timestamp_us_;
            this.packets_ = packets_;
        }

        public final int getBase_seq_no_() {
            return this.base_seq_no_;
        }

        public final long getBase_time_ticks_() {
            return this.base_time_ticks_;
        }

        public final void setBase_time_ticks_(long l) {
            this.base_time_ticks_ = l;
        }

        @NotNull
        public final List<Integer> getEncoded_chunks_() {
            return this.encoded_chunks_;
        }

        @NotNull
        public final LastChunk getLast_chunk_() {
            return this.last_chunk_;
        }

        public final void setLast_chunk_(@NotNull LastChunk lastChunk) {
            Intrinsics.checkNotNullParameter(lastChunk, "<set-?>");
            this.last_chunk_ = lastChunk;
        }

        public final int getNum_seq_no_() {
            return this.num_seq_no_;
        }

        public final void setNum_seq_no_(int n) {
            this.num_seq_no_ = n;
        }

        public final long getLast_timestamp_us_() {
            return this.last_timestamp_us_;
        }

        public final void setLast_timestamp_us_(long l) {
            this.last_timestamp_us_ = l;
        }

        @NotNull
        public final List<PacketReport> getPackets_() {
            return this.packets_;
        }

        public final int component1() {
            return this.base_seq_no_;
        }

        public final long component2() {
            return this.base_time_ticks_;
        }

        @NotNull
        public final List<Integer> component3() {
            return this.encoded_chunks_;
        }

        @NotNull
        public final LastChunk component4() {
            return this.last_chunk_;
        }

        public final int component5() {
            return this.num_seq_no_;
        }

        public final long component6() {
            return this.last_timestamp_us_;
        }

        @NotNull
        public final List<PacketReport> component7() {
            return this.packets_;
        }

        @NotNull
        public final TccMemberData copy(int base_seq_no_, long base_time_ticks_, @NotNull List<Integer> encoded_chunks_, @NotNull LastChunk last_chunk_, int num_seq_no_, long last_timestamp_us_, @NotNull List<PacketReport> packets_) {
            Intrinsics.checkNotNullParameter(encoded_chunks_, "encoded_chunks_");
            Intrinsics.checkNotNullParameter(last_chunk_, "last_chunk_");
            Intrinsics.checkNotNullParameter(packets_, "packets_");
            return new TccMemberData(base_seq_no_, base_time_ticks_, encoded_chunks_, last_chunk_, num_seq_no_, last_timestamp_us_, packets_);
        }

        public static /* synthetic */ TccMemberData copy$default(TccMemberData tccMemberData, int n, long l, List list, LastChunk lastChunk, int n2, long l2, List list2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = tccMemberData.base_seq_no_;
            }
            if ((n3 & 2) != 0) {
                l = tccMemberData.base_time_ticks_;
            }
            if ((n3 & 4) != 0) {
                list = tccMemberData.encoded_chunks_;
            }
            if ((n3 & 8) != 0) {
                lastChunk = tccMemberData.last_chunk_;
            }
            if ((n3 & 0x10) != 0) {
                n2 = tccMemberData.num_seq_no_;
            }
            if ((n3 & 0x20) != 0) {
                l2 = tccMemberData.last_timestamp_us_;
            }
            if ((n3 & 0x40) != 0) {
                list2 = tccMemberData.packets_;
            }
            return tccMemberData.copy(n, l, list, lastChunk, n2, l2, list2);
        }

        @NotNull
        public String toString() {
            return "TccMemberData(base_seq_no_=" + this.base_seq_no_ + ", base_time_ticks_=" + this.base_time_ticks_ + ", encoded_chunks_=" + this.encoded_chunks_ + ", last_chunk_=" + this.last_chunk_ + ", num_seq_no_=" + this.num_seq_no_ + ", last_timestamp_us_=" + this.last_timestamp_us_ + ", packets_=" + this.packets_ + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.base_seq_no_);
            result2 = result2 * 31 + Long.hashCode(this.base_time_ticks_);
            result2 = result2 * 31 + ((Object)this.encoded_chunks_).hashCode();
            result2 = result2 * 31 + this.last_chunk_.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.num_seq_no_);
            result2 = result2 * 31 + Long.hashCode(this.last_timestamp_us_);
            result2 = result2 * 31 + ((Object)this.packets_).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TccMemberData)) {
                return false;
            }
            TccMemberData tccMemberData = (TccMemberData)other;
            if (this.base_seq_no_ != tccMemberData.base_seq_no_) {
                return false;
            }
            if (this.base_time_ticks_ != tccMemberData.base_time_ticks_) {
                return false;
            }
            if (!Intrinsics.areEqual(this.encoded_chunks_, tccMemberData.encoded_chunks_)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.last_chunk_, tccMemberData.last_chunk_)) {
                return false;
            }
            if (this.num_seq_no_ != tccMemberData.num_seq_no_) {
                return false;
            }
            if (this.last_timestamp_us_ != tccMemberData.last_timestamp_us_) {
                return false;
            }
            return Intrinsics.areEqual(this.packets_, tccMemberData.packets_);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004J\u0016\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004J\u0016\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004J\u0016\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004J\u001e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004J\u001e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004J\u001e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/RtcpFbTccPacket$Companion;", "", "()V", "BASE_SEQ_NUM_OFFSET", "", "FB_PACKET_COUNT_OFFSET", "FMT", "PACKET_CHUNKS_OFFSET", "PACKET_STATUS_COUNT_OFFSET", "REFERENCE_TIME_OFFSET", "kBaseScaleFactor", "kChunkSizeBytes", "kDeltaScaleFactor", "kMaxReportedPackets", "kMaxSizeBytes", "kTimeWrapPeriodUs", "", "kTransportFeedbackHeaderSizeBytes", "getBaseSeqNum", "buf", "", "baseOffset", "getFeedbackPacketCount", "getPacketStatusCount", "getReferenceTimeTicks", "setBaseSeqNum", "", "value", "setFeedbackPacketCount", "setPacketStatusCount", "setReferenceTimeTicks", "refTimeTicks", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public final int getBaseSeqNum(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return FieldParsersKt.getShortAsInt(buf, baseOffset + 12);
        }

        public final void setBaseSeqNum(@NotNull byte[] buf, int baseOffset, int value2) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            ByteArrayExtensionsKt.putShort(buf, baseOffset + 12, (short)value2);
        }

        public final int getPacketStatusCount(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return FieldParsersKt.getShortAsInt(buf, baseOffset + 14);
        }

        public final void setPacketStatusCount(@NotNull byte[] buf, int baseOffset, int value2) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            ByteArrayExtensionsKt.putShort(buf, baseOffset + 14, (short)value2);
        }

        public final long getReferenceTimeTicks(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return UnsignedKt.toPositiveLong(FieldParsersKt.get3BytesAsInt(buf, baseOffset + 16));
        }

        public final void setReferenceTimeTicks(@NotNull byte[] buf, int baseOffset, int refTimeTicks) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            ByteArrayExtensionsKt.put3Bytes(buf, baseOffset + 16, refTimeTicks);
        }

        public final int getFeedbackPacketCount(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return FieldParsersKt.getByteAsInt(buf, baseOffset + 19);
        }

        public final void setFeedbackPacketCount(@NotNull byte[] buf, int baseOffset, int value2) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            buf[baseOffset + 19] = (byte)value2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

