/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.rtp.BlockHeader;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/rtp/rtp/RedundancyBlockHeader;", "Lorg/jitsi/rtp/rtp/BlockHeader;", "pt", "", "timestampOffset", "", "length", "(BII)V", "headerLength", "getHeaderLength", "()I", "getLength", "getTimestampOffset", "write", "buffer", "", "offset", "Companion", "rtp"})
public final class RedundancyBlockHeader
extends BlockHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int timestampOffset;
    private final int length;
    private final int headerLength;
    public static final int MAX_TIMESTAMP_OFFSET = 16383;

    public RedundancyBlockHeader(byte pt, int timestampOffset, int length) {
        super(pt, null);
        this.timestampOffset = timestampOffset;
        this.length = length;
        if (!(this.timestampOffset <= 16383)) {
            boolean bl = false;
            String string = "Invalid timestampOffset: " + this.timestampOffset;
            throw new IllegalArgumentException(string.toString());
        }
        this.headerLength = 4;
    }

    public final int getTimestampOffset() {
        return this.timestampOffset;
    }

    public final int getLength() {
        return this.length;
    }

    @Override
    public int getHeaderLength() {
        return this.headerLength;
    }

    @Override
    public int write(@NotNull byte[] buffer, int offset) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        buffer[offset] = (byte)(this.getPt() | 0xFFFFFF80);
        buffer[offset + 1] = (byte)(this.timestampOffset >> 6);
        buffer[offset + 2] = (byte)((byte)((this.timestampOffset & 0x3F) << 2) | (byte)((byte)(this.length >> 8) & 3));
        buffer[offset + 3] = (byte)(this.length & 0xFF);
        return 4;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/rtp/rtp/RedundancyBlockHeader$Companion;", "", "()V", "MAX_TIMESTAMP_OFFSET", "", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

