/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.allocation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.videobridge.cc.allocation.AllocationSettings;
import org.jitsi.videobridge.cc.allocation.VideoConstraints;
import org.jitsi.videobridge.cc.config.BitrateControllerConfig;
import org.jitsi.videobridge.message.ReceiverVideoConstraintsMessage;
import org.jitsi.videobridge.util.MultiStreamCompatibilityKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\u0006H\u0002J\u0006\u0010\u001b\u001a\u00020\u0006J\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0016\u0010\u0013R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jitsi/videobridge/cc/allocation/AllocationSettingsWrapper;", "", "useSourceNames", "", "(Z)V", "allocationSettings", "Lorg/jitsi/videobridge/cc/allocation/AllocationSettings;", "defaultConstraints", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "lastN", "", "getLastN$jitsi_videobridge", "()I", "setLastN$jitsi_videobridge", "(I)V", "onStageEndpoints", "", "", "getOnStageEndpoints$annotations", "()V", "onStageSources", "selectedEndpoints", "getSelectedEndpoints$annotations", "selectedSources", "videoConstraints", "", "create", "get", "setBandwidthAllocationSettings", "message", "Lorg/jitsi/videobridge/message/ReceiverVideoConstraintsMessage;", "setLastN", "jitsi-videobridge"})
public final class AllocationSettingsWrapper {
    private final boolean useSourceNames;
    @NotNull
    private List<String> selectedEndpoints;
    @NotNull
    private List<String> selectedSources;
    private int lastN;
    @NotNull
    private Map<String, VideoConstraints> videoConstraints;
    @NotNull
    private VideoConstraints defaultConstraints;
    @NotNull
    private List<String> onStageEndpoints;
    @NotNull
    private List<String> onStageSources;
    @NotNull
    private AllocationSettings allocationSettings;

    public AllocationSettingsWrapper(boolean useSourceNames) {
        this.useSourceNames = useSourceNames;
        this.selectedEndpoints = CollectionsKt.emptyList();
        this.selectedSources = CollectionsKt.emptyList();
        this.lastN = -1;
        this.videoConstraints = MapsKt.emptyMap();
        this.defaultConstraints = new VideoConstraints(BitrateControllerConfig.config.thumbnailMaxHeightPx(), 0.0, 2, null);
        this.onStageEndpoints = CollectionsKt.emptyList();
        this.onStageSources = CollectionsKt.emptyList();
        this.allocationSettings = this.create();
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="selectedSources", imports={}), level=DeprecationLevel.WARNING)
    private static /* synthetic */ void getSelectedEndpoints$annotations() {
    }

    public final int getLastN$jitsi_videobridge() {
        return this.lastN;
    }

    public final void setLastN$jitsi_videobridge(int n) {
        this.lastN = n;
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="onStageSources", imports={}), level=DeprecationLevel.WARNING)
    private static /* synthetic */ void getOnStageEndpoints$annotations() {
    }

    private final AllocationSettings create() {
        List<String> list = this.onStageSources;
        List<String> list2 = this.selectedSources;
        Map<String, VideoConstraints> map = this.videoConstraints;
        VideoConstraints videoConstraints = this.defaultConstraints;
        int n = this.lastN;
        return new AllocationSettings(null, null, list, list2, map, n, videoConstraints, 3, null);
    }

    @NotNull
    public final AllocationSettings get() {
        return this.allocationSettings;
    }

    public final boolean setBandwidthAllocationSettings(@NotNull ReceiverVideoConstraintsMessage message) {
        Intrinsics.checkNotNullParameter(message, "message");
        boolean changed = false;
        Integer n = message.getLastN();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            if (this.lastN != it) {
                this.lastN = it;
                changed = true;
            }
        }
        if (this.useSourceNames) {
            List<String> list = message.getSelectedSources();
            if (list != null) {
                List<String> it = list;
                boolean bl = false;
                if (!Intrinsics.areEqual(this.selectedSources, it)) {
                    this.selectedSources = it;
                    changed = true;
                }
            }
            List<String> list2 = message.getOnStageSources();
            if (list2 != null) {
                List<String> it = list2;
                boolean bl = false;
                if (!Intrinsics.areEqual(this.onStageSources, it)) {
                    this.onStageSources = it;
                    changed = true;
                }
            }
        } else {
            String endpoint;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            boolean $i$f$map;
            Iterable $this$map$iv;
            List<String> list = message.getSelectedEndpoints();
            if (list != null) {
                List<String> it = list;
                boolean bl = false;
                $this$map$iv = it;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(MultiStreamCompatibilityKt.endpointIdToSourceName(endpoint));
                }
                List newSelectedSources = (List)destination$iv$iv;
                if (!Intrinsics.areEqual(this.selectedSources, newSelectedSources)) {
                    this.selectedSources = newSelectedSources;
                    changed = true;
                }
            }
            List<String> list3 = message.getOnStageEndpoints();
            if (list3 != null) {
                List<String> it = list3;
                boolean bl = false;
                $this$map$iv = it;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    endpoint = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(MultiStreamCompatibilityKt.endpointIdToSourceName(endpoint));
                }
                List newOnStageSources = (List)destination$iv$iv;
                if (!Intrinsics.areEqual(this.onStageSources, newOnStageSources)) {
                    this.onStageSources = newOnStageSources;
                    changed = true;
                }
            }
        }
        VideoConstraints videoConstraints = message.getDefaultConstraints();
        if (videoConstraints != null) {
            VideoConstraints it = videoConstraints;
            boolean bl = false;
            if (!Intrinsics.areEqual(this.defaultConstraints, it)) {
                this.defaultConstraints = it;
                changed = true;
            }
        }
        Map<String, VideoConstraints> map = message.getConstraints();
        if (map != null) {
            Map<String, VideoConstraints> it = map;
            boolean bl = false;
            Map<String, VideoConstraints> newConstraints = null;
            newConstraints = it;
            if (!this.useSourceNames) {
                newConstraints = new HashMap<String, VideoConstraints>(it.size());
                Iterable $this$forEach$iv = it.entrySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl4 = false;
                    newConstraints.put(MultiStreamCompatibilityKt.endpointIdToSourceName((String)entry.getKey()), (VideoConstraints)entry.getValue());
                }
            }
            if (!Intrinsics.areEqual(this.videoConstraints, newConstraints)) {
                this.videoConstraints = newConstraints;
                changed = true;
            }
        }
        if (changed) {
            this.allocationSettings = this.create();
        }
        return changed;
    }

    public final boolean setLastN(int lastN) {
        if (this.lastN != lastN) {
            this.lastN = lastN;
            this.allocationSettings = this.create();
            return true;
        }
        return false;
    }
}

