/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.load_management;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.ConfigSource;
import org.jitsi.metaconfig.DeprecationKt;
import org.jitsi.metaconfig.supplier.ConfigSourceSupplier;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.JvbLastN;
import org.jitsi.videobridge.load_management.JvbLoadReducer;
import org.jitsi.videobridge.load_management.LastNReducer;
import org.jitsi.videobridge.load_management.LastNReducer$getMaxForwardedEps$;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010!\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020$H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0016\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000e\u001a\u0004\b\u0017\u0010\u0014R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u000e\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001e\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u000e\u001a\u0004\b\u001f\u0010\u001c\u00a8\u0006+"}, d2={"Lorg/jitsi/videobridge/load_management/LastNReducer;", "Lorg/jitsi/videobridge/load_management/JvbLoadReducer;", "conferencesSupplier", "Ljava/util/function/Supplier;", "", "Lorg/jitsi/videobridge/Conference;", "jvbLastN", "Lorg/jitsi/videobridge/JvbLastN;", "(Ljava/util/function/Supplier;Lorg/jitsi/videobridge/JvbLastN;)V", "impactTime", "Ljava/time/Duration;", "getImpactTime", "()Ljava/time/Duration;", "impactTime$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "maxEnforcedLastN", "", "getMaxEnforcedLastN", "()I", "maxEnforcedLastN$delegate", "minLastN", "getMinLastN", "minLastN$delegate", "recoverScale", "", "getRecoverScale", "()D", "recoverScale$delegate", "reductionScale", "getReductionScale", "reductionScale$delegate", "getMaxForwardedEps", "()Ljava/lang/Integer;", "getStats", "Lorg/jitsi/utils/OrderedJsonObject;", "recover", "", "reduceLoad", "", "toString", "", "jitsi-videobridge"})
public final class LastNReducer
implements JvbLoadReducer {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Supplier<Collection<Conference>> conferencesSupplier;
    @NotNull
    private final JvbLastN jvbLastN;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConfigDelegate reductionScale$delegate;
    @NotNull
    private final ConfigDelegate recoverScale$delegate;
    @NotNull
    private final ConfigDelegate impactTime$delegate;
    @NotNull
    private final ConfigDelegate minLastN$delegate;
    @NotNull
    private final ConfigDelegate maxEnforcedLastN$delegate;

    /*
     * WARNING - void declaration
     */
    public LastNReducer(@NotNull Supplier<Collection<Conference>> conferencesSupplier, @NotNull JvbLastN jvbLastN) {
        void $this$from$iv;
        Intrinsics.checkNotNullParameter(conferencesSupplier, "conferencesSupplier");
        Intrinsics.checkNotNullParameter(jvbLastN, "jvbLastN");
        this.conferencesSupplier = conferencesSupplier;
        this.jvbLastN = jvbLastN;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        String string = "videobridge.load-management.load-reducers.last-n.reduction-scale";
        ConfigSource configSource$iv = JitsiConfig.Companion.getNewConfig();
        boolean $i$f$from = false;
        ConfigSourceSupplier supplier$iv = new ConfigSourceSupplier((String)$this$from$iv, configSource$iv, Reflection.typeOf(Double.TYPE), DeprecationKt.noDeprecation());
        boolean $i$f$config = false;
        this.reductionScale$delegate = new ConfigDelegate(supplier$iv);
        supplier$iv = "videobridge.load-management.load-reducers.last-n.recover-scale";
        configSource$iv = JitsiConfig.Companion.getNewConfig();
        $i$f$from = false;
        supplier$iv = new ConfigSourceSupplier((String)$this$from$iv, configSource$iv, Reflection.typeOf(Double.TYPE), DeprecationKt.noDeprecation());
        $i$f$config = false;
        this.recoverScale$delegate = new ConfigDelegate(supplier$iv);
        supplier$iv = "videobridge.load-management.load-reducers.last-n.impact-time";
        configSource$iv = JitsiConfig.Companion.getNewConfig();
        $i$f$from = false;
        supplier$iv = new ConfigSourceSupplier((String)$this$from$iv, configSource$iv, Reflection.typeOf(Duration.class), DeprecationKt.noDeprecation());
        $i$f$config = false;
        this.impactTime$delegate = new ConfigDelegate(supplier$iv);
        supplier$iv = "videobridge.load-management.load-reducers.last-n.minimum-last-n-value";
        configSource$iv = JitsiConfig.Companion.getNewConfig();
        $i$f$from = false;
        supplier$iv = new ConfigSourceSupplier((String)$this$from$iv, configSource$iv, Reflection.typeOf(Integer.TYPE), DeprecationKt.noDeprecation());
        $i$f$config = false;
        this.minLastN$delegate = new ConfigDelegate(supplier$iv);
        supplier$iv = "videobridge.load-management.load-reducers.last-n.maximum-enforced-last-n-value";
        configSource$iv = JitsiConfig.Companion.getNewConfig();
        $i$f$from = false;
        supplier$iv = new ConfigSourceSupplier((String)$this$from$iv, configSource$iv, Reflection.typeOf(Integer.TYPE), DeprecationKt.noDeprecation());
        $i$f$config = false;
        this.maxEnforcedLastN$delegate = new ConfigDelegate(supplier$iv);
        Logger $this$cinfo$iv = this.logger;
        boolean $i$f$cinfo = false;
        if ($this$cinfo$iv.isInfoEnabled()) {
            Logger logger = $this$cinfo$iv;
            boolean bl = false;
            logger.info(this.toString());
        }
    }

    private final double getReductionScale() {
        return ((Number)this.reductionScale$delegate.getValue(this, $$delegatedProperties[0])).doubleValue();
    }

    private final double getRecoverScale() {
        return ((Number)this.recoverScale$delegate.getValue(this, $$delegatedProperties[1])).doubleValue();
    }

    private final Duration getImpactTime() {
        return (Duration)this.impactTime$delegate.getValue(this, $$delegatedProperties[2]);
    }

    private final int getMinLastN() {
        return ((Number)this.minLastN$delegate.getValue(this, $$delegatedProperties[3])).intValue();
    }

    private final int getMaxEnforcedLastN() {
        return ((Number)this.maxEnforcedLastN$delegate.getValue(this, $$delegatedProperties[4])).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private final Integer getMaxForwardedEps() {
        void $this$flatMapTo$iv$iv;
        Collection<Conference> collection = this.conferencesSupplier.get();
        Intrinsics.checkNotNullExpressionValue(collection, "conferencesSupplier.get()");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Conference it = (Conference)element$iv$iv;
            boolean bl = false;
            List<AbstractEndpoint> list = it.getEndpoints();
            Intrinsics.checkNotNullExpressionValue(list, "it.endpoints");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((List)destination$iv$iv);
        boolean $i$f$filterIsInstance = false;
        return (Integer)SequencesKt.maxOrNull(SequencesKt.map(SequencesKt.filter($this$filterIsInstance$iv, getMaxForwardedEps$$inlined$filterIsInstance$1.INSTANCE), getMaxForwardedEps.2.INSTANCE));
    }

    @Override
    public void reduceLoad() {
        Integer n = this.getMaxForwardedEps();
        if (n == null) {
            LastNReducer $this$reduceLoad_u24lambda_u2d2 = this;
            boolean bl = false;
            $this$reduceLoad_u24lambda_u2d2.logger.info("No endpoints with video being forwarded, can't reduce load by reducing last n");
            return;
        }
        int maxForwardedEps = n;
        int newLastN = Integer.max(this.getMinLastN(), (int)((double)maxForwardedEps * this.getReductionScale()));
        this.logger.info("Largest number of forwarded videos was " + maxForwardedEps + ", A last-n value of " + newLastN + " is being enforced to reduce bridge load");
        this.jvbLastN.setJvbLastN(newLastN);
    }

    @Override
    public boolean recover() {
        int currLastN = this.jvbLastN.getJvbLastN();
        if (currLastN == -1) {
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug("No recovery necessary, no JVB last-n is set");
            }
            return false;
        }
        int newLastN = Math.max(currLastN + 1, (int)((double)currLastN * this.getRecoverScale()));
        if (newLastN >= this.getMaxEnforcedLastN()) {
            this.logger.info("JVB last-n was " + currLastN + ", increasing to " + newLastN + " which is beyond the max enforced valueof " + this.getMaxEnforcedLastN() + ", removing limit completely");
            this.jvbLastN.setJvbLastN(-1);
        } else {
            this.logger.info("JVB last-n was " + currLastN + ", increasing to " + newLastN + " as part of load recovery");
            this.jvbLastN.setJvbLastN(newLastN);
        }
        return true;
    }

    @Override
    @NotNull
    public Duration impactTime() {
        return this.getImpactTime();
    }

    @Override
    @NotNull
    public OrderedJsonObject getStats() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$getStats_u24lambda_u2d4 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        $this$getStats_u24lambda_u2d4.put("jvbLastN", (Object)this.jvbLastN.getJvbLastN());
        return orderedJsonObject;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2d5 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u2d5.append("LastNReducer with");
        $this$toString_u24lambda_u2d5.append(" reductionScale: " + this.getReductionScale());
        $this$toString_u24lambda_u2d5.append(" recoverScale: " + this.getRecoverScale());
        $this$toString_u24lambda_u2d5.append(" impactTime: " + this.getImpactTime());
        $this$toString_u24lambda_u2d5.append(" minLastN: " + this.getMinLastN());
        $this$toString_u24lambda_u2d5.append(" maxEnforcedLastN: " + this.getMaxEnforcedLastN());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(LastNReducer.class, "reductionScale", "getReductionScale()D", 0)), Reflection.property1(new PropertyReference1Impl(LastNReducer.class, "recoverScale", "getRecoverScale()D", 0)), Reflection.property1(new PropertyReference1Impl(LastNReducer.class, "impactTime", "getImpactTime()Ljava/time/Duration;", 0)), Reflection.property1(new PropertyReference1Impl(LastNReducer.class, "minLastN", "getMinLastN()I", 0)), Reflection.property1(new PropertyReference1Impl(LastNReducer.class, "maxEnforcedLastN", "getMaxEnforcedLastN()I", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

