/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.processors;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.helpers.queues.Queues;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.operators.multi.processors.SerializedProcessor;
import io.smallrye.mutiny.subscription.BackPressureFailure;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class UnicastProcessor<T>
extends AbstractMulti<T>
implements Flow.Processor<T, T>,
Flow.Subscription {
    private final Runnable onTermination;
    private final Queue<T> queue;
    private volatile boolean done = false;
    private volatile Throwable failure = null;
    private volatile boolean cancelled = false;
    private volatile Flow.Subscriber<? super T> downstream = null;
    private static final AtomicReferenceFieldUpdater<UnicastProcessor, Flow.Subscriber> DOWNSTREAM_UPDATER = AtomicReferenceFieldUpdater.newUpdater(UnicastProcessor.class, Flow.Subscriber.class, "downstream");
    private final AtomicInteger wip = new AtomicInteger();
    private final AtomicLong requested = new AtomicLong();
    private volatile boolean hasUpstream;

    public static <I> UnicastProcessor<I> create() {
        return new UnicastProcessor(Queues.unbounded(Queues.BUFFER_S).get(), null);
    }

    public static <I> UnicastProcessor<I> create(Queue<I> queue, Runnable onTermination) {
        return new UnicastProcessor<I>(queue, onTermination);
    }

    private UnicastProcessor(Queue<T> queue, Runnable onTermination) {
        this.queue = ParameterValidation.nonNull(queue, "queue");
        this.onTermination = onTermination;
    }

    private void onTerminate() {
        if (this.onTermination != null) {
            this.onTermination.run();
        }
    }

    void drainWithDownstream(Flow.Subscriber<? super T> actual) {
        int missed = 1;
        Queue<T> q = this.queue;
        do {
            long e;
            long r = this.requested.get();
            for (e = 0L; r != e; ++e) {
                boolean empty;
                T t = q.poll();
                boolean bl = empty = t == null;
                if (this.isCancelledOrDone(this.done, empty)) {
                    return;
                }
                if (empty) break;
                actual.onNext(t);
            }
            if (r == e && this.isCancelledOrDone(this.done, q.isEmpty())) {
                return;
            }
            if (e == 0L || r == Long.MAX_VALUE) continue;
            this.requested.addAndGet(-e);
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }

    private void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        do {
            Flow.Subscriber<? super T> actual;
            if ((actual = this.downstream) == null) continue;
            this.drainWithDownstream(actual);
            return;
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }

    private boolean isCancelledOrDone(boolean isDone, boolean isEmpty) {
        Flow.Subscriber<T> subscriber = this.downstream;
        if (this.cancelled) {
            this.queue.clear();
            return true;
        }
        if (isDone && isEmpty) {
            Throwable failed = this.failure;
            if (failed != null) {
                subscriber.onError(failed);
            } else {
                subscriber.onComplete();
            }
            return true;
        }
        return false;
    }

    @Override
    public void onSubscribe(Flow.Subscription upstream) {
        if (this.hasUpstream) {
            upstream.cancel();
            return;
        }
        if (this.isDoneOrCancelled()) {
            upstream.cancel();
        } else {
            this.hasUpstream = true;
            upstream.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        ParameterValidation.nonNull(downstream, "downstream");
        if (DOWNSTREAM_UPDATER.compareAndSet(this, null, downstream)) {
            downstream.onSubscribe(this);
            if (!this.cancelled) {
                this.drain();
            }
        } else {
            Subscriptions.fail(downstream, new IllegalStateException("Already subscribed"));
        }
    }

    @Override
    public synchronized void onNext(T t) {
        if (this.isDoneOrCancelled()) {
            return;
        }
        if (!this.queue.offer(t)) {
            BackPressureFailure overflow = new BackPressureFailure("the queue is full");
            this.onError(overflow);
            return;
        }
        this.drain();
    }

    private boolean isDoneOrCancelled() {
        return this.done || this.cancelled;
    }

    @Override
    public void onError(Throwable failure) {
        Objects.requireNonNull(failure);
        if (this.isDoneOrCancelled()) {
            return;
        }
        this.onTerminate();
        this.failure = failure;
        this.done = true;
        this.drain();
    }

    @Override
    public void onComplete() {
        if (this.isDoneOrCancelled()) {
            return;
        }
        this.onTerminate();
        this.done = true;
        this.drain();
    }

    @Override
    public void request(long n) {
        if (n > 0L) {
            Subscriptions.add(this.requested, n);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        if (DOWNSTREAM_UPDATER.getAndSet(this, null) != null) {
            this.onTerminate();
            if (this.wip.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }
    }

    public boolean hasSubscriber() {
        return this.downstream != null;
    }

    public SerializedProcessor<T, T> serialized() {
        return new SerializedProcessor(this);
    }
}

