/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security.dh;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BEROutputStream;
import org.snmp4j.security.dh.DHGroups;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;

public class DHParameters
implements Serializable {
    private BigInteger prime;
    private BigInteger generator;
    private int privateValueLength;
    public static final DHParameters DEFAULT = new DHParameters(DHGroups.P1, DHGroups.G, 16);

    public DHParameters(BigInteger prime, BigInteger generator, int privateValueLength) {
        this.prime = prime;
        this.generator = generator;
        this.privateValueLength = privateValueLength;
    }

    public static OctetString encodeBER(BigInteger prime, BigInteger generator, int privateValueLength) {
        int lengthOfPrime = BER.getBigIntegerBERLength(prime);
        int lengthOfGenerator = BER.getBigIntegerBERLength(generator);
        int lengthOfPrivateValueLength = 0;
        if (privateValueLength != 0) {
            lengthOfPrivateValueLength = new Integer32(privateValueLength).getBERLength();
        }
        int sequenceLength = lengthOfGenerator + lengthOfPrime + lengthOfPrivateValueLength;
        int capacity = sequenceLength + BER.getBERLengthOfLength(sequenceLength) + 1;
        ByteBuffer byteBuffer = ByteBuffer.allocate(capacity);
        BEROutputStream outputStream = new BEROutputStream(byteBuffer);
        try {
            BER.encodeSequence(outputStream, (byte)16, sequenceLength);
            BER.encodeBigInteger(outputStream, (byte)2, prime);
            BER.encodeBigInteger(outputStream, (byte)2, generator);
            if (privateValueLength != 0) {
                BER.encodeInteger(outputStream, (byte)2, privateValueLength);
            }
        }
        catch (IOException e) {
            return null;
        }
        return new OctetString(outputStream.getBuffer().array());
    }

    public static DHParameters getDHParametersFromBER(OctetString berValue) throws IOException {
        BERInputStream inputStream = new BERInputStream(ByteBuffer.wrap(berValue.getValue()));
        BER.MutableByte sequenceType = new BER.MutableByte();
        int sequenceLength = BER.decodeHeader(inputStream, sequenceType);
        long headerOffset = inputStream.getPosition();
        BER.MutableByte integerType = new BER.MutableByte();
        BigInteger prime = BER.decodeBigInteger(inputStream, integerType);
        BigInteger generator = BER.decodeBigInteger(inputStream, integerType);
        int privateValueLength = 0;
        if (inputStream.available() > 0 && inputStream.getPosition() < (long)sequenceLength + headerOffset) {
            privateValueLength = BER.decodeInteger(inputStream, integerType);
        }
        return new DHParameters(prime, generator, privateValueLength);
    }

    public BigInteger getPrime() {
        return this.prime;
    }

    public BigInteger getGenerator() {
        return this.generator;
    }

    public int getPrivateValueLength() {
        return this.privateValueLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DHParameters that = (DHParameters)o;
        if (this.getPrivateValueLength() != that.getPrivateValueLength()) {
            return false;
        }
        if (!this.getPrime().equals(that.getPrime())) {
            return false;
        }
        return this.getGenerator().equals(that.getGenerator());
    }

    public int hashCode() {
        int result = this.getPrime().hashCode();
        result = 31 * result + this.getGenerator().hashCode();
        result = 31 * result + this.getPrivateValueLength();
        return result;
    }

    public String toString() {
        return "DHParameters{prime=" + this.prime + ", generator=" + this.generator + ", privateValueLength=" + this.privateValueLength + '}';
    }
}

