/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.puma;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOBuffer
extends RubyObject {
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new IOBuffer(ruby, rubyClass);
        }
    };
    private static final int DEFAULT_SIZE = 4096;
    final ByteList buffer = new ByteList(4096);

    public static void createIOBuffer(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Puma");
        RubyClass rubyClass = rubyModule.defineClassUnder("IOBuffer", ruby.getObject(), ALLOCATOR);
        rubyClass.defineAnnotatedMethods(IOBuffer.class);
    }

    IOBuffer(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod
    public RubyInteger used(ThreadContext threadContext) {
        return threadContext.runtime.newFixnum(this.buffer.getRealSize());
    }

    @JRubyMethod
    public RubyInteger capacity(ThreadContext threadContext) {
        return threadContext.runtime.newFixnum(this.buffer.unsafeBytes().length);
    }

    @JRubyMethod
    public IRubyObject reset() {
        this.buffer.setRealSize(0);
        return this;
    }

    @JRubyMethod(name={"to_s", "to_str"})
    public RubyString to_s(ThreadContext threadContext) {
        return RubyString.newStringShared((Ruby)threadContext.runtime, (byte[])this.buffer.unsafeBytes(), (int)0, (int)this.buffer.getRealSize());
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject add(IRubyObject iRubyObject) {
        this.addImpl(iRubyObject.convertToString());
        return this;
    }

    @JRubyMethod(rest=true)
    public IRubyObject append(IRubyObject[] iRubyObjectArray) {
        for (IRubyObject iRubyObject : iRubyObjectArray) {
            this.addImpl(iRubyObject.convertToString());
        }
        return this;
    }

    private void addImpl(RubyString rubyString) {
        this.buffer.append(rubyString.getByteList());
    }
}

