/*
 * Decompiled with CFR 0.152.
 */
package com.jrjackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.jrjackson.ParseError;
import com.jrjackson.RubyUtils;
import com.jrjackson.StreamParse;
import java.io.IOException;
import java.util.HashMap;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class SchParse
extends StreamParse {
    protected final DynamicMethod _hash_key;
    protected final boolean _no_hash_key;
    protected final DynamicMethod _hash_set;
    protected final boolean _no_hash_set;
    protected final DynamicMethod _array_append;
    protected final boolean _no_array_append;
    protected final HashMap<JsonStreamContext, IRubyObject> _objectMap = new HashMap();
    protected JsonStreamContext _deepestContext;

    public SchParse(ThreadContext ctx, IRubyObject handler) throws RaiseException {
        super(ctx, handler);
        this._hash_key = this._meta.searchMethod("hash_key");
        this._no_hash_key = this._hash_key.isUndefined();
        this._hash_set = this._meta.searchMethod("hash_set");
        this._no_hash_set = this._hash_set.isUndefined();
        this._array_append = this._meta.searchMethod("array_append");
        this._no_array_append = this._array_append.isUndefined();
        if (this._no_hash_start || this._no_hash_end || this._no_array_start || this._no_array_end || this._no_add_value || this._no_hash_set || this._no_array_append) {
            throw ParseError.newParseError(this._ruby, "Handler does not implement public API");
        }
    }

    @Override
    public IRubyObject deserialize(JsonParser jp) throws RaiseException {
        try {
            while (jp.nextValue() != null) {
                this.handleCurrentToken(jp);
            }
            return this._ctx.nil;
        }
        catch (JsonProcessingException e) {
            throw ParseError.newParseError(this._ruby, e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw this._ruby.newIOError(e.getLocalizedMessage());
        }
    }

    private void callAddValue(JsonStreamContext x) {
        JsonStreamContext px = x.getParent();
        IRubyObject target = this._objectMap.get(x);
        IRubyObject dtarget = this._objectMap.get(this._deepestContext);
        if (px == null) {
            this._add_value.call(this._ctx, this._handler, (RubyModule)this._meta, "add_value", dtarget);
            return;
        }
        if (x.inArray()) {
            this._array_append.call(this._ctx, this._handler, (RubyModule)this._meta, "array_append", target, dtarget);
        } else if (x.inObject()) {
            IRubyObject treatedKey = this.callHashKey(x);
            this._hash_set.call(this._ctx, this._handler, (RubyModule)this._meta, "hash_set", target, treatedKey, dtarget);
        } else {
            this._add_value.call(this._ctx, this._handler, (RubyModule)this._meta, "add_value", target);
        }
    }

    private void callAddValue(JsonStreamContext x, IRubyObject val) {
        IRubyObject target = this._objectMap.get(x);
        if (x.inArray()) {
            this._array_append.call(this._ctx, this._handler, (RubyModule)this._meta, "array_append", target, val);
        } else if (x.inObject()) {
            IRubyObject treatedKey = this.callHashKey(x);
            this._hash_set.call(this._ctx, this._handler, (RubyModule)this._meta, "hash_set", target, treatedKey, val);
        } else {
            this._add_value.call(this._ctx, this._handler, (RubyModule)this._meta, "add_value", val);
        }
    }

    private IRubyObject callHashKey(JsonStreamContext x) {
        String k = x.getCurrentName();
        if (k == null) {
            return this._ctx.nil;
        }
        RubyString key = RubyUtils.rubyString(this._ruby, k);
        if (this._no_hash_key) {
            return key;
        }
        return this._hash_key.call(this._ctx, this._handler, (RubyModule)this._meta, "hash_key", (IRubyObject)key);
    }

    private void handleCurrentToken(JsonParser jp) throws IOException, JsonProcessingException {
        JsonStreamContext cx = jp.getParsingContext();
        switch (jp.getCurrentToken()) {
            case START_OBJECT: {
                this._deepestContext = cx;
                IRubyObject rubyObject = this._hash_start.call(this._ctx, this._handler, (RubyModule)this._meta, "hash_start");
                this._objectMap.put(cx, rubyObject);
                break;
            }
            case START_ARRAY: {
                this._deepestContext = cx;
                IRubyObject rubyObject = this._array_start.call(this._ctx, this._handler, (RubyModule)this._meta, "array_start");
                this._objectMap.put(cx, rubyObject);
                break;
            }
            case FIELD_NAME: {
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                RubyObject value = RubyUtils.rubyObject(this._ruby, jp.getEmbeddedObject());
                this.callAddValue(cx, (IRubyObject)value);
                break;
            }
            case VALUE_STRING: {
                RubyObject value = this.keyConverter.convert(this._ruby, jp);
                this.callAddValue(cx, (IRubyObject)value);
                break;
            }
            case VALUE_NUMBER_INT: {
                JsonParser.NumberType numberType = jp.getNumberType();
                RubyBignum value = RubyUtils.rubyBignum(this._ruby, jp.getBigIntegerValue());
                this.callAddValue(cx, (IRubyObject)value);
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                RubyBigDecimal value = RubyUtils.rubyBigDecimal(this._ruby, jp.getDecimalValue());
                this.callAddValue(cx, (IRubyObject)value);
                break;
            }
            case VALUE_TRUE: {
                RubyBoolean value = this._ruby.newBoolean(Boolean.TRUE.booleanValue());
                this.callAddValue(cx, (IRubyObject)value);
                break;
            }
            case VALUE_FALSE: {
                RubyBoolean value = this._ruby.newBoolean(Boolean.FALSE.booleanValue());
                this.callAddValue(cx, (IRubyObject)value);
                break;
            }
            case VALUE_NULL: {
                IRubyObject value = this._ctx.nil;
                this.callAddValue(cx, value);
                break;
            }
            case END_ARRAY: {
                this._array_end.call(this._ctx, this._handler, (RubyModule)this._meta, "array_end");
                this.callAddValue(cx);
                this._deepestContext = cx;
                break;
            }
            case END_OBJECT: {
                this._hash_end.call(this._ctx, this._handler, (RubyModule)this._meta, "hash_end");
                this.callAddValue(cx);
                this._deepestContext = cx;
            }
        }
    }
}

