/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ingest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.logstash.ingest.IngestConverter;

public class IngestAppend {
    public static String toLogstash(String json, boolean appendStdio) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        HashMap<String, Object> jsonDefinition = mapper.readValue(json, typeRef);
        List processors = (List)jsonDefinition.get("processors");
        List<String> filters_pipeline = processors.stream().map(IngestAppend::mapProcessor).collect(Collectors.toList());
        return IngestConverter.filtersToFile(IngestConverter.appendIoPlugins(filters_pipeline, appendStdio));
    }

    private static String mapProcessor(Map processor) {
        return IngestConverter.filterHash(IngestConverter.createHash("mutate", IngestAppend.appendHash(processor)));
    }

    static String appendHash(Map<String, Map> processor) {
        Map append_json = processor.get("append");
        Object value = append_json.get("value");
        String value_contents = value instanceof List ? IngestConverter.createArray((List)value) : IngestConverter.quoteString((String)value);
        String mutate_contents = IngestConverter.createField(IngestConverter.quoteString(IngestConverter.dotsToSquareBrackets((String)append_json.get("field"))), value_contents);
        return IngestConverter.createField("add_field", IngestConverter.wrapInCurly(mutate_contents));
    }

    public static boolean has_append(Map<String, Object> processor) {
        return processor.containsKey("append");
    }
}

