/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import io.netty.channel.ChannelHandler;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.Map;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.model.Event;
import org.traccar.model.Position;

@Singleton
@ChannelHandler.Sharable
public class CommandResultEventHandler
extends BaseEventHandler {
    @Inject
    public CommandResultEventHandler() {
    }

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        Object commandResult = position.getAttributes().get("result");
        if (commandResult != null) {
            Event event = new Event("commandResult", position);
            event.set("result", (String)commandResult);
            return Collections.singletonMap(event, position);
        }
        return null;
    }
}

