/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration.tracker;

import io.quarkus.deployment.configuration.BuildTimeConfigurationReader;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingConfig;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingValueTransformer;
import io.quarkus.runtime.LaunchMode;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.SecretKeys;
import jakarta.annotation.Priority;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigValue;

@Priority(value=5000)
public class ConfigTrackingInterceptor
implements ConfigSourceInterceptor {
    private boolean enabled;
    private Map<String, String> readOptions = Map.of();
    private final ReadOptionsProvider readOptionsProvider = new ReadOptionsProvider(){

        @Override
        public Map<String, String> getReadOptions() {
            return Collections.unmodifiableMap(ConfigTrackingInterceptor.this.readOptions);
        }
    };

    public void configure(Config config) {
        this.enabled = (Boolean)config.getValue("quarkus.config-tracking.enabled", Boolean.TYPE);
        if (this.enabled) {
            this.readOptions = new ConcurrentHashMap<String, String>();
        }
    }

    public io.smallrye.config.ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        if (!this.enabled) {
            return context.proceed(name);
        }
        io.smallrye.config.ConfigValue configValue = (io.smallrye.config.ConfigValue)SecretKeys.doLocked(() -> context.proceed(name));
        this.readOptions.put(name, ConfigTrackingValueTransformer.asString((ConfigValue)configValue));
        return configValue;
    }

    public ReadOptionsProvider getReadOptionsProvider() {
        return this.readOptionsProvider;
    }

    public static interface ReadOptionsProvider {
        public Map<String, String> getReadOptions();
    }

    public static interface ConfigurationWriter {
        public void write(ConfigTrackingConfig var1, BuildTimeConfigurationReader.ReadResult var2, LaunchMode var3, Path var4);
    }
}

