/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.util;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyAffinityServiceFactory;
import org.infinispan.affinity.KeyGenerator;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.sessions.StickySessionEncoderProvider;

public class InfinispanKeyGenerator {
    private static final Logger log = Logger.getLogger(InfinispanKeyGenerator.class);
    private final Map<String, KeyAffinityService> keyAffinityServices = new ConcurrentHashMap<String, KeyAffinityService>();

    public String generateKeyString(KeycloakSession session, Cache<String, ?> cache) {
        return this.generateKey(session, cache, new StringKeyGenerator());
    }

    public UUID generateKeyUUID(KeycloakSession session, Cache<UUID, ?> cache) {
        return this.generateKey(session, cache, new UUIDKeyGenerator());
    }

    private <K> K generateKey(KeycloakSession session, Cache<K, ?> cache, KeyGenerator<K> keyGenerator) {
        boolean wantsLocalKey;
        String cacheName = cache.getName();
        boolean bl = wantsLocalKey = !((StickySessionEncoderProvider)session.getProvider(StickySessionEncoderProvider.class)).shouldAttachRoute();
        if (wantsLocalKey && cache.getCacheConfiguration().clustering().cacheMode().isClustered()) {
            KeyAffinityService keyAffinityService = this.keyAffinityServices.computeIfAbsent(cacheName, s -> {
                KeyAffinityService k = this.createKeyAffinityService(cache, keyGenerator);
                log.debugf("Registered key affinity service for cache '%s'", (Object)cacheName);
                return k;
            });
            return (K)keyAffinityService.getKeyForAddress(cache.getCacheManager().getAddress());
        }
        return (K)keyGenerator.getKey();
    }

    private <K> KeyAffinityService<K> createKeyAffinityService(Cache<K, ?> cache, KeyGenerator<K> keyGenerator) {
        return KeyAffinityServiceFactory.newLocalKeyAffinityService(cache, keyGenerator, (Executor)Executors.newSingleThreadExecutor(), (int)16);
    }

    private static class StringKeyGenerator
    implements KeyGenerator<String> {
        private StringKeyGenerator() {
        }

        public String getKey() {
            return KeycloakModelUtils.generateId();
        }
    }

    private static class UUIDKeyGenerator
    implements KeyGenerator<UUID> {
        private UUIDKeyGenerator() {
        }

        public UUID getKey() {
            return UUID.randomUUID();
        }
    }
}

