/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import org.keycloak.config.Option;
import org.keycloak.config.OptionBuilder;
import org.keycloak.config.OptionCategory;
import org.keycloak.config.database.Database;

public class DatabaseOptions {
    public static final Option<String> DB_DIALECT = new OptionBuilder<String>("db-dialect", String.class).category(OptionCategory.DATABASE).hidden().buildTime(true).build();
    public static final Option<String> DB_DRIVER = new OptionBuilder<String>("db-driver", String.class).category(OptionCategory.DATABASE).description("The fully qualified class name of the JDBC driver. If not set, a default driver is set accordingly to the chosen database.").build();
    public static final Option<String> DB = new OptionBuilder<String>("db", String.class).category(OptionCategory.DATABASE).description("The database vendor.").defaultValue("dev-file").expectedValues(Database::getDatabaseAliases).buildTime(true).build();
    public static final Option<String> DB_URL = new OptionBuilder<String>("db-url", String.class).category(OptionCategory.DATABASE).description("The full database JDBC URL. If not provided, a default URL is set based on the selected database vendor. For instance, if using 'postgres', the default JDBC URL would be 'jdbc:postgresql://localhost/keycloak'. ").build();
    public static final Option<String> DB_URL_HOST = new OptionBuilder<String>("db-url-host", String.class).category(OptionCategory.DATABASE).description("Sets the hostname of the default JDBC URL of the chosen vendor. If the `db-url` option is set, this option is ignored.").build();
    public static final Option<String> DB_URL_DATABASE = new OptionBuilder<String>("db-url-database", String.class).category(OptionCategory.DATABASE).description("Sets the database name of the default JDBC URL of the chosen vendor. If the `db-url` option is set, this option is ignored.").build();
    public static final Option<Integer> DB_URL_PORT = new OptionBuilder<Integer>("db-url-port", Integer.class).category(OptionCategory.DATABASE).description("Sets the port of the default JDBC URL of the chosen vendor. If the `db-url` option is set, this option is ignored.").build();
    public static final Option<String> DB_URL_PROPERTIES = new OptionBuilder<String>("db-url-properties", String.class).category(OptionCategory.DATABASE).description("Sets the properties of the default JDBC URL of the chosen vendor. Make sure to set the properties accordingly to the format expected by the database vendor, as well as appending the right character at the beginning of this property value. If the `db-url` option is set, this option is ignored.").build();
    public static final Option<String> DB_USERNAME = new OptionBuilder<String>("db-username", String.class).category(OptionCategory.DATABASE).description("The username of the database user.").build();
    public static final Option<String> DB_PASSWORD = new OptionBuilder<String>("db-password", String.class).category(OptionCategory.DATABASE).description("The password of the database user.").build();
    public static final Option<String> DB_SCHEMA = new OptionBuilder<String>("db-schema", String.class).category(OptionCategory.DATABASE).description("The database schema to be used.").build();
    public static final Option<Integer> DB_POOL_INITIAL_SIZE = new OptionBuilder<Integer>("db-pool-initial-size", Integer.class).category(OptionCategory.DATABASE).description("The initial size of the connection pool.").build();
    public static final Option<Integer> DB_POOL_MIN_SIZE = new OptionBuilder<Integer>("db-pool-min-size", Integer.class).category(OptionCategory.DATABASE).description("The minimal size of the connection pool.").build();
    public static final Option<Integer> DB_POOL_MAX_SIZE = new OptionBuilder<Integer>("db-pool-max-size", Integer.class).category(OptionCategory.DATABASE).defaultValue(100).description("The maximum size of the connection pool.").build();
}

