/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.navigation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.jakarta.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.jakarta.web.beans.navigation.InjectableTreeNode;
import org.netbeans.modules.jakarta.web.beans.navigation.InjectablesModel;
import org.netbeans.modules.jakarta.web.beans.navigation.JavaHierarchyModel;
import org.netbeans.modules.jakarta.web.beans.navigation.MethodTreeNode;
import org.openide.filesystems.FileObject;

public final class ObserversModel
extends DefaultTreeModel
implements JavaHierarchyModel {
    private static final long serialVersionUID = -7252090049644279891L;
    private static final Logger LOG = Logger.getLogger(ObserversModel.class.getName());
    private MetadataModel<WebBeansModel> myModel;
    private List<ElementHandle<ExecutableElement>> myHandles;

    public ObserversModel(List<ExecutableElement> methods, CompilationController controller, MetadataModel<WebBeansModel> model) {
        super(null);
        this.myModel = model;
        this.myHandles = new ArrayList<ElementHandle<ExecutableElement>>(methods.size());
        for (ExecutableElement method : methods) {
            ElementHandle handle = ElementHandle.create((Element)method);
            this.myHandles.add((ElementHandle<ExecutableElement>)handle);
        }
        this.update(methods, controller);
    }

    @Override
    public void fireTreeNodesChanged() {
        super.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode)this.getRoot()), null, null);
    }

    @Override
    public void update() {
        this.updateHandles(this.myHandles);
    }

    private void updateHandles(final List<ElementHandle<ExecutableElement>> handles) {
        try {
            this.getModel().runReadAction((MetadataModelAction)new MetadataModelAction<WebBeansModel, Void>(){

                public Void run(WebBeansModel model) {
                    ArrayList<ExecutableElement> list = new ArrayList<ExecutableElement>(handles.size());
                    for (ElementHandle handle : handles) {
                        ExecutableElement method = (ExecutableElement)handle.resolve((CompilationInfo)model.getCompilationController());
                        if (method == null) continue;
                        list.add(method);
                    }
                    ObserversModel.this.update(list, model.getCompilationController());
                    return null;
                }
            });
            return;
        }
        catch (MetadataModelException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void update(List<ExecutableElement> methods, CompilationController controller) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        LinkedHashMap<Element, InjectableTreeNode<? extends Element>> methodsMap = new LinkedHashMap<Element, InjectableTreeNode<? extends Element>>();
        for (ExecutableElement method : methods) {
            FileObject fileObject = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)method), (ClasspathInfo)controller.getClasspathInfo());
            MethodTreeNode node = new MethodTreeNode(fileObject, method, (DeclaredType)controller.getElementUtilities().enclosingTypeElement((Element)method).asType(), false, (CompilationInfo)controller);
            this.insertTreeNode(methodsMap, method, node, root, controller);
        }
        this.setRoot(root);
    }

    private void insertTreeNode(Map<Element, InjectableTreeNode<? extends Element>> methods, ExecutableElement method, MethodTreeNode node, DefaultMutableTreeNode root, CompilationController controller) {
        InjectablesModel.insertTreeNode(methods, method, node, root, controller);
    }

    private MetadataModel<WebBeansModel> getModel() {
        return this.myModel;
    }
}

