/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.actions;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.cloud.oracle.actions.AbstractPasswordPanel;
import org.netbeans.modules.cloud.oracle.actions.Bundle;
import org.netbeans.modules.cloud.oracle.actions.DownloadWalletAction;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

final class DownloadWalletDialog
extends AbstractPasswordPanel {
    public static final String WALLETS_PATH = "Databases/Wallets";
    private static final String LAST_USED_DIR = "lastUsedDir";
    private JButton jButtonBrowse;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPasswordField jPasswordField;
    private JPasswordField jPasswordFieldConfirm;
    private JTextArea jTextArea1;
    private JTextField jTextFieldLocation;

    DownloadWalletDialog() {
        this.initComponents();
        AbstractPasswordPanel.PasswordListener docListener = new AbstractPasswordPanel.PasswordListener();
        this.jPasswordField.getDocument().addDocumentListener(docListener);
        this.jPasswordFieldConfirm.getDocument().addDocumentListener(docListener);
    }

    static Optional<WalletInfo> showDialog(OCIItem db) {
        File home = new File(System.getProperty("user.home"));
        String lastUsedDir = NbPreferences.forModule(DownloadWalletAction.class).get(LAST_USED_DIR, home.getAbsolutePath());
        if (!GraphicsEnvironment.isHeadless()) {
            DownloadWalletDialog dlgPanel = new DownloadWalletDialog();
            dlgPanel.jTextFieldLocation.setText(lastUsedDir);
            DialogDescriptor descriptor = new DialogDescriptor((Object)dlgPanel, Bundle.DownloadTitle());
            dlgPanel.setDescriptor(descriptor);
            descriptor.createNotificationLineSupport();
            Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
            dialog.setMinimumSize(dlgPanel.getPreferredSize());
            dialog.setVisible(true);
            if (DialogDescriptor.OK_OPTION == descriptor.getValue()) {
                String path = dlgPanel.jTextFieldLocation.getText();
                char[] passwd = dlgPanel.jPasswordField.getPassword();
                NbPreferences.forModule(DownloadWalletAction.class).put(LAST_USED_DIR, path);
                return Optional.of(new WalletInfo(path, passwd, null, null, db.getKey().getValue()));
            }
        } else {
            try {
                File walletsDir = DownloadWalletDialog.getWalletsDir();
                NotifyDescriptor.InputLine inp = new NotifyDescriptor.InputLine(Bundle.JDBCUsername(), Bundle.JDBCUsername());
                Object selected = DialogDisplayer.getDefault().notify((NotifyDescriptor)inp);
                if (DialogDescriptor.OK_OPTION != selected) {
                    return Optional.empty();
                }
                String username = inp.getInputText().toUpperCase(Locale.US);
                inp = new NotifyDescriptor.PasswordLine(Bundle.JDBCPassword(), Bundle.JDBCPassword());
                selected = DialogDisplayer.getDefault().notify((NotifyDescriptor)inp);
                if (DialogDescriptor.OK_OPTION != selected) {
                    return Optional.empty();
                }
                char[] password = inp.getInputText().toCharArray();
                return Optional.of(new WalletInfo(walletsDir.getAbsolutePath(), DownloadWalletDialog.generatePassword(), username, password, db.getKey().getValue()));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return Optional.empty();
    }

    private void initComponents() {
        this.jTextArea1 = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldLocation = new JTextField();
        this.jPasswordFieldConfirm = new JPasswordField();
        this.jPasswordField = new JPasswordField();
        this.jButtonBrowse = new JButton();
        this.setMaximumSize(null);
        this.setMinimumSize(new Dimension(714, 234));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(1);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText(NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jTextArea1.text"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setBorder(null);
        this.jTextArea1.setDragEnabled(false);
        this.jTextArea1.setFocusTraversalKeysEnabled(false);
        this.jTextArea1.setFocusable(false);
        this.jTextArea1.setMinimumSize(new Dimension(702, 113));
        this.jTextArea1.setOpaque(false);
        this.jTextArea1.setPreferredSize(new Dimension(702, 113));
        this.jTextArea1.setRequestFocusEnabled(false);
        this.jLabel1.setLabelFor(this.jPasswordField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jLabel1.text"));
        this.jLabel2.setLabelFor(this.jPasswordFieldConfirm);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jLabel2.text"));
        this.jLabel3.setLabelFor(this.jTextFieldLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jLabel3.text"));
        this.jTextFieldLocation.setText(NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jTextFieldLocation.text"));
        this.jPasswordFieldConfirm.setText(NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jPasswordFieldConfirm.text"));
        this.jPasswordField.setText(NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jPasswordField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonBrowse, (String)NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jButtonBrowse.text"));
        this.jButtonBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadWalletDialog.this.jButtonBrowseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextArea1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPasswordField).addComponent(this.jTextFieldLocation).addComponent(this.jPasswordFieldConfirm)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonBrowse))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTextArea1, -2, 113, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jPasswordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jPasswordFieldConfirm, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldLocation, -2, -1, -2).addComponent(this.jButtonBrowse)).addContainerGap(16, Short.MAX_VALUE)));
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(Bundle.LBL_SaveWallet());
        File folder = new File(this.jTextFieldLocation.getText());
        if (!folder.exists()) {
            folder = folder.getParentFile();
        }
        chooser.setCurrentDirectory(folder);
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (0 == chooser.showDialog(WindowManager.getDefault().getMainWindow(), Bundle.SelectButton())) {
            this.jTextFieldLocation.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    @Override
    protected void checkPassword() {
        char[] passwd1 = this.jPasswordField.getPassword();
        char[] passwd2 = this.jPasswordFieldConfirm.getPassword();
        DownloadWalletDialog.checkPasswordLogic(passwd1, passwd2, m -> this.errorMessage((String)m));
    }

    static File getWalletsDir() throws IOException {
        FileObject fo = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)WALLETS_PATH);
        return FileUtil.toFile((FileObject)fo);
    }

    static class WalletInfo {
        private String path;
        private char[] walletPassword;
        private String dbUser;
        private char[] dbPassword;
        private String ocid;

        public WalletInfo(String path, char[] walletPassword, String dbUser, char[] dbPassword, String ocid) {
            this.path = path;
            this.walletPassword = walletPassword;
            this.dbUser = dbUser;
            this.dbPassword = dbPassword;
            this.ocid = ocid;
        }

        public String getPath() {
            return this.path;
        }

        public char[] getWalletPassword() {
            return this.walletPassword;
        }

        public String getDbUser() {
            return this.dbUser;
        }

        public char[] getDbPassword() {
            return this.dbPassword;
        }

        public String getOcid() {
            return this.ocid;
        }
    }
}

