/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.CreateDataGuardAssociationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateDataGuardAssociationRequest
extends BmcRequest<CreateDataGuardAssociationDetails> {
    private String databaseId;
    private CreateDataGuardAssociationDetails createDataGuardAssociationDetails;
    private String opcRetryToken;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public CreateDataGuardAssociationDetails getCreateDataGuardAssociationDetails() {
        return this.createDataGuardAssociationDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateDataGuardAssociationDetails getBody$() {
        return this.createDataGuardAssociationDetails;
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).createDataGuardAssociationDetails(this.createDataGuardAssociationDetails).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",createDataGuardAssociationDetails=").append(String.valueOf((Object)this.createDataGuardAssociationDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDataGuardAssociationRequest)) {
            return false;
        }
        CreateDataGuardAssociationRequest other = (CreateDataGuardAssociationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals((Object)this.createDataGuardAssociationDetails, (Object)other.createDataGuardAssociationDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.createDataGuardAssociationDetails == null ? 43 : this.createDataGuardAssociationDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateDataGuardAssociationRequest, CreateDataGuardAssociationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseId = null;
        private CreateDataGuardAssociationDetails createDataGuardAssociationDetails = null;
        private String opcRetryToken = null;

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder createDataGuardAssociationDetails(CreateDataGuardAssociationDetails createDataGuardAssociationDetails) {
            this.createDataGuardAssociationDetails = createDataGuardAssociationDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateDataGuardAssociationRequest o) {
            this.databaseId(o.getDatabaseId());
            this.createDataGuardAssociationDetails(o.getCreateDataGuardAssociationDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateDataGuardAssociationRequest build() {
            CreateDataGuardAssociationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateDataGuardAssociationDetails body) {
            this.createDataGuardAssociationDetails(body);
            return this;
        }

        public CreateDataGuardAssociationRequest buildWithoutInvocationCallback() {
            CreateDataGuardAssociationRequest request = new CreateDataGuardAssociationRequest();
            request.databaseId = this.databaseId;
            request.createDataGuardAssociationDetails = this.createDataGuardAssociationDetails;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

