/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAutonomousPatchRequest
extends BmcRequest<Void> {
    private String autonomousPatchId;

    public String getAutonomousPatchId() {
        return this.autonomousPatchId;
    }

    public Builder toBuilder() {
        return new Builder().autonomousPatchId(this.autonomousPatchId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",autonomousPatchId=").append(String.valueOf(this.autonomousPatchId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAutonomousPatchRequest)) {
            return false;
        }
        GetAutonomousPatchRequest other = (GetAutonomousPatchRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.autonomousPatchId, other.autonomousPatchId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.autonomousPatchId == null ? 43 : this.autonomousPatchId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAutonomousPatchRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String autonomousPatchId = null;

        public Builder autonomousPatchId(String autonomousPatchId) {
            this.autonomousPatchId = autonomousPatchId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAutonomousPatchRequest o) {
            this.autonomousPatchId(o.getAutonomousPatchId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAutonomousPatchRequest build() {
            GetAutonomousPatchRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAutonomousPatchRequest buildWithoutInvocationCallback() {
            GetAutonomousPatchRequest request = new GetAutonomousPatchRequest();
            request.autonomousPatchId = this.autonomousPatchId;
            return request;
        }
    }
}

