/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.java.hints.spi.preview.PreviewEnabler;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class EnablePreview
implements ErrorRule<Void> {
    private static final Set<String> ERROR_CODES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("compiler.err.preview.feature.disabled", "compiler.err.preview.feature.disabled.plural", "compiler.err.is.preview")));

    public Set<String> getCodes() {
        return ERROR_CODES;
    }

    @NonNull
    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        FileObject file = compilationInfo.getFileObject();
        if (file != null) {
            String sourceLevel;
            SpecificationVersion platformVersion = null;
            FileObject jlObject = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT).findResource("java/lang/Object.class");
            for (JavaPlatform platform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
                if (jlObject != platform.getBootstrapLibraries().findResource("java/lang/Object.class")) continue;
                platformVersion = platform.getSpecification().getVersion();
                break;
            }
            if ((sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)compilationInfo.getFileObject())) == null) {
                return Collections.emptyList();
            }
            if (sourceLevel.startsWith("1.")) {
                sourceLevel = sourceLevel.substring(2);
            }
            String newSourceLevel = null;
            if (platformVersion != null && platformVersion.compareTo(new SpecificationVersion(sourceLevel)) > 0) {
                newSourceLevel = platformVersion.toString();
            }
            for (PreviewEnabler.Factory factory : Lookup.getDefault().lookupAll(PreviewEnabler.Factory.class)) {
                PreviewEnabler enabler = factory.enablerFor(file);
                if (enabler == null) continue;
                return Collections.singletonList(new ResolveFix(enabler, newSourceLevel));
            }
        }
        return Collections.emptyList();
    }

    public String getId() {
        return EnablePreview.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(EnablePreview.class, (String)"FIX_EnablePreviewFeature");
    }

    public String getDescription() {
        return NbBundle.getMessage(EnablePreview.class, (String)"FIX_EnablePreviewFeature");
    }

    public void cancel() {
    }

    public static final class ResolveFix
    implements Fix {
        private final PreviewEnabler enabler;
        private final String newSourceLevel;
        private final boolean canChangeSourceLevel;

        public ResolveFix(@NonNull PreviewEnabler enabler, @NonNull String newSourceLevel) {
            Parameters.notNull((CharSequence)"enabler", (Object)enabler);
            this.enabler = enabler;
            this.newSourceLevel = newSourceLevel;
            this.canChangeSourceLevel = newSourceLevel != null ? enabler.canChangeSourceLevel() : true;
        }

        public String getText() {
            if (this.newSourceLevel != null) {
                if (this.canChangeSourceLevel) {
                    return NbBundle.getMessage(EnablePreview.class, (String)"FIX_EnablePreviewFeatureSetSourceLevel", (Object)this.newSourceLevel);
                }
                return NbBundle.getMessage(EnablePreview.class, (String)"FIX_EnablePreviewFeatureSetSourceLevelManual", (Object)this.newSourceLevel);
            }
            return NbBundle.getMessage(EnablePreview.class, (String)"FIX_EnablePreviewFeature");
        }

        public ChangeInfo implement() throws Exception {
            this.enabler.enablePreview(this.newSourceLevel);
            return null;
        }

        public String getNewSourceLevel() {
            return this.newSourceLevel;
        }
    }
}

